/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SpeciesRequirement
extends AbstractPokemonRequirement<RegistryValue<Species>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"species", "ndex"});
    private RegistryValue<Species> species;

    public SpeciesRequirement() {
        super(KEYS);
    }

    public SpeciesRequirement(RegistryValue<Species> species) {
        this();
        this.species = species;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> create(String spec) {
        String[] args = spec.split(" ");
        if (args == null || args.length < 1) {
            return super.create(spec);
        }
        if (args[0].equalsIgnoreCase("random")) {
            return Lists.newArrayList((Object[])new Requirement[]{this.createInstance(PixelmonSpecies.getRandomSpecies(!PixelmonConfigProxy.getGeneral().isAllowRandomPokemonToBeLegendary(), false, false).getRegistryValue())});
        }
        Optional<RegistryValue<Species>> species = PixelmonSpecies.get(args[0]);
        if (!species.isPresent()) {
            return super.create(spec);
        }
        return Lists.newArrayList((Object[])new Requirement[]{this.createInstance(species.get())});
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return Collections.singletonList(this.createInstance(PixelmonSpecies.MISSINGNO));
        }
        if (args[0].equalsIgnoreCase("random")) {
            return Lists.newArrayList((Object[])new Requirement[]{this.createInstance(PixelmonSpecies.getRandomSpecies().getRegistryValue())});
        }
        return Collections.singletonList(this.createInstance(PixelmonSpecies.fromName(args[1])));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, RegistryValue<Species>> createInstance(RegistryValue<Species> value) {
        return new SpeciesRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getSpecies().is(this.species);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setSpecies(this.species, false);
    }

    @Override
    public RegistryValue<Species> getValue() {
        return this.species;
    }

    @Override
    public boolean fits(String spec) {
        String[] args = spec.split(" ");
        if (PixelmonSpecies.has(args[0]) || args[0].equalsIgnoreCase("random")) {
            return true;
        }
        return super.fits(spec);
    }
}

