/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.util.helpers.ContainerHelper;
import com.pixelmonmod.pixelmon.items.ItemData;
import com.pixelmonmod.pixelmon.items.PokeBagItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;

public class BattleItemScanner {
    private static final List<InventoryScanner> SCANNERS = Lists.newArrayList();

    private BattleItemScanner() {
        throw new IllegalStateException("Cannot instantiate this class");
    }

    public static void addScanner(InventoryScanner scanner) {
        SCANNERS.add(scanner);
    }

    public static List<ItemData> scan(ServerPlayerEntity player, BagSection section) {
        ArrayList itemData = Lists.newArrayList();
        BattleItemScanner.checkInventory(player, section, (IInventory)player.field_71071_by, (List<ItemData>)itemData);
        return itemData;
    }

    public static void checkInventory(ServerPlayerEntity player, BagSection section, IInventory inventory, List<ItemData> items) {
        BattleItemScanner.checkInventory(player, section, ContainerHelper.getAllItems(inventory), items);
    }

    public static void checkInventory(ServerPlayerEntity player, BagSection section, List<ItemStack> inventory, List<ItemData> items) {
        BattleItemScanner.checkInventory(player, section, inventory, true, items);
    }

    public static void checkInventory(ServerPlayerEntity player, BagSection section, List<ItemStack> inventory, boolean checkSubInventories, List<ItemData> items) {
        for (ItemStack stack : inventory) {
            if (stack == null || stack.func_190926_b()) continue;
            boolean matched = false;
            if (checkSubInventories) {
                for (InventoryScanner scanner : SCANNERS) {
                    if (!scanner.testItem(stack)) continue;
                    matched = true;
                    scanner.collectItems(player, section, inventory, stack, items);
                    break;
                }
            }
            if (matched) continue;
            BattleItemScanner.addItem(section, stack, items);
        }
    }

    public static void addItem(BagSection section, ItemStack stack, List<ItemData> items) {
        if (!section.isItem(stack)) {
            return;
        }
        if (!BattleItemScanner.attemptUpdate(stack, items)) {
            items.add(new ItemData(stack.func_77946_l()));
        }
    }

    public static boolean attemptUpdate(ItemStack stack, List<ItemData> items) {
        for (ItemData itemDatum : items) {
            if (!ItemStack.func_179545_c((ItemStack)itemDatum.getItemStack(), (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)itemDatum.getItemStack(), (ItemStack)stack)) continue;
            itemDatum.getItemStack().func_190920_e(itemDatum.getItemStack().func_190916_E() + stack.func_190916_E());
            return true;
        }
        return false;
    }

    public static ItemStack findMatchingItem(ItemStack toMatch, ServerPlayerEntity player) {
        return BattleItemScanner.findMatchingItem(toMatch, player, (IInventory)player.field_71071_by);
    }

    public static ItemStack findMatchingItem(ItemStack toMatch, ServerPlayerEntity player, IInventory inventory) {
        ItemStack playerInventoryCheck = BattleItemScanner.findItemFromIterable(toMatch, inventory.func_70302_i_(), arg_0 -> ((IInventory)inventory).func_70301_a(arg_0));
        if (playerInventoryCheck != null) {
            return playerInventoryCheck;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryItem = inventory.func_70301_a(i);
            ItemStack foundItem = null;
            for (InventoryScanner scanner : SCANNERS) {
                if (scanner.testItem(inventoryItem) && (foundItem = scanner.findItem(player, inventoryItem, toMatch)) != null) break;
            }
            if (foundItem == null) continue;
            return foundItem;
        }
        return null;
    }

    public static ItemStack findItemFromIterable(ItemStack toMatch, int size, IntFunction<ItemStack> getter) {
        for (int i = 0; i < size; ++i) {
            ItemStack stack = getter.apply(i);
            if (!ItemStack.func_179545_c((ItemStack)toMatch, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)toMatch, (ItemStack)stack)) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack consumeItem(ItemStack toMatch, ServerPlayerEntity player) {
        return BattleItemScanner.consumeItem(toMatch, player, (IInventory)player.field_71071_by);
    }

    public static ItemStack consumeItem(ItemStack toMatch, ServerPlayerEntity player, IInventory inventory) {
        int i;
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)toMatch) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)toMatch)) continue;
            inventory.func_70298_a(i, 1);
            return itemStack;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryItem = inventory.func_70301_a(i);
            ItemStack consumedItem = null;
            for (InventoryScanner scanner : SCANNERS) {
                if (scanner.testItem(inventoryItem) && (consumedItem = scanner.consumeItem(player, inventoryItem, toMatch)) != null) break;
            }
            if (consumedItem == null) continue;
            return consumedItem;
        }
        return null;
    }

    static {
        BattleItemScanner.addScanner(new InventoryScanner(stack -> stack.func_77973_b() instanceof PokeBagItem, (player, section, inventory, stack, items) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((PlayerEntity)player, stack);
            if (pokeBag != null) {
                BattleItemScanner.checkInventory(player, section, (IInventory)pokeBag.inventory, (List<ItemData>)items);
            }
        }, (player, inventory, toMatch) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((PlayerEntity)player, inventory);
            if (pokeBag == null) {
                return null;
            }
            return BattleItemScanner.findItemFromIterable(toMatch, pokeBag.inventory.func_70302_i_(), i -> pokeBag.inventory.func_70301_a(i));
        }, (player, inventory, toMatch) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((PlayerEntity)player, inventory);
            if (pokeBag == null) {
                return null;
            }
            for (int i = 0; i < pokeBag.inventory.func_70302_i_(); ++i) {
                ItemStack slot = pokeBag.inventory.func_70301_a(i);
                if (!ItemStack.func_179545_c((ItemStack)slot, (ItemStack)toMatch) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)toMatch)) continue;
                pokeBag.inventory.func_70298_a(i, 1);
                pokeBag.writeToStack(inventory);
                return slot;
            }
            return null;
        }));
        BattleItemScanner.addScanner(new InventoryScanner(stack -> Block.func_149634_a((Item)stack.func_77973_b()) instanceof ShulkerBoxBlock, (player, section, inventory, stack, items) -> {
            CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
            if (compoundnbt != null && compoundnbt.func_74764_b("Items")) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                BattleItemScanner.checkInventory(player, section, (List<ItemStack>)nonnulllist, false, items);
            }
        }, (player, inventory, toMatch) -> {
            CompoundNBT compoundnbt = inventory.func_179543_a("BlockEntityTag");
            if (compoundnbt == null || !compoundnbt.func_74764_b("Items")) {
                return null;
            }
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
            return BattleItemScanner.findItemFromIterable(toMatch, nonnulllist.size(), arg_0 -> ((NonNullList)nonnulllist).get(arg_0));
        }, (player, inventory, toMatch) -> {
            CompoundNBT compoundnbt = inventory.func_179543_a("BlockEntityTag");
            if (compoundnbt == null || !compoundnbt.func_74764_b("Items")) {
                return null;
            }
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack stack = (ItemStack)nonnulllist.get(i);
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)toMatch) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toMatch)) continue;
                ItemStackHelper.func_188382_a((List)nonnulllist, (int)i, (int)1);
                ItemStackHelper.func_191282_a((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                return stack;
            }
            return null;
        }));
    }

    @FunctionalInterface
    public static interface ItemConsumer {
        public ItemStack consume(ServerPlayerEntity var1, ItemStack var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface ItemFinder {
        public ItemStack find(ServerPlayerEntity var1, ItemStack var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface ItemScanner {
        public void scan(ServerPlayerEntity var1, BagSection var2, List<ItemStack> var3, ItemStack var4, List<ItemData> var5);
    }

    public static class InventoryScanner {
        private final Predicate<ItemStack> predicate;
        private final ItemScanner scanner;
        private final ItemFinder finder;
        private final ItemConsumer consumer;

        public InventoryScanner(Predicate<ItemStack> predicate, ItemScanner scanner, ItemFinder finder, ItemConsumer consumer) {
            this.predicate = predicate;
            this.scanner = scanner;
            this.finder = finder;
            this.consumer = consumer;
        }

        protected boolean testItem(ItemStack stack) {
            return stack != null && this.predicate.test(stack);
        }

        protected void collectItems(ServerPlayerEntity player, BagSection section, List<ItemStack> inventory, ItemStack stack, List<ItemData> items) {
            this.scanner.scan(player, section, inventory, stack, items);
        }

        protected ItemStack findItem(ServerPlayerEntity player, ItemStack inventory, ItemStack toMatch) {
            return this.finder.find(player, inventory, toMatch);
        }

        protected ItemStack consumeItem(ServerPlayerEntity player, ItemStack inventory, ItemStack toMatch) {
            return this.consumer.consume(player, inventory, toMatch);
        }
    }
}

