/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.economy;

import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import java.math.BigDecimal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class EconomyEvent
extends Event {
    private final ServerPlayerEntity player;
    private final BankAccount account;

    public EconomyEvent(ServerPlayerEntity player, BankAccount account) {
        this.player = player;
        this.account = account;
    }

    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public BankAccount getAccount() {
        return this.account;
    }

    public static enum TransactionType {
        DEPOSIT,
        WITHDRAW;

    }

    public static class PostTransaction
    extends EconomyEvent {
        private final TransactionType type;
        private final BigDecimal oldBalance;
        private final BigDecimal newBalance;

        public PostTransaction(ServerPlayerEntity player, BankAccount bankAccount, TransactionType type, BigDecimal oldBalance, BigDecimal newBalance) {
            super(player, bankAccount);
            this.type = type;
            this.oldBalance = oldBalance;
            this.newBalance = newBalance;
        }

        public TransactionType getType() {
            return this.type;
        }

        public BigDecimal getOldBalance() {
            return this.oldBalance;
        }

        public BigDecimal getNewBalance() {
            return this.newBalance;
        }

        public BigDecimal getDifference() {
            return this.oldBalance.subtract(this.newBalance);
        }

        public boolean isCancelable() {
            return false;
        }
    }

    @Cancelable
    public static class PreTransaction
    extends EconomyEvent {
        private final TransactionType type;
        private final BigDecimal balance;
        private BigDecimal change;

        public PreTransaction(ServerPlayerEntity player, BankAccount bankAccount, TransactionType type, BigDecimal balance, BigDecimal change) {
            super(player, bankAccount);
            this.type = type;
            this.balance = balance;
            this.change = change;
        }

        public TransactionType getType() {
            return this.type;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public BigDecimal getChange() {
            return this.change;
        }

        public void setChange(BigDecimal change) {
            this.change = change;
        }
    }

    public static class SetBalance
    extends EconomyEvent {
        private BigDecimal balance;

        public SetBalance(ServerPlayerEntity player, BankAccount bankAccount, BigDecimal balance) {
            super(player, bankAccount);
            this.balance = balance;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }
    }

    public static class GetBalance
    extends EconomyEvent {
        private BigDecimal balance;

        public GetBalance(ServerPlayerEntity player, BankAccount bankAccount, BigDecimal balance) {
            super(player, bankAccount);
            this.balance = balance;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }

        public boolean isCancelable() {
            return false;
        }
    }
}

