/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class MailEvent
extends Event {
    protected final ServerPlayerEntity player;

    public MailEvent(@Nonnull ServerPlayerEntity player) {
        this.player = player;
    }

    @Nonnull
    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public static abstract class ReadMail
    extends MailEvent {
        protected ItemStack itemStack;
        protected final String author;
        protected final String text;
        protected final boolean sealed;

        public ReadMail(@Nonnull ServerPlayerEntity player, ItemStack itemStack, String author, String text, boolean sealed) {
            super(player);
            this.itemStack = itemStack;
            this.author = author;
            this.text = text;
            this.sealed = sealed;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Nullable
        public String getAuthor() {
            return this.author;
        }

        public String getText() {
            return this.text;
        }

        public boolean isSealed() {
            return this.sealed;
        }

        public static class Post
        extends ReadMail {
            public Post(@Nonnull ServerPlayerEntity player, ItemStack itemStack, String author, String text, boolean sealed) {
                super(player, itemStack, author, text, sealed);
            }
        }

        @Cancelable
        public static class Pre
        extends ReadMail {
            public Pre(@Nonnull ServerPlayerEntity player, ItemStack itemStack, String author, String text, boolean sealed) {
                super(player, itemStack, author, text, sealed);
            }
        }
    }

    public static abstract class SealMail
    extends MailEvent {
        protected ItemStack openItemStack;
        protected ItemStack closedItemStack;
        protected String text;
        protected String author;

        public SealMail(@Nonnull ServerPlayerEntity player, ItemStack openItemStack, ItemStack closedItemStack, String text, String author) {
            super(player);
            this.openItemStack = openItemStack;
            this.closedItemStack = closedItemStack;
            this.text = text;
            this.author = author;
        }

        public ItemStack getOpenItemStack() {
            return this.openItemStack;
        }

        public ItemStack getSealedItemStack() {
            return this.closedItemStack;
        }

        public String getText() {
            return this.text;
        }

        public String getAuthor() {
            return this.author;
        }

        public static class Post
        extends SealMail {
            public Post(@Nonnull ServerPlayerEntity player, ItemStack openItemStack, ItemStack closedItemStack, String text, String author) {
                super(player, openItemStack, closedItemStack, text, author);
            }
        }

        @Cancelable
        public static class Pre
        extends SealMail {
            public Pre(@Nonnull ServerPlayerEntity player, ItemStack openItemStack, ItemStack closedItemStack, String text, String author) {
                super(player, openItemStack, closedItemStack, text, author);
            }

            public void setText(String text) {
                this.text = text;
            }

            public void setAuthor(String author) {
                this.author = author;
            }

            public void setClosedItemStack(ItemStack closedItemStack) {
                this.closedItemStack = closedItemStack;
            }

            public void setOpenItemStack(ItemStack openItemStack) {
                this.openItemStack = openItemStack;
            }
        }
    }

    public static abstract class EditMail
    extends MailEvent {
        protected ItemStack mailItem;
        protected String beforeText;
        protected String afterText;

        public EditMail(@Nonnull ServerPlayerEntity player, ItemStack mailItem, String beforeText, String afterText) {
            super(player);
            this.mailItem = mailItem;
            this.beforeText = beforeText;
            this.afterText = afterText;
        }

        public ItemStack getMailItem() {
            return this.mailItem;
        }

        public String getBeforeText() {
            return this.beforeText;
        }

        public String getAfterText() {
            return this.afterText;
        }

        public static class Post
        extends EditMail {
            public Post(@Nonnull ServerPlayerEntity player, ItemStack mailItem, String beforeText, String afterText) {
                super(player, mailItem, beforeText, afterText);
            }
        }

        @Cancelable
        public static class Pre
        extends EditMail {
            public Pre(@Nonnull ServerPlayerEntity player, ItemStack mailItem, String beforeText, String afterText) {
                super(player, mailItem, beforeText, afterText);
            }

            public void setMailItem(ItemStack mailItem) {
                this.mailItem = mailItem;
            }

            public void setAfterText(String afterText) {
                this.afterText = afterText;
            }
        }
    }
}

