/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public abstract class IgnoreWeather
extends AbstractAbility {
    private String switchInMessage;

    public IgnoreWeather(String switchInMessage) {
        this.switchInMessage = switchInMessage;
    }

    @Override
    public boolean ignoreWeather() {
        return true;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.globalStatusController.canWeatherChange(null)) {
            newPokemon.bc.sendToAll(this.switchInMessage, newPokemon.getNickname());
            newPokemon.bc.globalStatusController.triggerWeatherChange(null);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        for (PixelmonWrapper pw : oldPokemon.bc.getActiveUnfaintedPokemon()) {
            if (pw == oldPokemon || !pw.getBattleAbility().ignoreWeather()) continue;
            return;
        }
        if (oldPokemon.bc.globalStatusController.canWeatherChange(oldPokemon.bc.globalStatusController.getWeather())) {
            oldPokemon.bc.globalStatusController.triggerWeatherChange(oldPokemon.bc.globalStatusController.getWeather());
        }
    }
}

