/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.api.SpecificationTypeAdapter;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.species.SpeciesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.StatsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.AggressionChances;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.gimmick.Gigantamax;
import com.pixelmonmod.pixelmon.api.pokemon.species.moves.Moves;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PalettePropertiesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.Movement;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.RidingOffsets;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.FlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.mounted.MountedFlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.swimming.SwimmingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.spawn.SpawnData;
import com.pixelmonmod.pixelmon.api.pokemon.species.stat.ImmutableBattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.species.tags.FormTags;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.AbilitiesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.AggressionChancesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.DimensionsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.EVYieldsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.FlyingParametersTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.FormTagsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.GenderPropertiesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.GigantamaxTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.ImmutableBattleStatsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.ModelLocatorTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.MountedFlyingParametersTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.MovementTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.MovesTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.ResourceLocationTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.ResourceWithFallbackTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.RidingOffsetsTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.SpawnDataTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.SwimmingParametersTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters.Vector3fTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.stats.AttackTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ImmutableAttackTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.EvoConditionTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.EvolutionTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;

public class Species
implements ITranslatable,
Comparable<Species> {
    public static final Gson GSON;
    private final String name;
    private final String translationKey;
    private final int dex;
    private final int generation;
    private final ImmutableList<String> defaultForms;
    private final Map<String, Stats> forms;
    private final transient String json;
    private transient RegistryValue<Species> registryValue = null;

    public Species(String name, String translationKey, int dex, int generation, Collection<String> defaultForms, Collection<Stats> forms, String json) {
        this.name = name;
        this.translationKey = translationKey;
        this.dex = dex;
        this.generation = generation;
        this.defaultForms = defaultForms == null ? ImmutableList.of((Object)"") : ImmutableList.copyOf(defaultForms);
        this.forms = new HashMap<String, Stats>();
        for (Stats form : forms) {
            this.forms.put(form.getName().toLowerCase(Locale.ROOT), form);
            form.setParentSpecies(this);
        }
        this.json = json;
    }

    public String getName() {
        return this.name;
    }

    public String getStrippedName() {
        return StringHelper.stripSpecialCharacters(this.name);
    }

    public int getDex() {
        return this.dex;
    }

    public String getFormattedDex() {
        return String.format("%03d", this.getDex());
    }

    public RegistryValue<Species> getRegistryValue() {
        if (this.registryValue == null) {
            this.registryValue = RegistryManager.getRegistryValue(this);
        }
        return this.registryValue;
    }

    public List<String> getDefaultFormNames() {
        return this.defaultForms;
    }

    public boolean isDefaultForm(String form) {
        return this.defaultForms.contains((Object)form);
    }

    public boolean isDefaultForm(Stats form) {
        return this.isDefaultForm(form.name);
    }

    public List<Stats> getDefaultForms() {
        List<Stats> forms = this.getForms();
        forms.removeIf(form -> !this.defaultForms.contains((Object)form.name));
        return forms;
    }

    public Stats getDefaultForm() {
        return this.forms.get(RandomHelper.getRandomElementFromCollection(this.defaultForms));
    }

    public Stats getFirstForm() {
        return this.forms.get(this.defaultForms.get(0));
    }

    public Stats getDefaultFormExcluding(String ... forms) {
        ArrayList defaultForms = Lists.newArrayList(this.defaultForms);
        HashSet toRemove = Sets.newHashSet((Object[])forms);
        defaultForms.removeIf(toRemove::contains);
        return this.forms.get(RandomHelper.getRandomElementFromCollection(defaultForms));
    }

    public List<Stats> getForms() {
        return Lists.newArrayList(this.forms.values());
    }

    public Stats getForm(String formName) {
        return this.forms.get(formName.toLowerCase(Locale.ROOT));
    }

    public List<Stats> getForms(boolean temporary) {
        ArrayList stats = Lists.newArrayList();
        for (Stats value : this.forms.values()) {
            if (value.getTags().isTemporary() && !temporary) continue;
            stats.add(value);
        }
        return stats;
    }

    public List<Stats> getForms(String ... tags) {
        ArrayList stats = Lists.newArrayList();
        for (Stats value : this.forms.values()) {
            if (!value.getTags().hasTags(tags)) continue;
            stats.add(value);
        }
        return stats;
    }

    public boolean hasFlaggedForm(boolean temporary, String ... flags) {
        for (Stats value : this.forms.values()) {
            if (value.getTags().isTemporary() && !temporary) continue;
            for (String flag : flags) {
                if (!value.getTags().hasTag(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFormWithType(Element type) {
        Iterator<Stats> iterator = this.getForms().iterator();
        if (iterator.hasNext()) {
            Stats form = iterator.next();
            return form.hasType(type);
        }
        return false;
    }

    public List<Stats> getForms(Predicate<Stats> predicate) {
        ArrayList forms = Lists.newArrayList();
        for (Stats value : this.forms.values()) {
            if (!predicate.test(value)) continue;
            forms.add(value);
        }
        return forms;
    }

    public PaletteProperties getFirstPaletteProperties() {
        return this.getFirstForm().getFirstGenderProperties().getDefaultPalette();
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public String getTranslationKey() {
        if (!this.translationKey.isEmpty()) {
            return this.translationKey;
        }
        return "pixelmon." + this.name.toLowerCase(Locale.US);
    }

    public String getNameTranslationKey() {
        return this.getTranslationKey() + "";
    }

    public String getDescTranslationKey() {
        return this.getTranslationKey() + ".description";
    }

    public TranslationTextComponent getNameTranslation() {
        return new TranslationTextComponent(this.getNameTranslationKey());
    }

    public TranslationTextComponent getDescTranslation() {
        return new TranslationTextComponent(this.getDescTranslationKey());
    }

    public boolean is(Species ... species) {
        for (Species s : species) {
            if (this.dex != s.dex) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean is(Optional<Species> ... species) {
        for (Optional<Species> s : species) {
            if (!s.isPresent() || this.dex != s.get().getDex()) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean is(RegistryValue<Species> ... species) {
        for (RegistryValue<Species> s : species) {
            if (!s.isInitialized() || this.dex != s.getValueUnsafe().getDex()) continue;
            return true;
        }
        return false;
    }

    public boolean hasForm(String form) {
        return this.forms.containsKey(form.toLowerCase(Locale.ROOT));
    }

    public boolean isLegendary() {
        return PixelmonSpecies.isLegendary(this);
    }

    public boolean isUltraBeast() {
        return PixelmonSpecies.isUltraBeast(this);
    }

    public boolean isMythical() {
        return PixelmonSpecies.isMythical(this);
    }

    public void decode(PacketBuffer buf) {
    }

    public void encode(PacketBuffer buf) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Species)) {
            return false;
        }
        Species species = (Species)o;
        return this.getDex() == species.getDex();
    }

    public int hashCode() {
        return this.getDex();
    }

    public String getJson() {
        return this.json;
    }

    @Override
    public int compareTo(Species species) {
        return Integer.compare(this.getDex(), species.getDex());
    }

    public String toString() {
        return "Species@" + Integer.toHexString(this.hashCode()) + "{name=" + this.name + "}";
    }

    static {
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Attack.class, (Object)new AttackTypeAdapter()).registerTypeAdapter(ImmutableAttack.class, (Object)new ImmutableAttackTypeAdapter()).registerTypeAdapter(Abilities.class, (Object)new AbilitiesTypeAdapter()).registerTypeAdapter(AggressionChances.class, (Object)new AggressionChancesTypeAdapter()).registerTypeAdapter(Dimensions.class, (Object)new DimensionsTypeAdapter()).registerTypeAdapter(PokemonSpecification.class, new SpecificationTypeAdapter(PokemonSpecification.class)).registerTypeAdapter(Evolution.class, (Object)new EvolutionTypeAdapter()).registerTypeAdapter(EvoCondition.class, (Object)new EvoConditionTypeAdapter()).registerTypeAdapter(EVYields.class, (Object)new EVYieldsTypeAdapter()).registerTypeAdapter(FlyingParameters.class, (Object)new FlyingParametersTypeAdapter()).registerTypeAdapter(FormTags.class, (Object)new FormTagsTypeAdapter()).registerTypeAdapter(GenderProperties.class, (Object)new GenderPropertiesTypeAdapter()).registerTypeAdapter(Gigantamax.class, (Object)new GigantamaxTypeAdapter()).registerTypeAdapter(ImmutableBattleStats.class, (Object)new ImmutableBattleStatsTypeAdapter()).registerTypeAdapter(MountedFlyingParameters.class, (Object)new MountedFlyingParametersTypeAdapter()).registerTypeAdapter(Movement.class, (Object)new MovementTypeAdapter()).registerTypeAdapter(Moves.class, (Object)new MovesTypeAdapter()).registerTypeAdapter(PaletteProperties.class, (Object)new PalettePropertiesTypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeAdapter(ResourceWithFallback.class, (Object)new ResourceWithFallbackTypeAdapter()).registerTypeAdapter(RidingOffsets.class, (Object)new RidingOffsetsTypeAdapter()).registerTypeAdapter(SpawnData.class, (Object)new SpawnDataTypeAdapter()).registerTypeAdapter(SwimmingParameters.class, (Object)new SwimmingParametersTypeAdapter()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fTypeAdapter()).registerTypeAdapter(Stats.class, (Object)new StatsTypeAdapter()).registerTypeAdapter(Species.class, (Object)new SpeciesTypeAdapter()).registerTypeAdapter(ModelLocator.class, (Object)new ModelLocatorTypeAdapter()).serializeNulls();
        GSON = gson.create();
    }
}

