/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.gimmick;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.Optional;

public class Gigantamax {
    private final boolean canHaveFactor;
    private final boolean canGigantamax;
    private final String form;
    private final ImmutableAttack move;
    private final transient Element type;

    public Gigantamax() {
        this(false);
    }

    public Gigantamax(boolean canHaveFactor) {
        this.canHaveFactor = canHaveFactor;
        this.canGigantamax = false;
        this.form = "";
        this.move = null;
        this.type = null;
    }

    public Gigantamax(String form, String move) {
        Optional<ImmutableAttack> oMove = AttackRegistry.getAttackBase(move);
        if (oMove.isPresent()) {
            this.canHaveFactor = true;
            this.canGigantamax = true;
            this.form = form;
            this.move = oMove.get();
            this.type = this.move.getAttackType();
        } else {
            Pixelmon.LOGGER.error("Failed to parse G-Max move: " + move);
            this.canHaveFactor = false;
            this.canGigantamax = false;
            this.form = "";
            this.move = null;
            this.type = null;
        }
    }

    public boolean canHaveFactor() {
        return this.canHaveFactor;
    }

    public boolean canGigantamax() {
        return this.canHaveFactor && this.canGigantamax;
    }

    public boolean canGigantamax(Pokemon pokemon) {
        return pokemon.hasGigantamaxFactor() && this.canGigantamax();
    }

    public String getForm() {
        return this.form;
    }

    public ImmutableAttack getMove() {
        return this.move;
    }

    public Element getType() {
        return this.type;
    }

    public ImmutableAttack getMoveIfTypeMatches(Element type) {
        if (this.canGigantamax() && this.getType() == type) {
            return this.getMove();
        }
        return null;
    }
}

