/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.lang.reflect.Type;
import java.util.Locale;

public enum BattleStatsType implements ITranslatable
{
    NONE(-1, -1),
    HP(7, 0),
    ATTACK(2, 1),
    DEFENSE(3, 2),
    SPECIAL_ATTACK(4, 3),
    SPECIAL_DEFENSE(5, 4),
    SPEED(6, 5),
    ACCURACY(0, -1),
    EVASION(1, -1);

    public static final BattleStatsType[] EV_IV_STATS;
    public static final BattleStatsType[] UNIQUE_BATTLE_STATS;
    public static final BattleStatsType[] ALL_BATTLE_STATS;
    public static final BattleStatsType[] BATTLE_ONLY_STATS;
    private final int index;
    private final int battleIndex;

    private BattleStatsType(int index, int battleIndex) {
        this.index = index;
        this.battleIndex = battleIndex;
    }

    public static boolean isStatsEffect(String effectTypeString) {
        try {
            BattleStatsType.valueOf(effectTypeString.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static BattleStatsType getStatsEffect(String effectTypeString) {
        try {
            return BattleStatsType.valueOf(effectTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getStatIndex() {
        return this.index;
    }

    public int getBattleStatIndex() {
        return this.battleIndex;
    }

    @Override
    public String getTranslationKey() {
        if (this == NONE) {
            return "";
        }
        return "enum.stat." + this.name().toLowerCase(Locale.ROOT);
    }

    public static BattleStatsType[] getEVIVStatValues() {
        return EV_IV_STATS;
    }

    public static BattleStatsType[] getUniqueBattleStatValues() {
        return UNIQUE_BATTLE_STATS;
    }

    public static BattleStatsType[] getAllBattleStatValues() {
        return ALL_BATTLE_STATS;
    }

    public static BattleStatsType[] getBattleOnlyStatValues() {
        return BATTLE_ONLY_STATS;
    }

    public static BattleStatsType getRandomBattleMutableStat() {
        return EV_IV_STATS[RandomHelper.getRandomNumberBetween(1, 5)];
    }

    public static BattleStatsType fromBattleIndex(int battleIndex) {
        for (BattleStatsType value : BattleStatsType.values()) {
            if (value.battleIndex != battleIndex) continue;
            return value;
        }
        return null;
    }

    public static BattleStatsType fromIndex(int index) {
        for (BattleStatsType value : BattleStatsType.values()) {
            if (value.index != index) continue;
            return value;
        }
        return null;
    }

    static {
        EV_IV_STATS = new BattleStatsType[]{HP, ATTACK, DEFENSE, SPECIAL_ATTACK, SPECIAL_DEFENSE, SPEED};
        UNIQUE_BATTLE_STATS = new BattleStatsType[]{ATTACK, DEFENSE, SPECIAL_ATTACK, SPECIAL_DEFENSE, SPEED};
        ALL_BATTLE_STATS = new BattleStatsType[]{ATTACK, DEFENSE, SPECIAL_ATTACK, SPECIAL_DEFENSE, SPEED, ACCURACY, EVASION};
        BATTLE_ONLY_STATS = new BattleStatsType[]{ACCURACY, EVASION};
    }

    public static class TypeAdapter
    implements JsonSerializer<BattleStatsType>,
    JsonDeserializer<BattleStatsType> {
        public BattleStatsType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return BattleStatsType.valueOf(json.getAsString().toUpperCase());
        }

        public JsonElement serialize(BattleStatsType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }
}

