/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.IVsRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.LevelRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.LureItem;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpawnInfoPokemon
extends SpawnInfo {
    public static final String TYPE_ID_POKEMON = "pokemon";
    public transient Species species;
    public transient Stats form;
    private PokemonSpecification spec = PokemonSpecificationProxy.create("Psyduck");
    public int minLevel = 1;
    public int maxLevel = 100;
    public Float spawnSpecificShinyRate = null;
    public Float spawnSpecificBossRate = null;
    public Float spawnSpecificPokerusRate = null;
    public ArrayList<JsonItemStack> heldItems = null;

    public SpawnInfoPokemon() {
        super(TYPE_ID_POKEMON);
    }

    @Override
    public void onImport() {
        this.calculateRequiredSpace();
        super.onImport();
        if (this.minLevel > this.maxLevel) {
            Pixelmon.LOGGER.warn("A SpawnInfo for " + this.spec.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe().getName() + " has minLevel=" + this.minLevel + " and maxLevel=" + this.maxLevel + " which is weird. Fixing.");
            int temp = this.minLevel;
            this.minLevel = this.maxLevel;
            this.maxLevel = temp;
        }
        if (this.spec != null) {
            Pokemon dummyPokemon = this.spec.create();
            if (BetterSpawnerConfig.INSTANCE.autoTagSpecs != null) {
                for (Map.Entry<String, PokemonSpecification> entry : BetterSpawnerConfig.INSTANCE.autoTagSpecs.entrySet()) {
                    if (!entry.getValue().matches(dummyPokemon) || this.tags.contains(entry.getKey())) continue;
                    this.tags.add(entry.getKey());
                }
            }
        }
    }

    public void setPokemon(PokemonSpecification spec) {
        this.spec = spec;
        this.requiredSpace = -1;
        this.calculateRequiredSpace();
    }

    public void calculateRequiredSpace() {
        if (this.requiredSpace == -1) {
            Optional species = this.spec.getValue(SpeciesRequirement.class);
            if (species.isPresent()) {
                Dimensions boundsData = this.spec.create().getForm().getDimensions();
                this.requiredSpace = (int)Math.ceil(Math.max(boundsData.getWidth(), boundsData.getHeight()));
            } else {
                this.requiredSpace = 0;
            }
        }
    }

    public SpawnAction<PixelmonEntity> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        Pokemon pokemon = this.spec.create();
        if (!this.spec.getValue(LevelRequirement.class).isPresent()) {
            pokemon.setLevel(RandomHelper.getRandomNumberBetween(Math.min(this.minLevel, PixelmonServerConfig.maxLevel), Math.min(this.maxLevel, PixelmonServerConfig.maxLevel)));
        }
        if (this.spawnSpecificShinyRate != null) {
            if (this.spawnSpecificShinyRate.floatValue() == 0.0f && pokemon.isShiny()) {
                pokemon.setShiny(false);
            } else if (this.spawnSpecificShinyRate.floatValue() > 0.0f) {
                if (RandomHelper.getRandomChance(1.0f / this.spawnSpecificShinyRate.floatValue())) {
                    pokemon.setShiny();
                } else if (pokemon.isShiny()) {
                    pokemon.setShiny(false);
                }
            }
        } else if (this.set.setSpecificShinyRate != null) {
            if (this.set.setSpecificShinyRate.floatValue() == 0.0f && pokemon.isShiny()) {
                pokemon.setShiny(false);
            } else if (this.set.setSpecificShinyRate.floatValue() > 0.0f) {
                if (RandomHelper.getRandomChance(1.0f / this.set.setSpecificShinyRate.floatValue())) {
                    pokemon.setShiny();
                } else if (pokemon.isShiny()) {
                    pokemon.setShiny(false);
                }
            }
        } else if (PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)spawnLocation.location.world.func_234923_W_()) > 0.0f) {
            float shinyChanceMultiplier = 1.0f;
            if (spawnLocation.cause instanceof ServerPlayerEntity) {
                CaptureCombo combo;
                PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)spawnLocation.cause);
                if (party.getShinyCharm().isActive()) {
                    shinyChanceMultiplier *= PixelmonConfigProxy.getSpawning().getShinyCharmMultiplier();
                }
                if (party.getLure() != null && party.getLure().type == LureItem.LureType.SHINY) {
                    shinyChanceMultiplier *= (float)Math.sqrt(party.getLure().strength.multiplier);
                }
                boolean getsCombo = (combo = party.transientData.captureCombo).getCurrentSpecies() != null && combo.getCurrentSpecies().is(pokemon.getSpecies());
                float comboMod = getsCombo ? combo.getShinyModifier() : combo.getBaseShinyModifier();
                shinyChanceMultiplier *= comboMod;
            }
            if (RandomHelper.getRandomChance(shinyChanceMultiplier / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)spawnLocation.location.world.func_234923_W_()))) {
                pokemon.setShiny();
            } else if (pokemon.isShiny()) {
                pokemon.setShiny(false);
            }
        } else if (pokemon.isShiny()) {
            pokemon.setShiny(false);
        }
        boolean willBeBoss = false;
        BossTier bossTier = BossTierRegistry.NOT_BOSS;
        if (this.spawnSpecificBossRate != null && this.spawnSpecificBossRate.floatValue() > 0.0f && RandomHelper.getRandomChance(1.0f / this.spawnSpecificBossRate.floatValue())) {
            willBeBoss = true;
        } else if (PixelmonConfigProxy.getSpawning().getBossSpawning().getBossRate((RegistryKey<World>)spawnLocation.location.world.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getBossSpawning().getBossRate((RegistryKey<World>)spawnLocation.location.world.func_234923_W_()))) {
            willBeBoss = true;
        }
        if (willBeBoss) {
            if (PixelmonConfigProxy.getSpawning().getBossSpawning().isBossesAlwaysMegaIfPossible()) {
                boolean legendary = pokemon.getForm().getTags().isLegendary();
                if (pokemon.getForm().hasMegaForm()) {
                    bossTier = legendary ? BossTierRegistry.getBossTierOrNotBoss("ultimate") : BossTierRegistry.getRandomSpawnableMegaBossTier();
                } else if (legendary) {
                    bossTier = BossTierRegistry.getBossTierOrNotBoss("ultimate");
                }
            }
            if (bossTier == null || bossTier.isNotBoss()) {
                bossTier = BossTierRegistry.getRandomSpawnableBossTier();
            }
        }
        if (PixelmonConfigProxy.getGeneral().getPokerus().isEnabled()) {
            PokerusStrain strain = null;
            if (this.spawnSpecificPokerusRate != null) {
                if (this.spawnSpecificPokerusRate.floatValue() > 0.0f) {
                    strain = RandomHelper.getRandomChance(1.0f / this.spawnSpecificPokerusRate.floatValue()) ? PokerusStrain.getRandomType() : null;
                }
            } else if (this.set.setSpecificPokerusRate != null) {
                if (this.set.setSpecificPokerusRate.floatValue() > 0.0f) {
                    strain = RandomHelper.getRandomChance(1.0f / this.set.setSpecificPokerusRate.floatValue()) ? PokerusStrain.getRandomType() : null;
                }
            } else if (PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate() > 0.0f) {
                PokerusStrain pokerusStrain = strain = RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate()) ? PokerusStrain.getRandomType() : null;
            }
            if (strain != null) {
                pokemon.setPokerus(new Pokerus(strain));
            }
        }
        if (!this.spec.getValue(IVsRequirement.class).isPresent()) {
            int numPerf;
            PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)spawnLocation.cause);
            CaptureCombo combo = party.transientData.captureCombo;
            boolean getsCombo = combo.getCurrentSpecies() != null && combo.getCurrentSpecies().is(pokemon.getSpecies());
            int n = numPerf = getsCombo ? combo.getPerfIVCount() : combo.getBasePerfIVCount();
            if (numPerf != 0) {
                HashSet stats = Sets.newHashSet((Object[])BattleStatsType.getEVIVStatValues());
                for (int i = 0; i < numPerf; ++i) {
                    BattleStatsType type = (BattleStatsType)RandomHelper.getRandomElementFromCollection(stats);
                    stats.remove(type);
                    if (type == null) continue;
                    pokemon.getIVs().setStat(type, 31);
                }
            }
        }
        return new SpawnActionPokemon(this, spawnLocation, pokemon, bossTier);
    }

    public PokemonSpecification getPokemonSpec() {
        return this.spec;
    }

    public Species getSpecies() {
        if (this.species == null) {
            RegistryValue value = this.spec.getValue(SpeciesRequirement.class).orElse(null);
            if (value == null || !value.isInitialized()) {
                Pixelmon.LOGGER.warn("Bad Pok\u00e9mon name: " + this.spec.toString() + " in set " + this.set.id);
            } else {
                this.species = (Species)value.getValueUnsafe();
            }
        }
        return this.species;
    }

    public Stats getForm() {
        if (this.form == null) {
            String form = this.spec.getValue(FormRequirement.class).orElse(null);
            if (form != null) {
                this.form = this.getSpecies().getForm(form);
                if (this.form == null) {
                    this.form = this.getSpecies().getDefaultForm();
                }
            } else {
                this.form = this.getSpecies().getDefaultForm();
            }
        }
        return this.form;
    }

    @Override
    public String toString() {
        if (this.spec == null || this.spec.toString().equals("random")) {
            return "Random";
        }
        return new TranslationTextComponent("pixelmon." + this.getSpecies().getName().toLowerCase(Locale.ROOT), new Object[]{Locale.ROOT + ""}).getString();
    }
}

