/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackExplosion
extends AttackSystem<ExplosionData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        for (int i = 0; i < ((ExplosionData)this.getData()).getPower(); ++i) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(((ExplosionData)this.getData()).isAtTarget() ? (double)this.getEndPos()[0] : x, ((ExplosionData)this.getData()).isAtTarget() ? (double)this.getEndPos()[1] : y, ((ExplosionData)this.getData()).isAtTarget() ? (double)this.getEndPos()[2] : z, 0.0, 0.0, 0.0, ((ExplosionData)this.getData()).makeEffect(this).setNoise(30.0)));
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        Vector3d vec = ParticleMathHelper.generatePointInSphere(effect.speed, RandomHelper.getRandom());
        effect.mX = vec.field_72450_a;
        effect.mY = vec.field_72448_b;
        effect.mZ = vec.field_72449_c;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.func_70541_f(2.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        if (!effect.eol) {
            if (effect.ticker > 5) {
                effect.eol = true;
            }
            particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.99f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setMotion(particle.getMotionX() * 0.95, particle.getMotionY() * 0.95, particle.getMotionZ() * 0.95);
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.8f);
    }

    public static class ExplosionData
    extends StandardParticleAnimationData {
        private boolean atTarget = false;

        @Override
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.getSpeed() == -1.0f) {
                this.setSpeed(1.2f + RandomHelper.getRandom().nextFloat());
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.atTarget);
        }

        @Override
        public ExplosionData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.atTarget = buf.readBoolean();
            return this;
        }

        @Override
        public EffectType getEffectEnum() {
            return EffectType.EXPLOSION;
        }

        public boolean isAtTarget() {
            return this.atTarget;
        }
    }
}

