/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackRadial
extends AttackSystem<RadialData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        for (int i = 0; i < ((RadialData)this.getData()).getTotalPoints(); ++i) {
            double theta = Math.PI * (double)((float)i * 360.0f / (float)((RadialData)this.getData()).getTotalPoints()) / 180.0;
            double dx = Math.cos(theta) * (((RadialData)this.getData()).getRadius() == -1 ? Math.sqrt(((RadialData)this.getData()).getPower()) : (double)((RadialData)this.getData()).getRadius());
            double dz = Math.sin(theta) * (((RadialData)this.getData()).getRadius() == -1 ? Math.sqrt(((RadialData)this.getData()).getPower()) : (double)((RadialData)this.getData()).getRadius());
            mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(x, y, z, 0.0, 0.0, 0.0, ((RadialData)this.getData()).makeEffect(this).setEndPos(x + dx, y, z + dz)));
        }
    }

    public static class RadialData
    extends StandardParticleAnimationData {
        private int totalPoints = 36;
        private int radius = -1;

        @Override
        public EffectType getEffectEnum() {
            return EffectType.RADIAL;
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            buf.writeBoolean(this.totalPoints != 36);
            if (this.totalPoints != 36) {
                buf.writeByte(this.totalPoints);
            }
            buf.writeBoolean(this.radius != -1);
            if (this.radius != -1) {
                buf.writeByte(this.radius);
            }
            super.writeToByteBuffer(buf);
        }

        @Override
        public RadialData readFromByteBuffer(ByteBuf buf) {
            if (buf.readBoolean()) {
                this.totalPoints = buf.readUnsignedByte();
            }
            if (buf.readBoolean()) {
                this.radius = buf.readUnsignedByte();
            }
            return (RadialData)super.readFromByteBuffer(buf);
        }

        public RadialData setTotalPoints(int totalPoints) {
            this.totalPoints = totalPoints;
            return this;
        }

        public RadialData setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public int getTotalPoints() {
            return this.totalPoints;
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

