/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.ai;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class MoveChoice
implements Comparable<MoveChoice> {
    public PixelmonWrapper user;
    public Attack attack;
    public List<PixelmonWrapper> targets;
    public MoveResults result;
    public UUID switchPokemon;
    public int tier;
    public float weight;
    public static final int TIER_USELESS = 0;
    public static final int TIER_MINIMAL = 1;
    public static final int TIER_NORMAL = 2;
    public static final int TIER_KO = 3;

    public MoveChoice(PixelmonWrapper user, Attack attack, List<PixelmonWrapper> targets) {
        this.user = user;
        this.attack = attack;
        this.targets = targets;
    }

    public MoveChoice(PixelmonWrapper user, UUID switchPokemon) {
        this.user = user;
        this.switchPokemon = switchPokemon;
    }

    public boolean isAttack() {
        return this.attack != null;
    }

    public boolean isStatusMove() {
        return this.isAttack() && this.attack.getAttackCategory() == AttackCategory.STATUS;
    }

    public boolean isOffensiveMove() {
        return this.isAttack() && this.attack.getAttackCategory() != AttackCategory.STATUS;
    }

    public boolean isSameType(MoveChoice other) {
        return this.isAttack() == other.isAttack();
    }

    public boolean isSimilarWeight(MoveChoice other) {
        if (this.isMiddleTier()) {
            return this.tier == other.tier && Math.abs(this.weight - other.weight) <= 20.0f;
        }
        return this.tier == other.tier && this.weight == other.weight;
    }

    public void raiseWeight(float newWeight) {
        this.weight += newWeight;
        if (this.weight > 0.0f) {
            this.raiseTier(2);
        }
    }

    public void raiseWeightLimited(float newWeight) {
        this.raiseWeight(newWeight);
        this.weight = Math.min(this.weight, 100.0f);
    }

    public void setWeight(float newWeight) {
        this.weight = 0.0f;
        this.raiseWeight(newWeight);
    }

    public void raiseTier(int newTier) {
        this.tier = Math.max(this.tier, newTier);
    }

    public void lowerTier(int newTier) {
        this.tier = Math.min(this.tier, newTier);
    }

    public boolean isMiddleTier() {
        return this.tier == 1 || this.tier == 2;
    }

    public void resetWeight() {
        this.tier = 0;
        this.weight = 0.0f;
    }

    public boolean hitsAlly() {
        if (!this.isAttack()) {
            return false;
        }
        ArrayList<PixelmonWrapper> allies = this.user.getTeamPokemonExcludeSelf();
        for (PixelmonWrapper target : this.targets) {
            if (!allies.contains(target)) continue;
            return true;
        }
        return false;
    }

    public List<MoveChoice> createList() {
        ArrayList<MoveChoice> list = new ArrayList<MoveChoice>(1);
        list.add(this);
        return list;
    }

    @Override
    public int compareTo(MoveChoice otherChoice) {
        if (otherChoice == null) {
            return 0;
        }
        if (this.tier == otherChoice.tier) {
            return (int)(this.weight - otherChoice.weight);
        }
        return this.tier - otherChoice.tier;
    }

    public String toString() {
        String s = this.isAttack() ? this.attack.getMove().getAttackName() : "Switch";
        s = s + ", Tier " + this.tier + ", Weight " + this.weight;
        return s;
    }

    public static void checkBestChoice(MoveChoice choice, List<MoveChoice> bestChoices) {
        MoveChoice.checkBestChoice(choice, bestChoices, false);
    }

    public static void checkBestChoice(MoveChoice choice, List<MoveChoice> bestChoices, boolean excludeStatus) {
        if (choice.tier == 0 || excludeStatus && choice.isStatusMove()) {
            return;
        }
        if (bestChoices.isEmpty()) {
            bestChoices.add(choice);
        } else {
            int compare = bestChoices.get(0).compareTo(choice);
            if (compare <= 0) {
                if (compare < 0) {
                    bestChoices.clear();
                }
                bestChoices.add(choice);
            }
        }
    }

    public static float getMaxPriority(List<MoveChoice> choices) {
        float priority = 0.0f;
        boolean initialized = false;
        if (choices != null) {
            for (MoveChoice userChoice : choices) {
                if (userChoice.result == null) continue;
                priority = initialized ? Math.max(priority, userChoice.result.priority) : userChoice.result.priority;
                initialized = true;
            }
        }
        return priority;
    }

    public static boolean canOutspeed(List<MoveChoice> opponentChoices, PixelmonWrapper pw, List<MoveChoice> userChoices) {
        float userPriority = MoveChoice.getMaxPriority(userChoices);
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!(opponentChoice.result.priority > userPriority) && (opponentChoice.result.priority != userPriority || pw.bc.getFirstMover(pw, opponentChoice.user) != opponentChoice.user)) continue;
            return true;
        }
        return false;
    }

    public static boolean canOHKO(List<MoveChoice> opponentChoices, PixelmonWrapper pw) {
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !opponentChoice.targets.contains(pw) || opponentChoice.tier < 3) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutspeedAndOHKO(List<MoveChoice> opponentChoices, PixelmonWrapper pw, List<MoveChoice> userChoices) {
        float userPriority = MoveChoice.getMaxPriority(userChoices);
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !opponentChoice.targets.contains(pw) || opponentChoice.tier < 3 || !(opponentChoice.result.priority > userPriority) && (opponentChoice.result.priority != userPriority || pw.bc.getFirstMover(pw, opponentChoice.user) != opponentChoice.user)) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutspeedAnd2HKO(List<MoveChoice> opponentChoices, PixelmonWrapper pw) {
        return MoveChoice.canOutspeedAnd2HKO(opponentChoices, pw, null);
    }

    public static boolean canOutspeedAnd2HKO(List<MoveChoice> opponentChoices, PixelmonWrapper pw, List<MoveChoice> userChoices) {
        return MoveChoice.canOutspeedAndKO(2, opponentChoices, pw, userChoices);
    }

    public static boolean canOutspeedAndKO(int numTurns, List<MoveChoice> opponentChoices, PixelmonWrapper pw, List<MoveChoice> userChoices) {
        float userPriority = MoveChoice.getMaxPriority(userChoices);
        int weightThreshold = 100 / numTurns;
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !opponentChoice.targets.contains(pw)) continue;
            if (opponentChoice.tier >= 3) {
                return true;
            }
            if (!(opponentChoice.weight >= (float)weightThreshold) || !opponentChoice.isMiddleTier() || !(opponentChoice.result.priority > userPriority) && (opponentChoice.result.priority != userPriority || pw.bc.getFirstMover(pw, opponentChoice.user) != opponentChoice.user)) continue;
            return true;
        }
        return false;
    }

    public static boolean canKOFromFull(List<MoveChoice> opponentChoices, PixelmonWrapper pw, int numTurns) {
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !opponentChoice.targets.contains(pw) || opponentChoice.result.fullDamage * numTurns < pw.getMaxHealth()) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean hasSuccessfulAttackChoice(List<MoveChoice> choices, Optional<ImmutableAttack> ... attackNames) {
        for (MoveChoice choice : choices) {
            if (!choice.isAttack() || !choice.attack.isAttack(attackNames) || choice.result != null && choice.result.result == AttackResult.failed) continue;
            return true;
        }
        return false;
    }

    public static List<MoveChoice> getAffectedChoices(MoveChoice choice, List<MoveChoice> opponentChoices) {
        ArrayList<MoveChoice> affectedChoices = new ArrayList<MoveChoice>(opponentChoices.size());
        if (choice.targets != null) {
            for (MoveChoice opponentChoice : opponentChoices) {
                if (!opponentChoice.isAttack() || !choice.targets.contains(opponentChoice.user)) continue;
                affectedChoices.add(opponentChoice);
            }
        }
        return affectedChoices;
    }

    public static List<MoveChoice> getTargetedChoices(PixelmonWrapper pw, List<MoveChoice> opponentChoices) {
        ArrayList<MoveChoice> targetedChoices = new ArrayList<MoveChoice>(opponentChoices.size());
        for (MoveChoice opponentChoice : opponentChoices) {
            if (opponentChoice.targets == null || !opponentChoice.targets.contains(pw)) continue;
            targetedChoices.add(opponentChoice);
        }
        return targetedChoices;
    }

    @SafeVarargs
    public static boolean hasPriority(List<MoveChoice> ... choices) {
        for (List<MoveChoice> list : choices) {
            for (MoveChoice choice : list) {
                if (!choice.isAttack() || choice.attack.getMove().getPriority(choice.user) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static List<List<MoveChoice>> splitChoices(List<PixelmonWrapper> pokemonList, List<MoveChoice> choices) {
        ArrayList<List<MoveChoice>> splitList = new ArrayList<List<MoveChoice>>(pokemonList.size());
        for (PixelmonWrapper pw : pokemonList) {
            ArrayList<MoveChoice> pokemonChoices = new ArrayList<MoveChoice>();
            for (MoveChoice choice : choices) {
                if (choice.user != pw) continue;
                pokemonChoices.add(choice);
            }
            splitList.add(pokemonChoices);
        }
        return splitList;
    }

    public static List<MoveChoice> mergeChoices(List<List<MoveChoice>> choices) {
        ArrayList<MoveChoice> mergeList = new ArrayList<MoveChoice>();
        for (List<MoveChoice> choiceList : choices) {
            mergeList.addAll(choiceList);
        }
        return mergeList;
    }

    public static List<MoveChoice> createChoicesFromChoices(PixelmonWrapper pw, List<MoveChoice> choices, boolean includeAllies) {
        ArrayList<MoveChoice> newChoices = new ArrayList<MoveChoice>();
        for (MoveChoice choice : choices) {
            if (!choice.isAttack()) continue;
            newChoices.addAll(choice.attack.createMoveChoices(pw, includeAllies));
        }
        return newChoices;
    }

    public static float getMaxDamagePercent(PixelmonWrapper pw, List<MoveChoice> opponentChoices) {
        float damagePercent = 0.0f;
        for (MoveChoice opponentChoice : opponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !opponentChoice.targets.contains(pw)) continue;
            if (opponentChoice.tier >= 3) {
                return 100.0f;
            }
            float effectivePercent = opponentChoice.result.damage / opponentChoice.targets.size();
            damagePercent = Math.max(damagePercent, effectivePercent);
        }
        return damagePercent;
    }

    public static List<MoveChoice> createMoveChoicesFromList(List<Attack> possibleAttacks, PixelmonWrapper pw) {
        ArrayList<MoveChoice> possibleChoices = new ArrayList<MoveChoice>();
        for (Attack possibleAttack : possibleAttacks) {
            possibleAttack.createMoveChoices(pw, possibleChoices, false);
        }
        return possibleChoices;
    }

    public static boolean hasAttackCategory(List<MoveChoice> choices, AttackCategory category) {
        for (MoveChoice choice : choices) {
            if (!choice.isAttack() || choice.attack.getAttackCategory() != category) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOffensiveAttackType(List<MoveChoice> choices, Element type) {
        for (MoveChoice choice : choices) {
            if (!choice.isOffensiveMove() || choice.attack.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpreadMove(List<MoveChoice> choices) {
        for (MoveChoice choice : choices) {
            if (!choice.isOffensiveMove() || !choice.attack.getMove().getTargetingInfo().hitsAll || !choice.attack.getMove().getTargetingInfo().hitsAdjacentFoe) continue;
            return true;
        }
        return false;
    }

    public static float sumWeights(List<MoveChoice> choices) {
        float weightSum = 0.0f;
        for (MoveChoice choice : choices) {
            weightSum += choice.weight;
        }
        return weightSum;
    }

    public static boolean canBreakProtect(List<PixelmonWrapper> opponents, List<MoveChoice> choices) {
        if (MoveChoice.hasSuccessfulAttackChoice(choices, AttackRegistry.FEINT, AttackRegistry.HYPERSPACE_FURY, AttackRegistry.HYPERSPACE_HOLE, AttackRegistry.HYPER_DRILL)) {
            return true;
        }
        for (PixelmonWrapper opponent : opponents) {
            if (!opponent.hasStatus(StatusType.Vanish)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean hasMove(List<MoveChoice> choices, Optional<ImmutableAttack> ... moveNames) {
        for (MoveChoice choice : choices) {
            if (!choice.isAttack() || !choice.attack.isAttack(moveNames)) continue;
            return true;
        }
        return false;
    }
}

