/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.ai;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class OpponentMemory {
    UUID pokemonUUID;
    private List<Attack> guessedAttacks;
    private List<Attack> knownAttacks;

    public OpponentMemory(PixelmonWrapper pokemon) {
        this.pokemonUUID = pokemon.getPokemonUUID();
        this.guessedAttacks = new ArrayList<Attack>(pokemon.type.size());
        this.knownAttacks = new ArrayList<Attack>(4);
        Stats stats = pokemon.getForm();
        boolean physical = stats.getBattleStats().getStat(BattleStatsType.ATTACK) >= stats.getBattleStats().getStat(BattleStatsType.SPECIAL_ATTACK);
        for (Element type : pokemon.type) {
            if (type == null) continue;
            String guess = null;
            switch (type) {
                case BUG: {
                    guess = physical ? "X-Scissor" : "Bug Buzz";
                    break;
                }
                case DARK: {
                    guess = physical ? "Crunch" : "Dark Pulse";
                    break;
                }
                case DRAGON: {
                    guess = physical ? "Dragon Claw" : "Dragon Pulse";
                    break;
                }
                case ELECTRIC: {
                    guess = physical ? "Wild Charge" : "Thunderbolt";
                    break;
                }
                case FAIRY: {
                    guess = physical ? "Play Rough" : "Moonblast";
                    break;
                }
                case FIGHTING: {
                    guess = physical ? "Close Combat" : "Focus Blast";
                    break;
                }
                case FIRE: {
                    guess = physical ? "Flare Blitz" : "Flamethrower";
                    break;
                }
                case FLYING: {
                    guess = physical ? "Brave Bird" : "Air Slash";
                    break;
                }
                case GHOST: {
                    guess = physical ? "Shadow Claw" : "Shadow Ball";
                    break;
                }
                case GRASS: {
                    guess = physical ? "Leaf Blade" : "Energy Ball";
                    break;
                }
                case GROUND: {
                    guess = physical ? "Earthquake" : "Earth Power";
                    break;
                }
                case ICE: {
                    guess = physical ? "Icicle Crash" : "Ice Beam";
                    break;
                }
                case NORMAL: {
                    guess = physical ? "Return" : "Hyper Voice";
                    break;
                }
                case POISON: {
                    guess = physical ? "Poison Jab" : "Sludge Bomb";
                    break;
                }
                case PSYCHIC: {
                    guess = physical ? "Zen Headbutt" : "Psychic";
                    break;
                }
                case ROCK: {
                    guess = physical ? "Stone Edge" : "Power Gem";
                    break;
                }
                case STEEL: {
                    guess = physical ? "Iron Head" : "Flash Cannon";
                    break;
                }
                case WATER: {
                    guess = physical ? "Waterfall" : "Surf";
                    break;
                }
            }
            if (guess == null) continue;
            this.guessedAttacks.add(new Attack(guess));
        }
    }

    public void seeAttack(Attack attack) {
        if (this.knownAttacks.contains(attack)) {
            return;
        }
        if (attack.getAttackCategory() != AttackCategory.STATUS) {
            for (int i = 0; i < this.guessedAttacks.size(); ++i) {
                if (attack.getType() != this.guessedAttacks.get(i).getType()) continue;
                this.guessedAttacks.remove(i);
                break;
            }
        }
        if (this.guessedAttacks.size() + this.knownAttacks.size() >= 4) {
            if (this.guessedAttacks.isEmpty()) {
                this.knownAttacks.remove(0);
            } else {
                this.guessedAttacks.remove(RandomHelper.getRandomNumberBetween(0, this.guessedAttacks.size() - 1));
            }
        }
        this.knownAttacks.add(attack);
    }

    public List<Attack> getAttacks() {
        ArrayList<Attack> allAttacks = new ArrayList<Attack>(4);
        allAttacks.addAll(this.guessedAttacks);
        allAttacks.addAll(this.knownAttacks);
        return allAttacks;
    }
}

