/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BagItemEvent;
import com.pixelmonmod.pixelmon.api.events.raids.JoinRaidEvent;
import com.pixelmonmod.pixelmon.api.events.raids.RaidDropsEvent;
import com.pixelmonmod.pixelmon.api.events.raids.StartRaidEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureHealth;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.raids.EnumRaidKickReason;
import com.pixelmonmod.pixelmon.battles.raids.RaidGovernor;
import com.pixelmonmod.pixelmon.battles.raids.RaidPokemon;
import com.pixelmonmod.pixelmon.battles.raids.RaidRandomizer;
import com.pixelmonmod.pixelmon.battles.raids.RaidSettings;
import com.pixelmonmod.pixelmon.battles.tasks.RaidDropsTask;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.CloseRaidPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.OpenRaidPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.UpdateRaidCatchPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RaidData {
    public final UUID uuid = UUID.randomUUID();
    private final int stars;
    private final Supplier<Species> species;
    private final Supplier<Stats> form;
    private final int entityID;
    public final boolean canAllCatch;
    public final boolean canUseMaster;
    private boolean locked = false;
    private boolean starting = false;
    private UUID owner = null;
    private final ArrayList<RaidPlayer> players = new ArrayList();
    private ServerPlayerEntity ownerPlayer = null;
    public int tick = 0;
    private static final int[][] npcOffsets = new int[][]{{2, 0}, {0, 2}, {-2, 0}, {0, -2}};
    private static final float[] npcRotations = new float[]{180.0f, 270.0f, 0.0f, 90.0f};

    public RaidData(int entityID, int stars, Species species) {
        this(entityID, stars, species, species.getDefaultForm());
    }

    public RaidData(int entityID, int stars, Species species, Stats form) {
        this.entityID = entityID;
        this.stars = stars;
        this.species = () -> species;
        this.form = () -> form;
        this.canAllCatch = PixelmonConfigProxy.getRaids().getRaidCanAllCatch(this.stars);
        this.canUseMaster = PixelmonConfigProxy.getRaids().getRaidCanUseMaster(this.stars);
    }

    public RaidData(int entityID, int stars, int species, String form) {
        this.entityID = entityID;
        this.stars = stars;
        this.species = () -> PixelmonSpecies.fromNationalDex(species);
        this.form = () -> form.isEmpty() ? this.species.get().getDefaultForm() : this.species.get().getForm(form);
        this.canAllCatch = PixelmonConfigProxy.getRaids().getRaidCanAllCatch(this.stars);
        this.canUseMaster = PixelmonConfigProxy.getRaids().getRaidCanUseMaster(this.stars);
    }

    public RaidData(CompoundNBT tag) {
        CompoundNBT nbt = tag.func_74775_l("RaidData");
        this.tick = nbt.func_74762_e("Tick");
        this.entityID = nbt.func_74762_e("EntityID");
        this.stars = nbt.func_74765_d("Stars");
        this.species = () -> PixelmonSpecies.fromNationalDex(nbt.func_74762_e("Species"));
        this.form = nbt.func_74767_n("HasForm") ? () -> this.species.get().getForm(nbt.func_74779_i("Form")) : null;
        this.locked = nbt.func_74767_n("Locked");
        this.starting = nbt.func_74767_n("Starting");
        if (nbt.func_186855_b("Owner")) {
            this.owner = nbt.func_186857_a("Owner");
        }
        ListNBT participants = nbt.func_150295_c("Players", 10);
        for (INBT entry : participants) {
            this.players.add(new RaidPlayer((CompoundNBT)entry));
        }
        this.canAllCatch = nbt.func_74767_n("CanAllCatch");
        this.canUseMaster = nbt.func_74767_n("CanUseMaster");
    }

    public RaidData(PacketBuffer buf) {
        this.tick = buf.readInt();
        this.entityID = buf.readInt();
        this.stars = buf.readShort();
        int speciesNum = buf.readInt();
        this.species = () -> PixelmonSpecies.fromNationalDex(speciesNum);
        if (buf.readBoolean()) {
            String formNum = buf.func_218666_n();
            this.form = () -> this.species.get().getForm(formNum);
        } else {
            this.form = () -> null;
        }
        this.locked = buf.readBoolean();
        this.starting = buf.readBoolean();
        if (buf.readBoolean()) {
            this.owner = buf.func_179253_g();
        }
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.players.add(new RaidPlayer(buf));
        }
        this.canAllCatch = buf.readBoolean();
        this.canUseMaster = buf.readBoolean();
    }

    public int getDen() {
        return this.entityID;
    }

    public int getStars() {
        return this.stars;
    }

    public Species getSpecies() {
        return this.species.get();
    }

    public Stats getForm() {
        return this.form.get();
    }

    public ArrayList<RaidPlayer> getPlayers() {
        return this.players;
    }

    public boolean hasPlayers() {
        HashSet<ServerPlayerEntity> playersToRemove = new HashSet<ServerPlayerEntity>();
        for (RaidPlayer rp : this.players) {
            if (!rp.isPlayer() || !rp.playerEntity.func_193105_t()) continue;
            playersToRemove.add(rp.playerEntity);
        }
        for (ServerPlayerEntity toRemove : playersToRemove) {
            this.removePlayer(toRemove);
        }
        return !this.players.isEmpty();
    }

    public boolean isSolo() {
        return this.players.size() == 1 && this.locked || this.players.size() == 0;
    }

    public void processAction(int action, int slot, ItemStack usedStack, ServerPlayerEntity ep) {
        if (this.starting && action != 10) {
            return;
        }
        RaidPlayer player = this.getPlayer(ep);
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getParty(ep);
            Pokemon[] team = pps.getAll();
            switch (action) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Pokemon pokemon = team[action];
                    if (pokemon == null || !pokemon.canBattle()) break;
                    player.updatePokemon(action, pokemon);
                    this.updateAll();
                    break;
                }
                case 6: {
                    if (this.players.size() != 1) break;
                    this.locked = true;
                    this.starting = true;
                    this.updateAll();
                    break;
                }
                case 7: {
                    if (this.players.size() != 1) break;
                    this.locked = false;
                    this.updateAll();
                    break;
                }
                case 8: {
                    this.removePlayer(ep);
                    break;
                }
                case 9: {
                    if (this.players.size() < 1) break;
                    this.locked = true;
                    this.starting = true;
                    this.updateAll();
                    break;
                }
                case 10: {
                    ItemStack foundStack;
                    if (player.catchAttempted || player.possibleCatch == null || usedStack == null) break;
                    player.catchAttempted = true;
                    BattleController battleController = BattleRegistry.getBattle((PlayerEntity)player.playerEntity);
                    BagItemEvent.SelectItem.Pre pre = new BagItemEvent.SelectItem.Pre(battleController, "EndOfRaid", player.playerEntity, usedStack, foundStack = BattleItemScanner.findMatchingItem(usedStack, player.playerEntity));
                    if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                        return;
                    }
                    usedStack = pre.getFoundItem();
                    if (usedStack == null) {
                        return;
                    }
                    if (!(usedStack.func_77973_b() instanceof PokeBallItem)) break;
                    PokeBall ball = PokeBallPart.getPokeBall(usedStack).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                    if (!this.canUseMaster && ball.getCatchBonus() >= 255.0) {
                        return;
                    }
                    int shakes = player.tryCatch(this, ball);
                    boolean sentToPC = false;
                    if (shakes >= 4) {
                        if (Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.SuccessfulRaidCapture(ep, player.possibleCatch, this))) {
                            shakes = RandomHelper.getRandomNumberBetween(1, 3);
                        } else {
                            player.possibleCatch.setOriginalTrainer((PlayerEntity)ep);
                            player.possibleCatch.setBall(ball);
                            ball.getLogic().doAfterEffect(ball, null, player.possibleCatch.getOrCreatePixelmon());
                            TriBoolean result = pps.addSilently(player.possibleCatch);
                            if (result == TriBoolean.NULL) {
                                shakes = -1;
                            } else if (result == TriBoolean.FALSE) {
                                sentToPC = true;
                            }
                        }
                    }
                    Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.SelectItem.Post(battleController, "EndOfRaid", player.playerEntity, usedStack, foundStack));
                    if (shakes > 0 && !ep.func_184812_l_()) {
                        BattleItemScanner.consumeItem(usedStack, player.playerEntity);
                    }
                    if (shakes > 0 && shakes < 4) {
                        Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.FailedRaidCapture(ep, player.possibleCatch, this));
                    }
                    NetworkHelper.sendPacket(new UpdateRaidCatchPacket(shakes, sentToPC), ep);
                }
            }
        } else {
            NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        }
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public void updateAll() {
        boolean dead = false;
        for (RaidPlayer player : this.players) {
            ServerPlayerEntity ep = player.playerEntity;
            if (ep == null) continue;
            if (ep.func_233643_dh_()) {
                dead = true;
                break;
            }
            NetworkHelper.sendPacket(new OpenRaidPacket(this), ep);
        }
        if (dead) {
            this.locked = false;
            this.starting = false;
            this.tick = 0;
            this.kickAll(EnumRaidKickReason.INVALID_POKEMON);
        }
    }

    public void kickAll(EnumRaidKickReason reason) {
        for (RaidPlayer player : this.players) {
            ServerPlayerEntity ep = player.playerEntity;
            if (ep == null) continue;
            if (!ep.func_233643_dh_()) {
                ep.func_145747_a((ITextComponent)new TranslationTextComponent(reason.getMessage()), Util.field_240973_b_);
            }
            NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        }
        this.players.clear();
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void setStarting(boolean starting) {
        this.starting = starting;
    }

    public boolean addPlayer(int playerCap, ServerPlayerEntity ep, Pokemon pokemon, int index) {
        for (RaidPlayer player : this.players) {
            if (!ep.func_110124_au().equals(player.player)) continue;
            this.updateAll();
            return true;
        }
        if (this.locked || this.starting || this.players.size() >= playerCap) {
            return false;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)new JoinRaidEvent(this, ep, pokemon))) {
            this.players.add(new RaidPlayer(index, ep, pokemon));
            if (this.players.size() == 1) {
                this.owner = ep.func_110124_au();
                this.locked = true;
            }
            this.updateAll();
        }
        return true;
    }

    public boolean removePlayer(ServerPlayerEntity ep) {
        boolean removed = false;
        boolean shouldReset = false;
        Iterator<RaidPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            RaidPlayer player = iterator.next();
            if (!ep.func_110124_au().equals(player.player)) continue;
            iterator.remove();
            removed = true;
            if (!player.player.equals(this.owner)) continue;
            shouldReset = true;
        }
        if (shouldReset) {
            this.locked = false;
            this.kickAll(EnumRaidKickReason.LEADER_LEFT);
        } else {
            this.updateAll();
        }
        NetworkHelper.sendPacket(new CloseRaidPacket(), ep);
        return removed;
    }

    public boolean updatePlayer(ServerPlayerEntity ep, Pokemon pokemon, int index) {
        for (RaidPlayer player : this.players) {
            if (!ep.func_110124_au().equals(player.player)) continue;
            player.updatePokemon(index, pokemon);
            this.updateAll();
            return true;
        }
        return false;
    }

    public RaidPlayer getPlayer(UUID uuid) {
        for (RaidPlayer player : this.players) {
            if (!uuid.equals(player.player)) continue;
            return player;
        }
        return null;
    }

    public RaidPlayer getPlayer(ServerPlayerEntity ep) {
        return this.getPlayer(ep.func_110124_au());
    }

    public Optional<DenEntity> getDenEntity(World world) {
        Entity entity = world.func_73045_a(this.getDen());
        return Optional.ofNullable(entity instanceof DenEntity ? (DenEntity)entity : null);
    }

    public boolean isOwner(UUID uuid) {
        return uuid.equals(this.owner);
    }

    public void onUpdate(DenEntity den) {
        boolean shouldReset = false;
        Iterator<RaidPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            RaidPlayer player = iterator.next();
            if (player.playerEntity == null || !player.playerEntity.func_193105_t()) continue;
            iterator.remove();
            if (this.owner != null && !this.owner.equals(player.player)) continue;
            shouldReset = true;
        }
        if (shouldReset) {
            this.kickAll(EnumRaidKickReason.LEADER_LEFT);
        } else if (this.isStarting()) {
            if (this.tick == 0) {
                this.populateWithNPCs();
            }
            ++this.tick;
            if (this.tick % 20 == 0) {
                this.updateAll();
            }
            if (this.tick >= 100) {
                this.startRaid(den);
            }
        }
    }

    public void populateWithNPCs() {
        int maxLevel = 1;
        for (RaidPlayer player : this.players) {
            maxLevel = Math.max(maxLevel, player.level);
        }
        int npcs = 4 - this.players.size();
        for (int i = 0; i < npcs; ++i) {
            this.players.add(new RaidPlayer(RaidRandomizer.getRandomAlly(this), maxLevel));
        }
        this.updateAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRaid(DenEntity den) {
        HashSet<NPCTrainer> trainers;
        block23: {
            boolean canStart = true;
            BattleParticipant[] allies = new BattleParticipant[4];
            trainers = new HashSet<NPCTrainer>();
            int i = 0;
            try {
                for (RaidPlayer player : this.players) {
                    block25: {
                        block24: {
                            if (player.playerEntity == null || player.playerEntity.func_233643_dh_() || !(den.func_70032_d((Entity)player.playerEntity) <= 30.0f)) break block24;
                            NetworkHelper.sendPacket(new CloseRaidPacket(), player.playerEntity);
                            PlayerPartyStorage pps = StorageProxy.getParty(player.playerEntity);
                            Pokemon pokemon = pps.get(player.uuid);
                            if (pokemon != null) {
                                allies[i] = new PlayerParticipant(true, player.playerEntity, pokemon);
                                if (!Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon((Entity)player.playerEntity);
                                    if (pixelmon != null) {
                                        pixelmon.setPixelmonToFlyForBattle();
                                    }
                                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                                }
                                break block25;
                            } else {
                                canStart = false;
                                break;
                            }
                        }
                        int index = i % 4;
                        NPCTrainer trainer = new NPCTrainer(den.field_70170_p);
                        int[] offset = npcOffsets[index];
                        trainer.func_70634_a(den.func_226277_ct_() + (double)offset[0], den.func_226278_cu_(), den.func_226281_cx_() + (double)offset[1]);
                        BaseTrainer base = ServerNPCRegistry.trainers.getRandomBase();
                        trainer.init(base);
                        trainer.setAIMode(EnumTrainerAI.StandStill);
                        trainer.initAI();
                        trainer.clearGreetings();
                        trainer.setName(player.name);
                        trainer.canEngage = false;
                        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                        server.execute(() -> {
                            if (den.field_70170_p instanceof ServerWorld) {
                                ((ServerWorld)den.field_70170_p).func_217470_d((Entity)trainer);
                            }
                            trainer.getPersistentData().func_74757_a("IsRaidTrainer", true);
                            trainer.field_70177_z = npcRotations[index];
                            trainer.func_70080_a(trainer.func_226277_ct_(), trainer.func_226278_cu_(), trainer.func_226281_cx_(), npcRotations[index], 0.0f);
                            trainer.func_70634_a(trainer.func_226277_ct_(), trainer.func_226278_cu_(), trainer.func_226281_cx_());
                        });
                        for (int j = 0; j < 6; ++j) {
                            trainer.getPokemonStorage().set(j, j == 0 ? player.pokemon : null);
                        }
                        trainers.add(trainer);
                        allies[i] = new TrainerParticipant(trainer, 1);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to start raid due to error, catching and continuing safely...");
                e.printStackTrace();
                canStart = false;
            }
            if (canStart) {
                PixelmonEntity raidPixelmon = null;
                try {
                    boolean canContinue = true;
                    for (BattleParticipant ally : allies) {
                        if (ally == null) {
                            canContinue = false;
                            break;
                        }
                        if (!(ally instanceof TrainerParticipant) && !(ally instanceof PlayerParticipant)) continue;
                        if (ally instanceof PlayerParticipant) {
                            PlayerParticipant pp = (PlayerParticipant)ally;
                            if (pp.player.func_193105_t()) {
                                canContinue = false;
                                break;
                            }
                        }
                        if (ally.getEntity() != null && ally.allPokemon != null && ally.allPokemon.length > 0 && ally.allPokemon[0] != null) continue;
                        canContinue = false;
                        break;
                    }
                    if (canContinue) {
                        RaidPixelmonParticipant rpp;
                        Pokemon raidEnemy = PokemonFactory.create(this.getSpecies());
                        if (this.getForm() != null) {
                            raidEnemy.setForm(this.getForm());
                        }
                        if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(raidEnemy))) {
                            RaidPixelmonParticipant rpp2 = new RaidPixelmonParticipant(this, RaidSettings.builder().setStars(this.stars).build(), raidEnemy);
                            BattleRegistry.startBattle(allies, new BattleParticipant[]{rpp2}, BattleType.RAID);
                            den.setInUseRaidData();
                            den.clearData();
                            return;
                        }
                        raidPixelmon = raidEnemy.getOrSpawnPixelmon(den.field_70170_p, den.func_226277_ct_(), den.func_226278_cu_() + 3.0, den.func_226281_cx_());
                        if (raidPixelmon != null) {
                            raidPixelmon.setPixelmonToFlyForBattle();
                        }
                        if (!Pixelmon.EVENT_BUS.post((Event)new StartRaidEvent(den, this, allies, raidPixelmon, rpp = new RaidPixelmonParticipant(this, RaidSettings.builder().setStars(this.stars).build(), raidPixelmon)))) {
                            BattleRegistry.startBattle(allies, new BattleParticipant[]{rpp}, BattleType.RAID);
                            den.setInUseRaidData();
                            den.clearData();
                            return;
                        }
                        raidPixelmon.unloadEntity();
                        Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(raidEnemy, raidPixelmon));
                    }
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to start raid battle due to error, catching and continuing safely...");
                    e.printStackTrace();
                    if (raidPixelmon == null) break block23;
                    raidPixelmon.unloadEntity();
                }
            }
        }
        Iterator<RaidPlayer> iterator = trainers.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.locked = false;
                this.starting = false;
                this.tick = 0;
                this.kickAll(EnumRaidKickReason.INVALID_POKEMON);
                return;
            }
            NPCTrainer trainer = (NPCTrainer)((Object)iterator.next());
            trainer.func_70106_y();
        }
    }

    public void write(CompoundNBT tag) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Tick", this.tick);
        nbt.func_74768_a("EntityID", this.entityID);
        nbt.func_74777_a("Stars", (short)this.stars);
        nbt.func_74768_a("Species", this.species.get().getDex());
        nbt.func_74757_a("HasForm", this.form.get() != null);
        if (this.form.get() != null) {
            nbt.func_74778_a("Form", this.form.get().getName());
        }
        nbt.func_74757_a("Locked", this.locked);
        nbt.func_74757_a("Starting", this.starting);
        if (this.owner != null) {
            nbt.func_186854_a("Owner", this.owner);
        }
        ListNBT players = new ListNBT();
        for (RaidPlayer player : this.players) {
            players.add((Object)player.write());
        }
        nbt.func_218657_a("Players", (INBT)players);
        nbt.func_74757_a("CanAllCatch", this.canAllCatch);
        nbt.func_74757_a("CanUseMaster", this.canUseMaster);
        tag.func_218657_a("RaidData", (INBT)tag);
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.tick);
        buf.writeInt(this.entityID);
        buf.writeShort(this.stars);
        buf.writeInt(this.species.get().getDex());
        buf.writeBoolean(this.form.get() != null);
        if (this.form.get() != null) {
            buf.func_180714_a(this.form.get().getName());
        }
        buf.writeBoolean(this.locked);
        buf.writeBoolean(this.starting);
        buf.writeBoolean(this.owner != null);
        if (this.owner != null) {
            buf.func_179252_a(this.owner);
        }
        buf.writeInt(this.players.size());
        for (RaidPlayer player : this.players) {
            player.write(buf);
        }
        buf.writeBoolean(this.canAllCatch);
        buf.writeBoolean(this.canUseMaster);
    }

    public static class RaidPlayer {
        public final UUID player;
        public String name;
        public UUID uuid;
        public Species species;
        public Gender gender;
        public Stats form;
        public String palette;
        public int index;
        public ServerPlayerEntity playerEntity;
        public int level;
        public Pokemon possibleCatch = null;
        public boolean canCatch = true;
        public boolean catchAttempted = false;
        public ArrayList<ItemStack> drops;
        public Pokemon pokemon;

        public RaidPlayer(int index, ServerPlayerEntity player, Pokemon pokemon) {
            this.player = player.func_110124_au();
            this.playerEntity = player;
            this.updatePokemon(index, pokemon);
        }

        public RaidPlayer(RaidPokemon pokemon, int maxLevel) {
            this.player = null;
            this.playerEntity = null;
            this.pokemon = pokemon.makePokemon(Math.max(1, (int)Math.floor((double)maxLevel * 0.7)));
            this.name = pokemon.getName();
            this.updatePokemon(0, this.pokemon);
        }

        public RaidPlayer(CompoundNBT tag) {
            this.player = tag.func_186855_b("player") ? tag.func_186857_a("player") : null;
            this.uuid = tag.func_186857_a("uuid");
            this.species = PixelmonSpecies.fromNationalDex(tag.func_74762_e("species"));
            this.gender = Gender.values()[tag.func_74765_d("gender")];
            this.form = this.species.getForm(tag.func_74779_i("form"));
            this.palette = tag.func_74779_i("palette");
            this.index = tag.func_74762_e("index");
        }

        public RaidPlayer(PacketBuffer buf) {
            this.player = buf.readBoolean() ? buf.func_179253_g() : null;
            this.uuid = buf.func_179253_g();
            this.species = PixelmonSpecies.fromNationalDex(buf.readInt());
            this.gender = Gender.values()[buf.readShort()];
            this.form = this.species.getForm(buf.func_218666_n());
            this.palette = buf.func_218666_n();
            this.index = buf.readInt();
        }

        public void updatePokemon(int index, Pokemon pokemon) {
            this.uuid = pokemon.getUUID();
            this.species = pokemon.getSpecies();
            this.gender = pokemon.getGender();
            this.form = pokemon.getForm();
            this.palette = pokemon.getPalette().getName();
            this.level = pokemon.getPokemonLevel();
            this.index = index;
        }

        public boolean isPlayer() {
            return this.player != null && this.playerEntity != null;
        }

        public void winRaid(RaidPixelmonParticipant rpp, RaidData raid, RaidGovernor governor) {
            if (this.isPlayer()) {
                PixelmonWrapper pw = rpp.getWrapper();
                RaidDropsEvent dropsEvent = new RaidDropsEvent(raid, this, governor, governor.getSettings().getCatchablePokemon(pw.pokemon), governor.getSettings().getDrops(pw.pokemon.getForm().getTypes()), governor.settings.canCatch && (raid.isOwner(this.player) || raid.canAllCatch));
                Pixelmon.EVENT_BUS.post((Event)dropsEvent);
                this.possibleCatch = dropsEvent.getPossibleCatch();
                this.canCatch = dropsEvent.canCatch();
                this.drops = dropsEvent.getDrops();
                BagItemEvent.CollectItems.Pre pre = new BagItemEvent.CollectItems.Pre(rpp.bc, "EndOfRaid", this.playerEntity, BagSection.POKEBALLS);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    pre.getItems().clear();
                }
                rpp.bc.getPlayer((PlayerEntity)this.playerEntity).sendMessage(new RaidDropsTask(this.canCatch, pre.getItems(), raid, governor.settings.shiny, this));
                Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.CollectItems.Post(rpp.bc, "EndOfRaid", this.playerEntity, pre.getSection(), pre.getItems()));
                for (ItemStack drop : this.drops) {
                    if (this.playerEntity.func_191521_c(drop)) continue;
                    this.playerEntity.func_71019_a(drop, true);
                }
            }
        }

        public int tryCatch(RaidData raid, PokeBall ball) {
            if (this.playerEntity != null && this.possibleCatch != null && this.canCatch) {
                CaptureValues values = ball.getCaptureMethod().calculateCapture(new CaptureHealth(this, raid), ball, null, raid, this.playerEntity, this.possibleCatch, PokeBallMode.EMPTY);
                return values.getShakes();
            }
            return RandomHelper.getRandomNumberBetween(1, 3);
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            this.write(nbt);
            return nbt;
        }

        public void write(CompoundNBT tag) {
            if (this.player != null) {
                tag.func_186854_a("player", this.player);
            }
            tag.func_186854_a("uuid", this.uuid);
            tag.func_74768_a("species", this.species.getDex());
            tag.func_74777_a("gender", (short)this.gender.ordinal());
            tag.func_74778_a("form", this.form.getName());
            tag.func_74778_a("palette", this.palette);
        }

        public void write(PacketBuffer buf) {
            buf.writeBoolean(this.player != null);
            if (this.player != null) {
                buf.func_179252_a(this.player);
            }
            buf.func_179252_a(this.uuid);
            buf.writeInt(this.species.getDex());
            buf.writeShort(this.gender.ordinal());
            buf.func_180714_a(this.form.getName());
            buf.func_180714_a(this.palette);
            buf.writeInt(this.index);
        }
    }
}

