/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Guts;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public class Sleep
extends StatusPersist {
    public transient int effectTurns = -1;

    public Sleep() {
        this(RandomHelper.getRandomNumberBetween(1, 3));
    }

    public Sleep(int i) {
        super(StatusType.Sleep);
        this.effectTurns = i;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Sleep.sleep(user, target, user.attack, true);
        }
    }

    public static boolean sleep(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        return new Sleep().addStatus(user, target, attack, showMessage, "pixelmon.effect.alreadysleeping", "pixelmon.effect.fallasleep");
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        if (pokemon.bc.rules.hasClause(BattleClauseRegistry.SLEEP_CLAUSE)) {
            for (PixelmonWrapper pw : pokemon.getParticipant().allPokemon) {
                if (pw.getPrimaryStatus().type != StatusType.Sleep) continue;
                return true;
            }
        }
        return Sleep.uproarActive(pokemon);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (Sleep.uproarActive(user)) {
            this.effectTurns = 0;
        }
        if (this.effectTurns-- <= 0) {
            user.removeStatus(this);
            if (user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Guts.class)) {
                int[] stats = user.getBattleStats().getBattleStats();
                int n = BattleStatsType.ATTACK.getStatIndex();
                stats[n] = (int)((double)stats[n] / 1.5);
                user.getBattleStats().setStatsForTurn(stats);
            }
            return true;
        }
        user.bc.sendToAll("pixelmon.status.stillsleeping", user.getNickname());
        return a.isAttack(AttackRegistry.SNORE, AttackRegistry.SLEEP_TALK);
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("StatusSleepTurns", this.effectTurns);
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("StatusSleepTurns")) {
            return new Sleep(nbt.func_74762_e("StatusSleepTurns"));
        }
        return new Sleep();
    }

    public static boolean uproarActive(PixelmonWrapper pokemon) {
        if (pokemon.bc == null) {
            return false;
        }
        for (PixelmonWrapper pw : pokemon.bc.getActiveUnfaintedPokemon()) {
            if (!pw.hasStatus(StatusType.Uproar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StatusBase copy() {
        return new Sleep(this.effectTurns);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.wokeup";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.sleepcureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (!userChoice.hitsAlly()) {
            userChoice.raiseWeight(this.getWeightWithChance(userChoice.result.accuracy));
        }
    }
}

