/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidCatchScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RaidDropsTask
extends BattleTaskPacket {
    private boolean canCatch;
    private List<ItemData> itemData = Lists.newArrayList();
    private RaidData raid;
    private boolean shiny;
    private List<ItemStack> drops = Lists.newArrayList();

    public RaidDropsTask() {
    }

    public RaidDropsTask(boolean canCatch, List<ItemData> itemData, RaidData raid, boolean shiny, RaidData.RaidPlayer player) {
        this();
        this.canCatch = canCatch;
        this.itemData = itemData;
        this.raid = raid;
        this.shiny = shiny;
        this.drops = player.drops;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        this.processClient();
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processClient() {
        Minecraft.func_71410_x().execute(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((Screen)new RaidCatchScreen(this.raid, this.shiny, this.drops.toArray(new ItemStack[0]), this.itemData, this.canCatch));
        });
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return null;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.canCatch = buf.readBoolean();
        this.raid = new RaidData(buf);
        this.shiny = buf.readBoolean();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.drops.add(buf.func_150791_c());
        }
        int size = buf.readInt();
        this.itemData = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.itemData.add(ItemData.deocde(buf));
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.canCatch);
        this.raid.write(buf);
        buf.writeBoolean(this.shiny);
        buf.writeInt(this.drops.size());
        for (ItemStack stack : this.drops) {
            buf.func_150788_a(stack);
        }
        buf.writeInt(this.itemData.size());
        for (ItemData itemDatum : this.itemData) {
            itemDatum.encode(buf);
        }
    }
}

