/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.furniture;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ClockTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ClockBlock
extends GenericRotatableModelBlock {
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.9, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.9, 1.0, 1.0, 1.0);
    private DyeColor color;

    public ClockBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        this.color = color;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ClockTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ClockTileEntity();
    }

    @Override
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.getBlockBounds(p_220071_1_));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.getBlockBounds(p_220053_1_));
    }

    private AxisAlignedBB getBlockBounds(BlockState blockState) {
        Direction enumfacing = (Direction)blockState.func_177229_b((Property)FACING);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case NORTH: {
                return AABB_NORTH;
            }
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_184586_b(hand).func_77973_b() instanceof DyeItem) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
            BlockState st = null;
            switch (dyeColor) {
                default: {
                    st = PixelmonBlocks.white_clock.func_176223_P();
                    break;
                }
                case BLACK: {
                    st = PixelmonBlocks.black_clock.func_176223_P();
                    break;
                }
                case RED: {
                    st = PixelmonBlocks.red_clock.func_176223_P();
                    break;
                }
                case GREEN: {
                    st = PixelmonBlocks.green_clock.func_176223_P();
                    break;
                }
                case BROWN: {
                    st = PixelmonBlocks.brown_clock.func_176223_P();
                    break;
                }
                case BLUE: {
                    st = PixelmonBlocks.blue_clock.func_176223_P();
                    break;
                }
                case PURPLE: {
                    st = PixelmonBlocks.purple_clock.func_176223_P();
                    break;
                }
                case CYAN: {
                    st = PixelmonBlocks.cyan_clock.func_176223_P();
                    break;
                }
                case LIGHT_GRAY: {
                    st = PixelmonBlocks.light_gray_clock.func_176223_P();
                    break;
                }
                case GRAY: {
                    st = PixelmonBlocks.gray_clock.func_176223_P();
                    break;
                }
                case PINK: {
                    st = PixelmonBlocks.pink_clock.func_176223_P();
                    break;
                }
                case LIME: {
                    st = PixelmonBlocks.lime_clock.func_176223_P();
                    break;
                }
                case YELLOW: {
                    st = PixelmonBlocks.yellow_clock.func_176223_P();
                    break;
                }
                case LIGHT_BLUE: {
                    st = PixelmonBlocks.light_blue_clock.func_176223_P();
                    break;
                }
                case MAGENTA: {
                    st = PixelmonBlocks.magenta_clock.func_176223_P();
                    break;
                }
                case ORANGE: {
                    st = PixelmonBlocks.orange_clock.func_176223_P();
                }
            }
            st = (BlockState)st.func_206870_a((Property)FACING, state.func_177229_b((Property)FACING));
            if (st != state) {
                world.func_175656_a(pos, st);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockPos pos = ctx.func_195995_a().func_177971_a(ctx.func_196000_l().func_176734_d().func_176730_m());
        BlockState state = ctx.func_195991_k().func_180495_p(pos);
        boolean sturdy = state.func_224755_d((IBlockReader)ctx.func_195991_k(), pos, ctx.func_196000_l()) && state.func_177230_c().func_149645_b(state) != BlockRenderType.INVISIBLE;
        return !sturdy || ctx.func_196000_l().func_176740_k() == Direction.Axis.Y ? null : super.func_196258_a(ctx);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }

    public DyeColor getColor() {
        return this.color;
    }
}

