/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HealerEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.tileentity.HealerTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class HealerBlock
extends ContainerBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.03125, 0.0, 0.03125, 0.96875, 0.875, 0.96875);

    public HealerBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200943_b(3.5f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K || handIn == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        HealerTileEntity healer = (HealerTileEntity)worldIn.func_175625_s(pos);
        if (healer == null) {
            return ActionResultType.FAIL;
        }
        DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
        if (dyeColor == null) {
            if (healer.beingUsed) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.healer", new Object[0]);
                return ActionResultType.FAIL;
            }
            boolean post = Pixelmon.EVENT_BUS.post((Event)new HealerEvent.Pre(player, pos, false));
            if (post) {
                return ActionResultType.FAIL;
            }
            healer.use(player);
            return ActionResultType.CONSUME;
        }
        if (!Objects.equals(healer.getOwnerUUID(), player.func_110124_au())) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.healer.ownership", new Object[0]);
            return ActionResultType.FAIL;
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            BlockState st = null;
            switch (dyeColor) {
                default: {
                    st = PixelmonBlocks.white_healer.func_176223_P();
                    break;
                }
                case BLACK: {
                    st = PixelmonBlocks.black_healer.func_176223_P();
                    break;
                }
                case RED: {
                    st = PixelmonBlocks.red_healer.func_176223_P();
                    break;
                }
                case GREEN: {
                    st = PixelmonBlocks.green_healer.func_176223_P();
                    break;
                }
                case BROWN: {
                    st = PixelmonBlocks.brown_healer.func_176223_P();
                    break;
                }
                case BLUE: {
                    st = PixelmonBlocks.blue_healer.func_176223_P();
                    break;
                }
                case PURPLE: {
                    st = PixelmonBlocks.purple_healer.func_176223_P();
                    break;
                }
                case CYAN: {
                    st = PixelmonBlocks.cyan_healer.func_176223_P();
                    break;
                }
                case LIGHT_GRAY: {
                    st = PixelmonBlocks.light_gray_healer.func_176223_P();
                    break;
                }
                case GRAY: {
                    st = PixelmonBlocks.gray_healer.func_176223_P();
                    break;
                }
                case PINK: {
                    st = PixelmonBlocks.pink_healer.func_176223_P();
                    break;
                }
                case LIME: {
                    st = PixelmonBlocks.lime_healer.func_176223_P();
                    break;
                }
                case YELLOW: {
                    st = PixelmonBlocks.yellow_healer.func_176223_P();
                    break;
                }
                case LIGHT_BLUE: {
                    st = PixelmonBlocks.light_blue_healer.func_176223_P();
                    break;
                }
                case MAGENTA: {
                    st = PixelmonBlocks.magenta_healer.func_176223_P();
                    break;
                }
                case ORANGE: {
                    st = PixelmonBlocks.orange_healer.func_176223_P();
                }
            }
            st = (BlockState)st.func_206870_a((Property)FACING, state.func_177229_b((Property)FACING));
            if (st != state) {
                worldIn.func_175656_a(pos, st);
                this.setOwner(pos, player);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        UUID playerID = playerIn.func_110124_au();
        HealerTileEntity healer = BlockHelper.getTileEntity(HealerTileEntity.class, (IBlockReader)playerIn.func_130014_f_(), pos);
        if (healer == null) {
            return;
        }
        healer.setOwner(playerID);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new HealerTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn.field_72995_K) {
            return;
        }
        HealerTileEntity healer = BlockHelper.getTileEntity(HealerTileEntity.class, (IBlockReader)worldIn, pos);
        if (healer != null && healer.beingUsed && healer.player != null) {
            healer.player.func_71053_j();
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        HealerTileEntity healer = (HealerTileEntity)blockAccess.func_175625_s(pos);
        if (healer == null || !healer.beingUsed) {
            return 0;
        }
        return 15;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

