/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.multi;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.multi.BlockGenericModelMultiblock;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilDisplayTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.FossilItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FossilDisplayBlock
extends BlockGenericModelMultiblock
implements IBlockHasOwner {
    public FossilDisplayBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.0f).func_226896_b_(), 1, 2.0, 1);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        List<ItemStack> drops = super.func_220076_a(state, context);
        if (context.func_216018_a() == null || context.func_216019_b(LootParameters.field_216281_a) == null || ((Entity)context.func_216019_b(LootParameters.field_216281_a)).func_233580_cy_() == null) {
            return drops;
        }
        Entity optionalParameter = (Entity)context.func_216019_b(LootParameters.field_216281_a);
        if (optionalParameter == null) {
            return drops;
        }
        BlockPos base = this.findBaseBlock((IBlockReader)context.func_216018_a(), optionalParameter.func_233580_cy_().func_239590_i_(), state);
        if (base == null) {
            return drops;
        }
        drops.add(new ItemStack((IItemProvider)PixelmonBlocks.fossil_display, 1));
        return drops;
    }

    @Override
    protected Optional<TileEntity> getTileEntity(IBlockReader world, BlockState state) {
        return Optional.of(new FossilDisplayTileEntity());
    }

    @Override
    public void func_196243_a(BlockState blockState, World level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (!blockState.func_203425_a(newState.func_177230_c())) {
            FossilItem itemInDisplay;
            TileEntity tileentity = level.func_175625_s(pos);
            if (tileentity instanceof FossilDisplayTileEntity && (itemInDisplay = ((FossilDisplayTileEntity)tileentity).getItemInDisplay()) != null) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                itemEntity.func_92058_a(new ItemStack((IItemProvider)itemInDisplay.func_199767_j()));
                level.func_217376_c((Entity)itemEntity);
            }
            super.func_196243_a(blockState, level, pos, newState, p_196243_5_);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Item playerItem;
        if (world.field_72995_K || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        FossilDisplayTileEntity fossilDisplayEntity = BlockHelper.getTileEntity(FossilDisplayTileEntity.class, (IBlockReader)world, pos = this.findBaseBlock((IBlockReader)world, pos.func_239590_i_(), state));
        if (fossilDisplayEntity == null) {
            return ActionResultType.SUCCESS;
        }
        if (!Objects.equals(player.func_110124_au(), fossilDisplayEntity.getOwnerUUID())) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.fossildisplay.ownership", new Object[0]);
            return ActionResultType.SUCCESS;
        }
        if (!fossilDisplayEntity.isOpen()) {
            fossilDisplayEntity.openGlass();
            return ActionResultType.SUCCESS;
        }
        FossilItem item = fossilDisplayEntity.getItemInDisplay();
        if (item != null) {
            if (heldItem.func_190926_b() && !player.func_225608_bj_()) {
                fossilDisplayEntity.setItemInDisplay(null);
                ((ServerWorld)world).func_72863_F().func_217217_a(pos);
                if (!player.func_184812_l_()) {
                    DropItemHelper.giveItemStack((ServerPlayerEntity)player, new ItemStack((IItemProvider)item), false);
                }
            } else {
                fossilDisplayEntity.closeGlass();
            }
            return ActionResultType.SUCCESS;
        }
        Item item2 = playerItem = heldItem.func_190926_b() ? null : heldItem.func_77973_b();
        if (heldItem.func_190926_b() || player.func_225608_bj_()) {
            fossilDisplayEntity.closeGlass();
            ((ServerWorld)world).func_72863_F().func_217217_a(pos);
        } else if (playerItem instanceof FossilItem) {
            fossilDisplayEntity.setItemInDisplay(playerItem);
            ((ServerWorld)world).func_72863_F().func_217217_a(pos);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.fossildisplay.placecheck", new Object[0]);
            fossilDisplayEntity.closeGlass();
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        FossilDisplayTileEntity fossilDisplay = BlockHelper.getTileEntity(FossilDisplayTileEntity.class, (IBlockReader)playerIn.field_70170_p, pos);
        fossilDisplay.setOwner(playerIn.func_110124_au());
    }
}

