/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.ScrollBlock;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ScrollItem;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScrollTileEntity
extends TileEntity
implements INameable {
    private String name;
    private ScrollBlock.Type type;
    private boolean displayOnly;
    private String imageResourceLocation;

    public ScrollTileEntity() {
        this(ScrollBlock.Type.WATERS);
    }

    public ScrollTileEntity(ScrollBlock.Type type) {
        super((TileEntityType)TileEntityRegistration.SCROLL.get());
        this.type = type;
        this.imageResourceLocation = type.getDefaultResource();
        this.displayOnly = false;
    }

    public boolean isDisplayOnly() {
        return this.displayOnly;
    }

    public ScrollBlock.Type getScrollType() {
        return this.type;
    }

    public void setItemValues(ItemStack stack) {
        CompoundNBT tag = stack.func_190925_c("BlockEntityTag");
        this.displayOnly = tag.func_74767_n("DisplayOnly");
        this.imageResourceLocation = tag.func_74779_i("Resource");
        this.type = ((ScrollItem)stack.func_77973_b()).type;
        if (!this.displayOnly) {
            this.imageResourceLocation = this.type.getDefaultResource();
        }
    }

    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? new StringTextComponent(this.name) : new TranslationTextComponent(this.type.getName());
    }

    public boolean func_145818_k_() {
        return this.name != null && !this.name.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.name);
        }
        compound.func_74757_a("DisplayOnly", this.displayOnly);
        compound.func_74778_a("Resource", this.imageResourceLocation == null ? "" : this.imageResourceLocation);
        compound.func_74774_a("Type", (byte)this.type.ordinal());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("CustomName")) {
            this.name = compound.func_74779_i("CustomName");
        }
        this.displayOnly = compound.func_74767_n("DisplayOnly");
        this.imageResourceLocation = compound.func_74779_i("Resource");
        this.type = ScrollBlock.Type.values()[compound.func_74771_c("Type")];
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getResourceLocation() {
        return ResourceLocationHelper.of(this.imageResourceLocation == null || this.imageResourceLocation.isEmpty() ? this.type.getDefaultResource() : this.imageResourceLocation);
    }

    public ItemStack getItem() {
        ItemStack itemstack = ScrollItem.makeScroll(this.type, this.displayOnly, this.imageResourceLocation);
        itemstack.func_77982_d(new CompoundNBT());
        if (this.func_145818_k_()) {
            itemstack.func_200302_a(this.func_200200_C_());
        }
        itemstack.func_77978_p().func_218657_a("BlockEntityTag", (INBT)this.func_189515_b(new CompoundNBT()));
        return itemstack;
    }
}

