/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.primitives.Doubles;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class WarpPlateTileEntity
extends TileEntity {
    private String warpX = null;
    private String warpY = null;
    private String warpZ = null;
    private BlockPos warpPosition = null;

    public WarpPlateTileEntity() {
        super((TileEntityType)TileEntityRegistration.WARP_PLATE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.warpX != null) {
            nbt.func_74778_a("warp_x", this.warpX);
            nbt.func_74778_a("warp_y", this.warpY);
            nbt.func_74778_a("warp_z", this.warpZ);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("warp_x")) {
            this.warpX = nbt.func_74779_i("warp_x");
            this.warpY = nbt.func_74779_i("warp_y");
            this.warpZ = nbt.func_74779_i("warp_z");
            this.warpPosition = this.calculatePosition(this.warpX, this.warpY, this.warpZ);
        } else if (nbt.func_74764_b("warpPosition")) {
            this.warpPosition = BlockPos.func_218283_e((long)nbt.func_74763_f("warpPosition"));
            this.warpX = String.valueOf(this.warpPosition.func_177958_n());
            this.warpY = String.valueOf(this.warpPosition.func_177956_o());
            this.warpZ = String.valueOf(this.warpPosition.func_177952_p());
        }
    }

    public BlockPos getWarpPosition() {
        return this.warpPosition;
    }

    public void setWarpPosition(String x, String y, String z) {
        this.warpX = x;
        this.warpY = y;
        this.warpZ = z;
        this.warpPosition = this.calculatePosition(this.warpX, this.warpY, this.warpZ);
        this.func_70296_d();
    }

    public BlockPos calculatePosition(String warpX, String warpY, String warpZ) {
        String[] wPos = new String[]{warpX, warpY, warpZ};
        int[] pos = new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()};
        double[] nPos = new double[3];
        for (int i = 0; i < wPos.length; ++i) {
            try {
                nPos[i] = WarpPlateTileEntity.parseDouble(pos[i], wPos[i], false);
                continue;
            }
            catch (NullPointerException | NumberFormatException e) {
                return null;
            }
        }
        return new BlockPos(nPos[0], nPos[1], nPos[2]);
    }

    public static double parseDouble(double base, String input, boolean centerBlock) throws NumberFormatException {
        return WarpPlateTileEntity.parseDouble(base, input, -30000000, 30000000, centerBlock);
    }

    public static double parseDouble(double base, String input, int min, int max, boolean centerBlock) throws NumberFormatException {
        double d0;
        boolean flag = input.startsWith("~");
        if (flag && Double.isNaN(base)) {
            throw new NumberFormatException();
        }
        double d = d0 = flag ? base : 0.0;
        if (!flag || input.length() > 1) {
            boolean flag1 = input.contains(".");
            if (flag) {
                input = input.substring(1);
            }
            d0 += WarpPlateTileEntity.parseDouble(input);
            if (!flag1 && !flag && centerBlock) {
                d0 += 0.5;
            }
        }
        if (min != 0 || max != 0) {
            if (d0 < (double)min) {
                throw new NumberFormatException();
            }
            if (d0 > (double)max) {
                throw new NumberFormatException();
            }
        }
        return d0;
    }

    public static double parseDouble(String input) throws NumberFormatException {
        try {
            double d0 = Double.parseDouble(input);
            if (!Doubles.isFinite((double)d0)) {
                throw new NumberFormatException();
            }
            return d0;
        }
        catch (NumberFormatException var3) {
            throw new NumberFormatException();
        }
    }
}

