/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.util.UUIDTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.LabelWidget;
import com.pixelmonmod.pixelmon.client.gui.widgets.UpdatingImageButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtrasEditorScreen
extends DropDownScreen {
    private final PixelExtrasData client;
    private final PlayerModel<?> model = new PlayerModel(0.0f, false);
    private int centerW = this.field_230708_k_ / 2;
    private int centerH = this.field_230709_l_ / 2;
    private float scale = 80.0f;
    private float xRot = 0.0f;
    private float yRot = 0.0f;

    public ExtrasEditorScreen() {
        super(StringTextComponent.field_240750_d_);
        this.client = PlayerExtraDataStore.get(UUIDTypeAdapter.fromString((String)this.field_230706_i_.func_110432_I().func_148255_b()));
    }

    @Override
    public void func_231160_c_() {
        ArrayList list;
        super.func_231160_c_();
        this.centerW = this.field_230708_k_ / 2;
        this.centerH = this.field_230709_l_ / 2;
        if (this.client.getAvailableHats().size() > 0) {
            this.func_230481_d_((IGuiEventListener)new LabelWidget(I18n.func_135052_a((String)"pixelmon.cosmetic.hat", (Object[])new Object[0]), 0, this.centerW - 140, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.HatType[]{PixelExtrasData.HatType.NONE});
            list.addAll(this.client.getAvailableHats());
            this.addDropDown(new DropDown<PixelExtrasData.HatType>(list, this.client.getHatType(), this.centerW - 180, this.centerH - 80, 80, 100).setGetOptionString(hat -> I18n.func_135052_a((String)("pixelmon.cosmetic.hat." + hat.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(hat -> {
                this.client.setHatType((PixelExtrasData.HatType)((Object)hat));
                this.client.setEnabled(PixelExtrasData.Category.HAT, true);
            }));
        }
        if (this.client.getAvailableSashs().size() > 0) {
            this.func_230481_d_((IGuiEventListener)new LabelWidget(I18n.func_135052_a((String)"pixelmon.cosmetic.sash", (Object[])new Object[0]), 0, this.centerW - 140, this.centerH - 40, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.SashType[]{PixelExtrasData.SashType.NONE});
            list.addAll(this.client.getAvailableSashs());
            this.addDropDown(new DropDown<PixelExtrasData.SashType>(list, this.client.getSashType(), this.centerW - 180, this.centerH - 20, 80, 100).setGetOptionString(sash -> I18n.func_135052_a((String)("pixelmon.cosmetic.sash." + sash.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(sash -> {
                this.client.setSashType((PixelExtrasData.SashType)((Object)sash));
                this.client.setEnabled(PixelExtrasData.Category.SASH, true);
            }));
        }
        if (this.client.getAvailableRobes().size() > 0) {
            this.func_230481_d_((IGuiEventListener)new LabelWidget(I18n.func_135052_a((String)"pixelmon.cosmetic.robe", (Object[])new Object[0]), 0, this.centerW + 140, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.RobeType[]{PixelExtrasData.RobeType.NONE});
            list.addAll(this.client.getAvailableRobes());
            this.addDropDown(new DropDown<PixelExtrasData.RobeType>(list, this.client.getRobeType(), this.centerW + 100, this.centerH - 80, 80, 100).setGetOptionString(robe -> I18n.func_135052_a((String)("pixelmon.cosmetic.robe." + robe.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(robe -> {
                this.client.setRobeType((PixelExtrasData.RobeType)((Object)robe));
                this.client.setEnabled(PixelExtrasData.Category.ROBE, true);
            }));
        }
        if (this.client.getAvailableMonocles().size() > 0) {
            this.func_230481_d_((IGuiEventListener)new LabelWidget(I18n.func_135052_a((String)"pixelmon.cosmetic.monocle", (Object[])new Object[0]), 0, this.centerW + 140, this.centerH - 40, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.MonocleType[]{PixelExtrasData.MonocleType.NONE});
            list.addAll(this.client.getAvailableMonocles());
            this.addDropDown(new DropDown<PixelExtrasData.MonocleType>(list, this.client.getMonocleType(), this.centerW + 100, this.centerH - 20, 80, 100).setGetOptionString(monocle -> I18n.func_135052_a((String)("pixelmon.cosmetic.monocle." + monocle.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(monocle -> {
                this.client.setMonocleType((PixelExtrasData.MonocleType)((Object)monocle));
                this.client.setEnabled(PixelExtrasData.Category.MONOCLE, true);
            }));
        }
        if (this.client.getAvailableWings().size() > 0) {
            this.func_230481_d_((IGuiEventListener)new LabelWidget(I18n.func_135052_a((String)"pixelmon.cosmetic.wings", (Object[])new Object[0]), 0, this.centerW, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.WingType[]{PixelExtrasData.WingType.NONE});
            list.addAll(this.client.getAvailableWings());
            this.addDropDown(new DropDown<PixelExtrasData.WingType>(list, this.client.getWingType(), this.centerW - 40, this.centerH - 80, 80, 100).setGetOptionString(wings -> I18n.func_135052_a((String)("pixelmon.cosmetic.wings." + wings.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(wings -> {
                this.client.setWingType((PixelExtrasData.WingType)((Object)wings));
                this.client.setEnabled(PixelExtrasData.Category.WINGS, true);
            }));
        }
        if (this.func_231177_au__()) {
            int slot = 0;
            for (Pokemon pokemon : ClientStorageManager.party.getAll()) {
                if (pokemon == null) continue;
                this.func_230480_a_((Widget)new UpdatingImageButton(1, this.centerW - 30 * (ClientStorageManager.party.countAll() / 2 + 1) + ++slot * 30, this.field_230709_l_ - 35, 30, 30, () -> ClientStorageManager.party.get(pokemon.getPosition().order).getSprite(), 1.0f, 1.0f, 1.0f, onPress -> NetworkHelper.sendToServer(PlayerExtrasPacket.getSetTexturePacket(((StoragePosition)pokemon.getStorageAndPosition().func_76340_b()).order + 1))));
            }
        }
        this.func_230480_a_((Widget)new Button(25, this.field_230709_l_ - 75, 50, 20, (ITextComponent)new TranslationTextComponent("menu.discord"), onClick -> Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(e -> {
            if (e) {
                Util.func_110647_a().func_195640_a("https://discord.gg/pixelmon");
            }
            Minecraft.func_71410_x().func_147108_a((Screen)new ExtrasEditorScreen());
        }, "https://discord.gg/pixelmon", true))));
        this.func_230480_a_((Widget)new Button(25, this.field_230709_l_ - 50, 50, 20, (ITextComponent)new TranslationTextComponent("menu.refresh"), onClick -> PlayerExtraDataStore.refreshClient(newData -> Minecraft.func_71410_x().func_147108_a((Screen)new ExtrasEditorScreen()))));
        this.func_230480_a_((Widget)new Button(25, this.field_230709_l_ - 25, 50, 20, (ITextComponent)new TranslationTextComponent("gui.cosmetic.back"), e -> this.func_231175_as__()));
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.field_230706_i_.field_71439_g != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 100.0);
            ScreenHelper.drawEntity(matrix, (LivingEntity)this.field_230706_i_.field_71439_g, this.centerW, this.centerH + this.centerH / 2, this.scale, this.xRot, this.yRot);
            matrix.func_227865_b_();
        } else {
            IRenderTypeBuffer.Impl impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder none = impl.getBuffer(RenderType.func_228644_e_((ResourceLocation)ResourceLocationHelper.of("textures/entity/fox/fox.png")));
            matrix.func_227860_a_();
            this.model.func_225598_a_(matrix, none, 0xF000F0, 1, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
    }

    public void func_231164_f_() {
        PlayerExtraDataStore.saveAndSend();
    }

    @Override
    public boolean func_231177_au__() {
        return Minecraft.func_71410_x().field_71439_g != null;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.func_231177_au__()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new IngameMenuScreen(true));
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!super.func_231043_a_(mouseX, mouseY, delta)) {
            this.scale = (float)((double)this.scale + delta);
        }
        return true;
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!super.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            this.xRot = (float)((double)this.xRot - dragX);
            this.yRot = (float)((double)this.yRot - dragY);
        }
        return true;
    }
}

