/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUpPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class LevelUpScreen
extends BattleScreen {
    private EnumLevelStage drawLevelStage = EnumLevelStage.First;

    public LevelUpScreen(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.drawLevelStage = EnumLevelStage.First;
    }

    @Override
    public void render(MatrixStack matrix, int width, int height, int mouseX, int mouseY, float partialTicks) {
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        if (this.bm.battleType == BattleType.RAID) {
            try {
                this.bm.processBattleTasks();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.bm.battleControllerIndex != -1) {
            this.renderBackground(matrix, width, height, mouseX, mouseY, 0);
            this.drawButtons(matrix, mouseX, mouseY, partialTicks);
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (ClientProxy.camera != null) {
            this.parent.bm.setCameraToPlayer();
        }
        ScreenHelper.drawImageQuad(Resources.levelUpPopup, matrix, (float)width / 2.0f - 52.0f, (float)height / 2.0f - 66.0f, 104.0f, 113.0f, 0.0f, 0.0f, 0.40625f, 0.44140625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (!this.bm.levelUpList.isEmpty()) {
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.hp2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 - 54), (int)0xFFFFFF);
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.attack2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 - 38), (int)0xFFFFFF);
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.defense2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 - 22), (int)0xFFFFFF);
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.spattack2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 - 6), (int)0xFFFFFF);
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.spdefense2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 + 10), (int)0xFFFFFF);
            LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"nbt.speed2", (Object[])new Object[0]), (int)(width / 2 - 43), (int)(height / 2 + 26), (int)0xFFFFFF);
            LevelUpPacket levelUp = this.bm.levelUpList.get(0);
            if (this.drawLevelStage == EnumLevelStage.First) {
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.HP - levelUp.statsLevel1.HP)), (int)(width / 2 + 25), (int)(height / 2 - 54), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.Attack - levelUp.statsLevel1.Attack)), (int)(width / 2 + 25), (int)(height / 2 - 38), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.Defense - levelUp.statsLevel1.Defense)), (int)(width / 2 + 25), (int)(height / 2 - 22), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.SpecialAttack - levelUp.statsLevel1.SpecialAttack)), (int)(width / 2 + 25), (int)(height / 2 - 6), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.SpecialDefense - levelUp.statsLevel1.SpecialDefense)), (int)(width / 2 + 25), (int)(height / 2 + 10), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("+" + (levelUp.statsLevel2.Speed - levelUp.statsLevel1.Speed)), (int)(width / 2 + 25), (int)(height / 2 + 26), (int)0xFFFFFF);
            } else if (this.drawLevelStage == EnumLevelStage.Second) {
                PixelmonStatsData stats = levelUp.statsLevel2;
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.HP), (int)(stats.HP < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 - 54), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.Attack), (int)(stats.Attack < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 - 38), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.Defense), (int)(stats.Defense < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 - 22), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.SpecialAttack), (int)(stats.SpecialAttack < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 - 6), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.SpecialDefense), (int)(stats.SpecialDefense < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 + 10), (int)0xFFFFFF);
                LevelUpScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)("" + stats.Speed), (int)(stats.Speed < 100 ? width / 2 + 28 : width / 2 + 22), (int)(height / 2 + 26), (int)0xFFFFFF);
            }
            UUID uuid = levelUp.pokemonUUID;
            if (this.bm != null) {
                PixelmonClientData pig = this.bm.getPokemon(uuid);
                if (pig != null) {
                    String name = pig.getDisplayName();
                    if (this.bm.battleControllerIndex != -1) {
                        this.parent.battleLog.setActiveMessage(I18n.func_135052_a((String)"gui.levelupscreen.lvlup", (Object[])new Object[]{name, levelUp.level}));
                        try {
                            this.parent.battleLog.drawElement(matrix, 40, height - 80, Math.min(this.field_230708_k_ - 80, 260), 80, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.parent.restoreSettingsAndClose();
                }
            } else {
                this.parent.restoreSettingsAndClose();
            }
        }
    }

    public void func_231023_e_() {
        this.parent.battleLog.func_110550_d();
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.parent.battleLog.processUpDown(mouseX, mouseY)) {
            return;
        }
        if (this.parent.battleLog.withinBounds(mouseX, mouseY) && this.parent.bm.hasMoreMessages()) {
            this.parent.battleLog.acknowledge();
        } else if (this.drawLevelStage == EnumLevelStage.First) {
            this.drawLevelStage = EnumLevelStage.Second;
        } else {
            try {
                LevelUpPacket levelUp = this.bm.levelUpList.remove(0);
                String name = this.bm.getPokemon(levelUp.pokemonUUID).getDisplayName();
                this.parent.battleLog.forceAddMessage(I18n.func_135052_a((String)"gui.levelupscreen.lvlup", (Object[])new Object[]{name, levelUp.level}));
            }
            catch (Exception e) {
                this.bm.setMode(this.bm.getOldMode());
                this.bm.checkClearedMessages();
                return;
            }
            if (this.bm.hasLevelUps()) {
                this.drawLevelStage = EnumLevelStage.First;
            } else if (this.bm.battleControllerIndex == -1 && !this.bm.hasNewAttacks()) {
                this.parent.restoreSettingsAndClose();
            } else {
                this.bm.setMode(this.bm.getOldMode());
                this.bm.checkClearedMessages();
            }
        }
    }

    @Override
    public boolean isScreen() {
        return super.isScreen() && this.bm.hasLevelUps();
    }

    public static enum EnumLevelStage {
        First,
        Second,
        Third;

    }
}

