/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override.multiplayer;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.override.multiplayer.CustomServerData;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomServerList
extends ServerList {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft minecraft;
    private final List<CustomServerData> favouritedServers = Lists.newArrayList();
    private final List<CustomServerData> serverList = Lists.newArrayList();

    public CustomServerList(Minecraft p_i1194_1_) {
        super(p_i1194_1_);
        this.minecraft = p_i1194_1_;
        if (ClientProxy.getRichPresence() != null) {
            ClientProxy.getRichPresence().setAcknowledgedServer(false);
        }
        this.func_78853_a();
    }

    public void func_78853_a() {
        if (this.serverList == null) {
            return;
        }
        try {
            this.serverList.clear();
            this.favouritedServers.clear();
            CompoundNBT compoundnbt = CompressedStreamTools.func_74797_a((File)new File(this.minecraft.field_71412_D, "servers.dat"));
            if (compoundnbt == null) {
                return;
            }
            ListNBT listnbt = compoundnbt.func_150295_c("servers", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.serverList.add(CustomServerData.read(listnbt.func_150305_b(i)));
            }
            if (compoundnbt.func_74764_b("favourites")) {
                ListNBT favourites = compoundnbt.func_150295_c("favourites", 10);
                for (int i = 0; i < favourites.size(); ++i) {
                    this.favouritedServers.add(CustomServerData.read(favourites.func_150305_b(i)));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load server list", (Throwable)exception);
        }
    }

    public void func_78855_b() {
        try {
            ListNBT listnbt = new ListNBT();
            for (CustomServerData customServerData : this.serverList) {
                listnbt.add((Object)customServerData.func_78836_a());
            }
            ListNBT favourites = new ListNBT();
            for (CustomServerData serverdata : this.favouritedServers) {
                favourites.add((Object)serverdata.func_78836_a());
            }
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("servers", (INBT)listnbt);
            compoundNBT.func_218657_a("favourites", (INBT)favourites);
            File file3 = File.createTempFile("servers", ".dat", this.minecraft.field_71412_D);
            CompressedStreamTools.func_74795_b((CompoundNBT)compoundNBT, (File)file3);
            File file1 = new File(this.minecraft.field_71412_D, "servers.dat_old");
            File file2 = new File(this.minecraft.field_71412_D, "servers.dat");
            Util.func_240977_a_((File)file2, (File)file3, (File)file1);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save server list", (Throwable)exception);
        }
    }

    public CustomServerData getServer(int p_78850_1_) {
        if (p_78850_1_ < this.favouritedServers.size()) {
            return this.favouritedServers.get(p_78850_1_);
        }
        return this.serverList.get(p_78850_1_ - this.favouritedServers.size());
    }

    public void func_217506_a(ServerData p_217506_1_) {
        this.serverList.remove(p_217506_1_);
        this.favouritedServers.remove(p_217506_1_);
    }

    public void add(CustomServerData p_78849_1_) {
        this.serverList.add(p_78849_1_);
    }

    public int func_78856_c() {
        return this.serverList.size() + this.favouritedServers.size();
    }

    public void func_78857_a(int p_78857_1_, int p_78857_2_) {
        if (p_78857_1_ < this.favouritedServers.size() || p_78857_2_ < this.favouritedServers.size()) {
            return;
        }
        CustomServerData serverdata = this.getServer(p_78857_1_);
        this.serverList.set(p_78857_1_ - this.favouritedServers.size(), this.getServer(p_78857_2_));
        this.serverList.set(p_78857_2_ - this.favouritedServers.size(), serverdata);
        this.func_78855_b();
    }

    public void replace(int p_147413_1_, CustomServerData p_147413_2_) {
        this.serverList.set(p_147413_1_ - this.favouritedServers.size(), p_147413_2_);
    }

    public void toggleFavourite(CustomServerData serverData) {
        if (this.favouritedServers.contains((Object)serverData)) {
            this.favouritedServers.remove((Object)serverData);
            this.serverList.add(serverData);
        } else {
            this.favouritedServers.add(serverData);
            this.serverList.remove((Object)serverData);
        }
    }

    public boolean isFavourite(ServerData serverData) {
        return this.favouritedServers.contains(serverData);
    }

    public void randomize() {
        Collections.shuffle(this.serverList);
        this.func_78855_b();
    }

    public ServerData func_78850_a(int p_78850_1_) {
        return this.serverList.get(p_78850_1_);
    }
}

