/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.spawner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.spawner.PokemonListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.Checkbox;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.comm.PixelmonSpawnerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UpdateSpawnerPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PixelmonSpawnerScreen
extends Screen {
    protected PokemonListScreen list;
    protected PixelmonSpawnerTileEntity ps;
    private int listTop;
    private int listLeft;
    private int listHeight;
    private int listWidth;
    private boolean page;
    private TextFieldWidget pokemonNameBox;
    private TextFieldWidget rarityBox;
    private TextFieldWidget spawnTickBox;
    private TextFieldWidget spawnRadiusBox;
    private TextFieldWidget maxSpawnsBox;
    private TextFieldWidget levelMinBox;
    private TextFieldWidget levelMaxBox;
    private TextFieldWidget bossRatioBox;
    private TextFieldWidget shinyRatioBox;
    private TextFieldWidget gmaxRatio;
    private CheckboxButton globalUncatchableBox;
    private CheckboxButton globalUnbreedable;
    private CheckboxButton globalUnbattleable;

    public PixelmonSpawnerScreen(int x, int y, int z) {
        super(StringTextComponent.field_240750_d_);
        this.ps = (PixelmonSpawnerTileEntity)Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, y, z));
        this.listTop = 58;
        this.listLeft = 15;
        this.listWidth = 100;
        this.page = true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        this.list = new PokemonListScreen(this, 250, this.field_230709_l_ - 80, 25, 15);
        this.func_230480_a_((Widget)new IndexedButton(0, this.listLeft + this.listWidth + 30, this.field_230709_l_ - 40, 30, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.add"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(5, this.listLeft + this.listWidth + 65, this.field_230709_l_ - 40, 70, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.deletepoke"), this::actionPerformed));
        this.func_230480_a_((Widget)new ImageButton(1, this.field_230708_k_ - 30, 15, 15, 15, ResourceLocationHelper.of("pixelmon:textures/gui/uielements/tile006.png"), 255.0f, 0.0f, 0.0f, this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(6, this.field_230708_k_ - 115, this.field_230709_l_ - 40, 30, 20, "<", this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(7, this.field_230708_k_ - 45, this.field_230709_l_ - 40, 30, 20, ">", this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(3, this.field_230708_k_ - 115, 35, 100, 20, this.ps.aggression.getLocalizedName(), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(4, this.field_230708_k_ - 115, 60, 100, 20, this.ps.spawnLocation.getLocalizedName(), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(2, this.field_230708_k_ - 115, 85, 100, 20, (ITextComponent)(this.ps.fireOnTick ? new TranslationTextComponent("gui.pixelmonspawner.fireontick") : new TranslationTextComponent("gui.pixelmonspawner.fireonredstone")), this::actionPerformed));
        for (Widget indexedButton : this.field_230710_m_) {
            if (!(indexedButton instanceof IndexedButton) || ((IndexedButton)indexedButton).id < 2 || ((IndexedButton)indexedButton).id > 4) continue;
            indexedButton.field_230694_p_ = !indexedButton.field_230694_p_;
        }
        this.pokemonNameBox = new TabCompleteTextField(5, Minecraft.func_71410_x().field_71466_p, this.listLeft, this.field_230709_l_ - 40, 80, 20).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.pokemonNameBox.func_146180_a("Charizard");
        this.pokemonNameBox.func_146203_f(1000);
        this.field_230705_e_.add(this.pokemonNameBox);
        this.rarityBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.listLeft + 85, this.field_230709_l_ - 40, 40, 20, StringTextComponent.field_240750_d_);
        this.rarityBox.func_146180_a("1");
        this.field_230705_e_.add(this.rarityBox);
        this.spawnTickBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 35, 40, 10, StringTextComponent.field_240750_d_);
        this.spawnTickBox.func_146180_a("" + this.ps.spawnTick);
        this.field_230705_e_.add(this.spawnTickBox);
        this.spawnRadiusBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 50, 40, 10, StringTextComponent.field_240750_d_);
        this.spawnRadiusBox.func_146180_a("" + this.ps.spawnRadius);
        this.field_230705_e_.add(this.spawnRadiusBox);
        this.maxSpawnsBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 65, 40, 10, StringTextComponent.field_240750_d_);
        this.maxSpawnsBox.func_146180_a("" + this.ps.maxSpawns);
        this.field_230705_e_.add(this.maxSpawnsBox);
        this.levelMinBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 80, 40, 10, StringTextComponent.field_240750_d_);
        this.levelMinBox.func_146180_a("" + this.ps.levelMin);
        this.field_230705_e_.add(this.levelMinBox);
        this.levelMaxBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 95, 40, 10, StringTextComponent.field_240750_d_);
        this.levelMaxBox.func_146180_a("" + this.ps.levelMax);
        this.field_230705_e_.add(this.levelMaxBox);
        this.bossRatioBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 110, 40, 10, StringTextComponent.field_240750_d_);
        this.bossRatioBox.func_146180_a("" + this.ps.bossRatio);
        this.field_230705_e_.add(this.bossRatioBox);
        this.shinyRatioBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 125, 40, 10, StringTextComponent.field_240750_d_);
        this.shinyRatioBox.func_146180_a("" + this.ps.shinyRatio);
        this.field_230705_e_.add(this.shinyRatioBox);
        this.gmaxRatio = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.field_230708_k_ - 56, 140, 40, 10, StringTextComponent.field_240750_d_);
        this.gmaxRatio.func_146180_a("" + this.ps.gmaxRatio);
        this.field_230705_e_.add(this.gmaxRatio);
        this.globalUncatchableBox = new Checkbox(1, this.field_230708_k_ - 26, 155, 10, 10, this.ps.uncatchable, this::actionPerformed);
        this.field_230705_e_.add(this.globalUncatchableBox);
        this.globalUnbattleable = new Checkbox(1, this.field_230708_k_ - 26, 170, 10, 10, this.ps.unbattleable, this::actionPerformed);
        this.field_230705_e_.add(this.globalUnbattleable);
        this.globalUnbreedable = new Checkbox(1, this.field_230708_k_ - 26, 185, 10, 10, this.ps.unbreedable, this::actionPerformed);
        this.field_230705_e_.add(this.globalUnbreedable);
        this.field_230705_e_.add(this.list);
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        Minecraft.func_71410_x().func_238209_b_(true);
        this.list.func_231044_a_(par1, par2, par3);
        boolean superCall = super.func_231044_a_(par1, par2, par3);
        Minecraft.func_71410_x().func_238209_b_(force);
        return superCall;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        Minecraft.func_71410_x().func_238209_b_(true);
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, 10.0f, 10.0f, this.field_230708_k_ - 20, this.field_230709_l_ - 20, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        if (this.isFullScreen()) {
            ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)((double)this.field_230708_k_ / 2.0 - 0.2 * (double)this.field_230708_k_), 10.0f, 0.4f * (float)this.field_230708_k_, this.field_230709_l_ - 20, 0.0f, 1.0f, 1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.25f, 0.0f);
            if (this.list.selectedElement != -1) {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)this.field_230709_l_ * 0.125, 300.0);
                float scalar = 1.0f;
                double referenceW = (float)this.field_230709_l_ / 18.0f;
                double referenceH = (float)this.field_230709_l_ / 18.0f;
                double dh = this.list.selectedPokemon.getForm().getDimensions().getHeight() - referenceH;
                double dw = this.list.selectedPokemon.getForm().getDimensions().getWidth() - referenceW;
                scalar = dh > dw ? (float)(referenceH / this.list.selectedPokemon.getForm().getDimensions().getHeight()) : (float)(referenceW / this.list.selectedPokemon.getForm().getDimensions().getWidth());
                matrix.func_227862_a_(scalar, scalar, scalar);
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                PixelmonRendering.renderEntity(matrix, new PixelmonEntity((World)this.field_230706_i_.field_71441_e, this.list.selectedPokemon), true, partialTicks);
                matrix.func_227865_b_();
                matrix.func_227865_b_();
            }
        }
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!(child instanceof Widget)) continue;
            ((Widget)child).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.pokemonspec", (Object[])new Object[0]), 15.0f, 15.0f, 0);
        font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner", (Object[])new Object[0]), (float)(this.listLeft + 2), (float)(this.field_230709_l_ - 50), 0);
        font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.rarity", (Object[])new Object[0]), (float)(this.listLeft + 87), (float)(this.field_230709_l_ - 50), 0);
        if (this.page) {
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.spawntick", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 35.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.radius", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 50.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.maxspawns", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 65.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.minlevel", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 80.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.maxlevel", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 95.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.bossratio", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 110.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.shinyratio", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 125.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.gmaxratio", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 140.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.uncatchable", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 155.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.unbattleable", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 170.0f, 0);
            font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.unbreedable", (Object[])new Object[0]), (float)(this.field_230708_k_ - 110), 185.0f, 0);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.isFullScreen() && (this.list.selectedElement == -1 || this.list.selectedElement >= this.list.getSize())) {
            String text = I18n.func_135052_a((String)"gui.pixelmonspawner.select", (Object[])new Object[0]);
            font.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f - (float)font.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f, 0);
        }
        Minecraft.func_71410_x().func_238209_b_(force);
    }

    public void func_231023_e_() {
        this.pokemonNameBox.func_146178_a();
        this.rarityBox.func_146178_a();
        this.spawnTickBox.func_146178_a();
        this.spawnRadiusBox.func_146178_a();
        this.maxSpawnsBox.func_146178_a();
        this.levelMinBox.func_146178_a();
        this.levelMaxBox.func_146178_a();
        this.bossRatioBox.func_146178_a();
        this.shinyRatioBox.func_146178_a();
        this.gmaxRatio.func_146178_a();
    }

    protected void actionPerformed(Button button) {
        if (button.field_230693_o_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 0) {
                int rarityString;
                PokemonSpecification pokemon = PokemonSpecificationProxy.create(this.pokemonNameBox.func_146179_b());
                try {
                    rarityString = Integer.parseInt(this.rarityBox.func_146179_b());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (pokemon.getValue(SpeciesRequirement.class).isPresent() && rarityString > 0) {
                    int rarity = rarityString;
                    this.ps.pokemonList.add(new PokemonRarity(pokemon, rarity));
                    this.list.bindAmountScrolled();
                }
            } else if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                boolean bl = this.ps.fireOnTick = !this.ps.fireOnTick;
                if (this.ps.fireOnTick) {
                    button.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.pixelmonspawner.fireontick"));
                } else {
                    button.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.pixelmonspawner.fireonredstone"));
                }
            } else if (id == 3) {
                this.ps.aggression = Aggression.nextAggression(this.ps.aggression);
                button.func_238482_a_((ITextComponent)new StringTextComponent(this.ps.aggression.getLocalizedName()));
            } else if (id == 4) {
                this.ps.spawnLocation = SpawnLocationType.nextLocation(this.ps.spawnLocation);
                button.func_238482_a_((ITextComponent)new StringTextComponent(this.ps.spawnLocation.getLocalizedName()));
            } else if (id == 5) {
                if (this.list.selectedElement == -1 || this.list.selectedElement >= this.list.getSize()) {
                    return;
                }
                this.list.gui.removeFromList(this.list.selectedElement);
                this.list.bindAmountScrolled();
            } else if (id == 6 || id == 7) {
                this.page = !this.page;
                for (IGuiEventListener child : this.field_230705_e_) {
                    if (child instanceof TextFieldWidget && ((TextFieldWidget)child).field_230690_l_ > this.field_230708_k_ - 150) {
                        boolean bl = ((TextFieldWidget)child).field_230694_p_ = !((TextFieldWidget)child).field_230694_p_;
                    }
                    if (child instanceof Checkbox) {
                        boolean bl = ((Checkbox)child).field_230694_p_ = !((Checkbox)child).field_230694_p_;
                    }
                    if (!(child instanceof IndexedButton)) continue;
                    IndexedButton indexedButton = (IndexedButton)child;
                    if (indexedButton.id < 2 || indexedButton.id > 4) continue;
                    indexedButton.field_230694_p_ = !indexedButton.field_230694_p_;
                }
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            ScreenHelper.closeScreen();
        }
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.saveFields();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
    }

    private boolean checkFields() {
        int spawnTicks = NumberHelper.parseInteger(this.spawnTickBox.func_146179_b()).orElse(0);
        int spawnRadius = NumberHelper.parseInteger(this.spawnRadiusBox.func_146179_b()).orElse(0);
        int maxSpawns = NumberHelper.parseInteger(this.maxSpawnsBox.func_146179_b()).orElse(0);
        int levelMin = NumberHelper.parseInteger(this.levelMinBox.func_146179_b()).orElse(0);
        int levelMax = NumberHelper.parseInteger(this.levelMaxBox.func_146179_b()).orElse(0);
        float bossRatio = (float)NumberHelper.parseDouble(this.bossRatioBox.func_146179_b()).orElse(0.0);
        float gmaxRatio = (float)NumberHelper.parseDouble(this.gmaxRatio.func_146179_b()).orElse(0.0);
        float shinyRatio = (float)NumberHelper.parseDouble(this.shinyRatioBox.func_146179_b()).orElse(0.0);
        boolean uncatchable = this.globalUncatchableBox.func_212942_a();
        boolean unbattleable = this.globalUnbattleable.func_212942_a();
        boolean unbreedable = this.globalUnbreedable.func_212942_a();
        if (spawnTicks > 0 && spawnTicks < 1000 && spawnRadius > 0 && spawnRadius < 50 && maxSpawns > 0 && maxSpawns < 50 && levelMin > 0 && levelMin <= PixelmonServerConfig.maxLevel && levelMax >= levelMin && levelMax <= PixelmonServerConfig.maxLevel) {
            this.ps.spawnTick = spawnTicks;
            this.ps.spawnRadius = spawnRadius;
            this.ps.maxSpawns = maxSpawns;
            this.ps.levelMin = levelMin;
            this.ps.levelMax = levelMax;
            this.ps.bossRatio = bossRatio;
            this.ps.gmaxRatio = gmaxRatio;
            this.ps.shinyRatio = shinyRatio;
            this.ps.unbattleable = unbattleable;
            this.ps.uncatchable = uncatchable;
            this.ps.unbreedable = unbreedable;
            CompoundNBT nbt = new CompoundNBT();
            this.ps.func_189515_b(nbt);
            PixelmonSpawnerData p = new PixelmonSpawnerData(this.ps.func_174877_v(), nbt, this.ps.pokemonList);
            NetworkHelper.sendToServer(new UpdateSpawnerPacket(p));
            return true;
        }
        return false;
    }

    public PokemonRarity getPokemonListEntry(int ind) {
        if (ind < this.ps.pokemonList.size() && ind >= 0) {
            return this.ps.pokemonList.get(ind);
        }
        return null;
    }

    public int getBiggestRarity() {
        int largest = Integer.MIN_VALUE;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            if (pokemonRarity.rarity <= largest) continue;
            largest = pokemonRarity.rarity;
        }
        return largest;
    }

    public int getBiggestSpec(int maxSize) {
        int largest = Integer.MIN_VALUE;
        String largestText = null;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            int length = Minecraft.func_71410_x().field_71466_p.func_78256_a(pokemonRarity.pokemon.toString());
            if (length <= largest) continue;
            largestText = pokemonRarity.pokemon.toString();
            largest = length;
        }
        if (largestText == null) {
            return 0;
        }
        if (largestText.length() > maxSize) {
            largestText = largestText.substring(0, maxSize + 1);
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(largestText);
        }
        return largest;
    }

    public String getPercentage(int index) {
        PokemonRarity pokemonListEntry = this.getPokemonListEntry(index);
        double total = 0.0;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            total += (double)pokemonRarity.rarity;
        }
        return String.format("%.2f", (double)pokemonListEntry.rarity / total * 100.0);
    }

    public boolean isFullScreen() {
        return Minecraft.func_71410_x().func_228018_at_().func_198109_k() > 900;
    }

    public int getPokemonListCount() {
        return this.ps.pokemonList.size();
    }

    public void removeFromList(int var1) {
        this.ps.pokemonList.remove(var1);
    }
}

