/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextScrollBar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.StringTextComponent;

public class TextFieldMultipleLine
extends TextFieldWidget {
    private int enabledColor = 0xE0E0E0;
    private float cursorCounter = 0.0f;
    private TextScrollBar scrollBar;
    private int mouseX;
    private int mouseY;
    private boolean scrollToCursor;
    protected List<String> splitString = new ArrayList<String>();

    public TextFieldMultipleLine(int x, int y, int width, int height) {
        super(Minecraft.func_71410_x().field_71466_p, x, y, width, height, StringTextComponent.field_240750_d_);
        this.func_146203_f(Integer.MAX_VALUE);
        this.scrollBar = new TextScrollBar(this);
    }

    public void func_146178_a() {
        super.func_146178_a();
        this.cursorCounter += 1.0f;
    }

    public void func_146180_a(String value) {
        super.func_146180_a(value.replace("\r\n", "\n").replace("\r", "\n"));
    }

    public void func_146191_b(String addText) {
        if ((addText = addText.replace("\r\n", "\n").replace("\r", "\n")).contains("\n")) {
            String newText = "";
            int cursorPosition = this.func_146198_h();
            String text = this.func_146179_b();
            int start = Math.min(cursorPosition, this.field_146223_s);
            int end = Math.max(cursorPosition, this.field_146223_s);
            int length = 0;
            if (!text.isEmpty()) {
                newText = newText + text.substring(0, start);
            }
            newText = newText + addText;
            length = addText.length();
            if (text.length() > 0 && end < text.length()) {
                newText = newText + text.substring(end);
            }
            this.func_146180_a(newText);
            this.func_146190_e(cursorPosition);
            this.func_146182_d(start - this.field_146223_s + length);
        } else {
            String s;
            int l;
            int i = this.field_146224_r < this.field_146223_s ? this.field_146224_r : this.field_146223_s;
            int j = this.field_146224_r < this.field_146223_s ? this.field_146223_s : this.field_146224_r;
            int k = this.field_146217_k - this.field_146216_j.length() - (i - j);
            if (k < (l = (s = SharedConstants.func_71565_a((String)addText)).length())) {
                s = s.substring(0, k);
                l = k;
            }
            int[] splitStringPosition = this.getSplitStringPositionOffset(this.func_146198_h());
            String s1 = new StringBuilder(this.splitString.get(splitStringPosition[0])).replace(splitStringPosition[1], splitStringPosition[1], s).toString();
            this.splitString.set(splitStringPosition[0], s1);
            String value = String.join((CharSequence)"\n", this.splitString);
            if (this.field_175209_y.test(value)) {
                this.field_146216_j = value;
                this.func_212422_f(i + l);
                this.func_146199_i(this.field_146224_r);
            }
        }
    }

    public void func_146175_b(int p_146175_1_) {
        if (!this.field_146216_j.isEmpty()) {
            if (this.field_146223_s != this.field_146224_r) {
                this.func_146191_b("");
            } else {
                int[] splitStringPosition = this.getSplitStringPositionOffset(this.func_146198_h());
                if (splitStringPosition[1] == 0) {
                    this.splitString.remove(splitStringPosition[0]);
                } else {
                    String s1 = new StringBuilder(this.splitString.get(splitStringPosition[0])).delete(splitStringPosition[1] - 1, splitStringPosition[1]).toString();
                    this.splitString.set(splitStringPosition[0], s1);
                }
                String value = String.join((CharSequence)"\n", this.splitString);
                if (this.field_175209_y.test(value)) {
                    this.field_146216_j = value;
                    int[] splitStringPosition1 = this.getSplitStringPosition(this.func_146198_h());
                    int cursorX = this.getInitialXPosition() + splitStringPosition1[1];
                    this.moveCursor(splitStringPosition[0], cursorX - 1);
                }
            }
        }
    }

    public boolean func_231044_a_(double x, double y, int buttonClicked) {
        boolean mouseInTextField;
        boolean retur = super.func_231044_a_(x, y, buttonClicked);
        boolean bl = mouseInTextField = x >= (double)this.field_230690_l_ && x < (double)(this.field_230690_l_ + this.field_230688_j_) && y >= (double)this.field_230691_m_ && y < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (this.func_230999_j_() && mouseInTextField && buttonClicked == 0) {
            this.field_146211_a.getClass();
            int lineOffset = 9 + 2;
            int cursorLine = (int)((y - (double)this.field_230691_m_ - 4.0) / (double)lineOffset + (double)this.scrollBar.getTopIndex());
            this.moveCursor(cursorLine, (int)x);
        }
        return retur;
    }

    private void moveCursor(int line, int x) {
        if (line < 0) {
            this.func_146196_d();
        } else if (line >= this.splitString.size()) {
            this.func_146202_e();
        } else {
            int newPosition = 0;
            for (int i = 0; i < line; ++i) {
                newPosition += this.splitString.get(i).length();
            }
            String currentLine = this.splitString.get(line);
            int currentWidth = 0;
            int mouseXOffset = x - this.field_230690_l_ - 4;
            if (mouseXOffset > 0) {
                int linePosition = -1;
                int currentLineLength = currentLine.length();
                for (int i = 0; i < currentLineLength; ++i) {
                    if (currentWidth > mouseXOffset) {
                        linePosition = i - 1;
                        break;
                    }
                    currentWidth += this.field_146211_a.func_78256_a(String.valueOf(currentLine.charAt(i)));
                }
                if (linePosition == -1) {
                    linePosition = !currentLine.isEmpty() && currentLine.charAt(currentLineLength - 1) == '\n' ? currentLineLength - 1 : currentLineLength;
                }
                newPosition += linePosition;
            }
            this.func_146190_e(newPosition);
        }
        this.scrollToCursor = true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.scrollToCursor = true;
        if (keyCode == 335 || keyCode == 257) {
            this.func_146191_b("\n");
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            int[] cursorStringData = this.getSplitStringPosition(this.func_146198_h());
            int cursorLine = cursorStringData[0];
            int cursorX = this.getInitialXPosition() + cursorStringData[1];
            if (keyCode == 265) {
                this.moveCursor(cursorLine - 1, cursorX);
            } else {
                this.moveCursor(cursorLine + 1, cursorX);
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private int getInitialXPosition() {
        return this.func_146181_i() ? this.field_230690_l_ + 4 : this.field_230690_l_;
    }

    int getLineHeight() {
        this.field_146211_a.getClass();
        return 9 + 2;
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (this.func_146176_q()) {
            boolean enableBackgroundDrawing = this.func_146181_i();
            int cursorPosition = this.func_146198_h();
            String text = this.func_146179_b();
            boolean isFocused = this.func_230999_j_();
            if (enableBackgroundDrawing) {
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)-6250336);
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
            }
            int textColor = this.enabledColor;
            boolean cursorInBox = cursorPosition >= 0 && cursorPosition <= text.length();
            boolean cursorVisible = isFocused && this.cursorCounter / 6.0f % 2.0f == 0.0f && cursorInBox;
            int currentXPosition = this.getInitialXPosition();
            this.field_146211_a.getClass();
            int currentYPosition = this.field_230691_m_ + 9;
            if (enableBackgroundDrawing) {
                currentYPosition -= 6;
            }
            int initialYPosition = currentYPosition;
            int cursorX = currentXPosition;
            this.field_146223_s = Math.min(this.field_146223_s, text.length());
            int maxWidth = enableBackgroundDrawing ? this.field_230688_j_ - 8 : this.field_230688_j_;
            int lineOffset = this.getLineHeight();
            this.splitString = ScreenHelper.splitString(text, maxWidth);
            int[] cursorStringData = this.getSplitStringPosition(cursorPosition);
            int cursorLine = cursorStringData[0];
            int endSelectionLine = -1;
            int endSelectionX = 0;
            if (this.field_146223_s != cursorPosition) {
                int[] endSelectionData = this.getSplitStringPosition(this.field_146223_s);
                endSelectionLine = endSelectionData[0];
                endSelectionX = endSelectionData[1];
            }
            cursorX += cursorStringData[1];
            if (this.scrollToCursor) {
                if (endSelectionLine > -1 && endSelectionLine != cursorLine) {
                    this.scrollBar.scrollTo(endSelectionLine);
                } else {
                    this.scrollBar.scrollTo(cursorLine);
                }
                this.scrollToCursor = false;
            }
            int topIndex = this.scrollBar.getTopIndex();
            int bottomIndex = this.scrollBar.getBottomIndex();
            for (int i = topIndex; i <= bottomIndex; ++i) {
                this.field_146211_a.func_238405_a_(matrix, ScreenHelper.removeNewLine(this.splitString.get(i)), (float)currentXPosition, (float)currentYPosition, textColor);
                currentYPosition += lineOffset;
            }
            currentYPosition -= lineOffset;
            int cursorYPosition = initialYPosition + (cursorLine - topIndex) * lineOffset;
            boolean drawCursorBar = cursorPosition < text.length() || text.length() >= this.func_146208_g();
            int selectionStartX = cursorX;
            if (!cursorInBox) {
                int n = selectionStartX = cursorPosition > 0 ? currentXPosition + this.field_230688_j_ : currentXPosition;
            }
            if (cursorVisible && cursorLine >= topIndex && cursorLine <= bottomIndex) {
                if (drawCursorBar) {
                    this.field_146211_a.getClass();
                    AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(selectionStartX - 1), (int)(cursorYPosition - 1), (int)selectionStartX, (int)(cursorYPosition + 1 + 9), (int)-3092272);
                } else {
                    this.field_146211_a.func_238405_a_(matrix, "_", (float)selectionStartX, (float)currentYPosition, textColor);
                }
            }
            if (this.field_146223_s != cursorPosition) {
                if (endSelectionLine > cursorLine) {
                    cursorLine = Math.max(cursorLine, topIndex);
                    endSelectionLine = Math.min(endSelectionLine, bottomIndex + 1);
                    for (int i = cursorLine; i <= endSelectionLine; ++i) {
                        int left = i == cursorLine ? selectionStartX : currentXPosition;
                        int right = currentXPosition + (i == endSelectionLine ? endSelectionX : this.field_146211_a.func_78256_a(ScreenHelper.removeNewLine(this.splitString.get(i))));
                        currentYPosition = initialYPosition + (i - topIndex) * lineOffset;
                        this.field_146211_a.getClass();
                        this.drawCursorVertical(right, currentYPosition - 1, left, currentYPosition + 1 + 9);
                    }
                } else {
                    endSelectionLine = Math.max(endSelectionLine, topIndex);
                    cursorLine = Math.min(cursorLine, bottomIndex + 1);
                    for (int i = endSelectionLine; i <= cursorLine; ++i) {
                        int left = currentXPosition;
                        if (i == endSelectionLine) {
                            left += endSelectionX;
                        }
                        int right = i == cursorLine ? selectionStartX : currentXPosition + this.field_146211_a.func_78256_a(ScreenHelper.removeNewLine(this.splitString.get(i)));
                        currentYPosition = initialYPosition + (i - topIndex) * lineOffset;
                        this.field_146211_a.getClass();
                        this.drawCursorVertical(right, currentYPosition - 1, left, currentYPosition + 1 + 9);
                    }
                }
            }
            this.scrollBar.func_230430_a_(matrix, this.mouseX, this.mouseY, partialTicks);
        }
    }

    private int[] getSplitStringPosition(int position) {
        int currentPosition = 0;
        int numLines = this.splitString.size();
        int positionLine = numLines - 1;
        int positionOffset = -1;
        for (int i = 0; i < numLines; ++i) {
            int newPosition = currentPosition + this.splitString.get(i).length();
            if (newPosition > position) {
                positionLine = i;
                positionOffset = position - currentPosition;
                break;
            }
            currentPosition = newPosition;
        }
        if (positionLine == -1) {
            return new int[]{0, 0};
        }
        if (positionOffset == -1) {
            positionOffset = this.splitString.get(positionLine).length();
        }
        int lineWidth = this.field_146211_a.func_78256_a(ScreenHelper.removeNewLine(this.splitString.get(positionLine).substring(0, positionOffset)));
        return new int[]{positionLine, lineWidth};
    }

    private int[] getSplitStringPositionOffset(int position) {
        int currentPosition = 0;
        int numLines = this.splitString.size();
        int positionLine = numLines - 1;
        int positionOffset = -1;
        for (int i = 0; i < numLines; ++i) {
            int newPosition = currentPosition + this.splitString.get(i).length();
            if (newPosition > position) {
                positionLine = i;
                positionOffset = position - currentPosition;
                break;
            }
            currentPosition = newPosition;
        }
        if (positionOffset == -1) {
            positionOffset = this.splitString.get(positionLine).length();
        }
        return new int[]{positionLine, positionOffset};
    }

    private void drawCursorVertical(int right, int top, int left, int bottom) {
        if (right < left) {
            int i = right;
            right = left;
            left = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        if (left != right) {
            --left;
        }
        if (left > this.field_230690_l_ + this.field_230688_j_) {
            left = this.field_230690_l_ + this.field_230688_j_;
        }
        if (right > this.field_230690_l_ + this.field_230688_j_) {
            right = this.field_230690_l_ + this.field_230688_j_;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(0.0f, 0.0f, 255.0f, 255.0f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(0.0f, 0.0f, 255.0f, 255.0f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(0.0f, 0.0f, 255.0f, 255.0f).func_181675_d();
        vertexBuffer.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(0.0f, 0.0f, 255.0f, 255.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void func_146193_g(int newColor) {
        super.func_146193_g(newColor);
        this.enabledColor = newColor;
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        return this.scrollBar.func_231043_a_(p_231043_1_, p_231043_3_, p_231043_5_);
    }

    public List<String> getSplitString() {
        return this.splitString;
    }
}

