/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.obj.OBJLoader;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;

public class PixelmonRendering {
    public static final int FULLBRIGHT = 0xF000F0;
    public static final ResourceLocation EMPTY_TEX = ResourceLocationHelper.of("pixelmon:textures/entity/pixel.png");
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> STANDARD_ITEM_TRANSFORMATIONS = new ImmutableMap.Builder().put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.125f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.8125f, 0.4375f), new Quaternion(0.0f, 180.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.1875f, 0.0625f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.55f, 0.55f, 0.55f), null)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new TransformationMatrix(new Vector3f(0.070625f, 0.2f, 0.070625f), new Quaternion(0.0f, -90.0f, 25.0f, true), new Vector3f(0.68f, 0.68f, 0.68f), null)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.0f, 0.1875f, 0.0625f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.55f, 0.55f, 0.55f), null)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TransformationMatrix(new Vector3f(0.070625f, 0.2f, 0.070625f), new Quaternion(0.0f, -90.0f, 25.0f, true), new Vector3f(0.68f, 0.68f, 0.68f), null)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)new TransformationMatrix(null, new Quaternion(0.0f, 180.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null)).build();
    public static final RenderType QUADS = RenderType.func_228632_a_((String)"quads", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderType.field_228515_g_).func_228721_a_(RenderType.field_239237_T_).func_228727_a_(RenderType.field_228496_F_).func_228715_a_(RenderState.DepthTestState.field_228492_B_).func_228728_a_(false));
    public static RenderState.TransparencyState GLOW_TRANSPARENCY = new RenderState.TransparencyState("glow_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public static RenderType outline(RenderState.CullState p_239265_1_) {
        return RenderType.func_228632_a_((String)"outline", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228714_a_(p_239265_1_).func_228715_a_(RenderType.field_228492_B_).func_228713_a_(RenderType.field_228517_i_).func_228717_a_(RenderType.field_228501_K_).func_228721_a_(RenderType.field_228505_O_).func_228728_a_(false));
    }

    public static RenderType getTriangleRenderType() {
        return PixelmonRendering.getTriangleRenderType(RenderState.ShadeModelState.field_228520_l_, RenderType.field_228515_g_, RenderType.field_228532_x_, RenderType.field_228517_i_, RenderType.field_228491_A_, RenderType.field_228529_u_, RenderType.field_228530_v_);
    }

    public static RenderType getBellRenderType() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228529_u_).func_228722_a_(RenderType.field_228531_w_).func_228727_a_(RenderType.field_228496_F_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"bell_type", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)6, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getParticleTypes() {
        return RenderType.func_228632_a_((String)"pixel_particles", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderType.field_228523_o_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228728_a_(false));
    }

    public static RenderType getArcaneryTypes(ResourceLocation texture) {
        return RenderType.func_228632_a_((String)"pixel_arcanery_particles", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228721_a_(RenderState.field_239237_T_).func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228713_a_(RenderState.AlphaState.field_228517_i_).func_228726_a_(RenderState.field_228515_g_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228714_a_(RenderType.field_228534_z_).func_228719_a_(RenderType.field_228528_t_).func_228728_a_(false));
    }

    public static RenderType getParticleTypeQuads() {
        return RenderType.func_228632_a_((String)"pixel_particles_quads", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderType.field_228523_o_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228728_a_(false));
    }

    public static RenderType getTriangleRenderType(RenderState.ShadeModelState shading, RenderState.TransparencyState transparency, RenderState.DiffuseLightingState lighting, RenderState.AlphaState alpha, RenderState.CullState culling, RenderState.LightmapState lightmap, RenderState.OverlayState overlay) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(shading).func_228726_a_(transparency).func_228716_a_(lighting).func_228713_a_(alpha).func_228714_a_(culling).func_228719_a_(lightmap).func_228722_a_(overlay).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"raw_triangles", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getQuadTextureUVRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228518_j_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228531_w_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"color_tex_uv_quads", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getQuadTextureRenderType() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228518_j_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228529_u_).func_228722_a_(RenderType.field_228531_w_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"color_tex_quads", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getQuadRenderType() {
        return PixelmonRendering.getQuadRenderType(new RenderState.TextureState(EMPTY_TEX, false, false), RenderState.ShadeModelState.field_228520_l_, RenderType.field_228515_g_, RenderType.field_228532_x_, RenderType.field_228517_i_, RenderType.field_228491_A_, RenderType.field_228529_u_, RenderType.field_228530_v_);
    }

    public static RenderType getTextureQuadRenderType(RenderState.ShadeModelState shading, RenderState.TransparencyState transparency, RenderState.DiffuseLightingState lighting, RenderState.AlphaState alpha, RenderState.CullState culling, RenderState.LightmapState lightmap, RenderState.OverlayState overlay) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(shading).func_228726_a_(transparency).func_228716_a_(lighting).func_228713_a_(alpha).func_228714_a_(culling).func_228719_a_(lightmap).func_228722_a_(overlay).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"tex_quads", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getQuadRenderType(RenderState.TextureState textureState, RenderState.ShadeModelState shading, RenderState.TransparencyState transparency, RenderState.DiffuseLightingState lighting, RenderState.AlphaState alpha, RenderState.CullState culling, RenderState.LightmapState lightmap, RenderState.OverlayState overlay) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(shading).func_228724_a_(textureState).func_228726_a_(transparency).func_228716_a_(lighting).func_228713_a_(alpha).func_228714_a_(culling).func_228719_a_(lightmap).func_228722_a_(overlay).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"raw_quads", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDCulledRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228534_z_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_smd_culled", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDCulledEmissiveRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228534_z_).func_228719_a_(RenderType.field_228529_u_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_smd_emissive2", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"entity_smd23", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getWireFrameSMDRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228725_a_(new RenderState.TexturingState("wire_frame", () -> RenderSystem.polygonMode((int)1032, (int)6913), () -> RenderSystem.polygonMode((int)1032, (int)6914))).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"entity_smd_wireframe", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getVertexSMDRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228725_a_(new RenderState.TexturingState("vertex", () -> RenderSystem.polygonMode((int)1032, (int)6912), () -> RenderSystem.polygonMode((int)1032, (int)6914))).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"entity_smd_vertex", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDTransparentRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(GLOW_TRANSPARENCY).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228529_u_).func_228722_a_(RenderType.field_228531_w_).func_228717_a_(RenderType.field_228501_K_).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"entity_smd_transparent1231", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDRenderTypeTransparent(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228531_w_).func_228727_a_(RenderType.field_228496_F_).func_228717_a_(RenderType.field_228501_K_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"transparent_smd_type", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSMDRenderTypeUndelegated(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"smd", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getOBJType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228519_k_).func_228724_a_(new RenderState.TextureState(texture, true, true)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228533_y_).func_228713_a_(RenderType.field_228516_h_).func_228714_a_(RenderType.field_228534_z_).func_228719_a_(RenderType.field_228529_u_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"new_obj", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getOBJRenderType(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_obj", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getOBJRenderTypeUndelegated(ResourceLocation texture) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228723_a_(RenderState.ShadeModelState.field_228520_l_).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228716_a_(RenderType.field_228532_x_).func_228713_a_(RenderType.field_228517_i_).func_228714_a_(RenderType.field_228491_A_).func_228719_a_(RenderType.field_228528_t_).func_228722_a_(RenderType.field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"obj", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    }

    public static <T extends Entity> void renderEntity(MatrixStack matrix, T entity, boolean fullbright, float partialTicks) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityClassRenderObject = renderManager.func_78713_a(entity);
        IRenderTypeBuffer.Impl impl = ScreenHelper.getBufferImpl();
        entityClassRenderObject.func_225623_a_(entity, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)impl, fullbright ? 0xF000F0 : renderManager.func_229085_a_(entity, partialTicks));
        impl.func_228461_a_();
    }

    public static <T extends Entity> void renderEntity(MatrixStack matrix, T entity, int packedLight, boolean fullbright, float partialTicks) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityClassRenderObject = renderManager.func_78713_a(entity);
        IRenderTypeBuffer.Impl impl = ScreenHelper.getBufferImpl();
        entityClassRenderObject.func_225623_a_(entity, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)impl, fullbright ? 0xF000F0 : packedLight);
        impl.func_228461_a_();
    }

    public static Optional<Model> getPixelmonModel(String path) {
        return PixelmonRendering.getModel("pixelmon", path);
    }

    public static Optional<Model> getModel(String path) {
        return PixelmonRendering.getModel(ResourceLocationHelper.of(path));
    }

    public static Optional<Model> getModel(String mod, String path) {
        return PixelmonRendering.getModel(ResourceLocationHelper.of(mod, path));
    }

    public static Optional<Model> getModel(ResourceLocation resource) {
        if (ValveStudioModelLoader.INSTANCE.accepts(resource)) {
            return Optional.ofNullable(ValveStudioModelLoader.INSTANCE.loadModel(resource));
        }
        if (OBJLoader.accepts(resource)) {
            return Optional.ofNullable(OBJLoader.loadModel(resource));
        }
        return Optional.empty();
    }

    public static void renderBlockModel(MatrixStack.Entry mat, IVertexBuilder builder, @Nullable BlockState state, IBakedModel model, float f, float g, float b, int light, int overlay, IModelData modelData) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            PixelmonRendering.renderQuadList(mat, builder, f, g, b, model.getQuads(state, direction, random, modelData), light, overlay);
        }
        random.setSeed(42L);
        PixelmonRendering.renderQuadList(mat, builder, f, g, b, model.getQuads(state, (Direction)null, random, modelData), light, overlay);
    }

    public static void renderQuadList(MatrixStack.Entry mat, IVertexBuilder builder, float r, float g, float b, List<BakedQuad> quads, int light, int overlay) {
        for (BakedQuad bakedquad : quads) {
            builder.func_227889_a_(mat, bakedquad, MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f), light, overlay);
        }
    }
}

