/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.DualModelDualTextureFactory;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.AbstractPokemonRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.DynamaxRenderer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class PokemonShimLayer<E extends AbstractClientEntity>
extends LayerRenderer<E, PixelmonModelBase<E>> {
    private static final ResourceLocation EMPTY_TEX = ResourceLocationHelper.of("pixelmon:textures/entity/pixel.png");
    private static final ResourceLocation DYNAMAX_CLOUDS_TEX = ResourceLocationHelper.of("pixelmon:textures/fluff/clouds.png");
    private static final ResourceLocation MATTE_WHITE_TEX = ResourceLocationHelper.of("pixelmon:textures/fluff/mattewhite.png");
    private final Model DYNAMAX_CLOUDS = CustomModel.DYNAMAX_CLOUDS.getModel();
    private static final float[] DYNAMAX_RED = new float[]{1.0f, 0.0f, 0.0f, 0.15f};
    private static final float[] DYNAMAX_BLUE = new float[]{0.0f, 0.1f, 1.0f, 0.35f};
    private ResourceLocation texture;
    private PixelmonModelBase<E> model;
    private final AbstractPokemonRenderer<E> renderer;

    public PokemonShimLayer(AbstractPokemonRenderer<E> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void setModel(PixelmonModelBase<E> model) {
        this.model = model;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, E pixelmon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (pixelmon instanceof PixelmonEntity && ((PixelmonEntity)pixelmon).stopRender) {
            return;
        }
        if (pixelmon.func_82150_aj()) {
            return;
        }
        matrix.func_227860_a_();
        if (this.model instanceof PixelmonModelSmd) {
            ((PixelmonModelSmd)this.model).partialTick = partialTicks;
        }
        if (((AbstractClientEntity)pixelmon).getModel() != null) {
            this.renderPixelmon(pixelmon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks, matrix, buffer, packedLight, false);
        }
        matrix.func_227865_b_();
    }

    public PixelmonModelBase<E> getParentModel() {
        return (PixelmonModelBase)this.renderer.func_217764_d();
    }

    public void renderPixelmon(E pixelmon, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, boolean fromPokedex) {
        this.renderPixelmon(pixelmon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks, matrix, buffer, packedLight, fromPokedex, 1);
    }

    public void renderPixelmon(E pixelmon, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, boolean fromPokedex, int pass) {
        float[] color;
        if (!fromPokedex && pixelmon.func_82150_aj()) {
            return;
        }
        int packedOverlay = LivingRenderer.func_229117_c_(pixelmon, (float)0.0f);
        IVertexBuilder vertices = null;
        if (!((AbstractBaseEntity)((Object)pixelmon)).isOverlay()) {
            if (((AbstractBaseEntity)((Object)pixelmon)).isDisableTexture()) {
                vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(EMPTY_TEX));
            }
            if (((AbstractBaseEntity)((Object)pixelmon)).isFullbright()) {
                packedLight = 0xF000F0;
            }
        }
        if (vertices == null) {
            vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.renderer.getTextureLocation(pixelmon)));
        }
        if (PixelmonConfigProxy.getGraphics().isGlobalVertexToggle()) {
            vertices = buffer.getBuffer(PixelmonRendering.getVertexSMDRenderType(this.renderer.getTextureLocation(pixelmon)));
        }
        if (((AbstractClientEntity)pixelmon).isWireFrame() || PixelmonConfigProxy.getGraphics().isGlobalWireFrame()) {
            vertices = buffer.getBuffer(PixelmonRendering.getWireFrameSMDRenderType(this.renderer.getTextureLocation(pixelmon)));
        }
        if (PixelmonConfigProxy.getGraphics().isGlobalEmissiveToggle()) {
            packedLight = 0xF000F0;
        }
        boolean dynamax = ((AbstractClientEntity)pixelmon).getDynamaxScale() > 0.0f;
        matrix.func_227860_a_();
        this.model = (PixelmonModelBase)((AbstractClientEntity)pixelmon).getModel();
        this.model.field_217112_c = pixelmon.func_70678_g(partialTicks);
        this.model.field_217114_e = pixelmon.func_70631_g_();
        this.model.setBuffer(buffer);
        if (this.model instanceof PixelmonModelSmd) {
            PixelmonModelSmd smd = (PixelmonModelSmd)this.model;
            if (smd.theModel != null) {
                if (((AbstractClientEntity)pixelmon).isAnimated()) {
                    smd.setupForRender((AbstractClientEntity)pixelmon);
                } else {
                    smd.theModel.resetVerts(smd.theModel.body);
                }
            } else {
                Pixelmon.LOGGER.error("MISSING MODEL: " + ((AbstractBaseEntity)((Object)pixelmon)).getSpecies() + " " + ((AbstractClientEntity)pixelmon).getPokemon().getForm());
            }
        }
        this.model.setScale(0.0625f);
        ((AbstractClientEntity)pixelmon).field_70170_p.func_217381_Z().func_76320_a(pixelmon instanceof StatueEntity ? "statue_render" : "pixelmon_render");
        if (((AbstractBaseEntity)((Object)pixelmon)).getBossTier().isBoss()) {
            color = ((AbstractBaseEntity)((Object)pixelmon)).getBossTier().getColor().getColorComponents(null);
            this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
        } else if (((AbstractClientEntity)pixelmon).isEvolving()) {
            color = ((AbstractClientEntity)pixelmon).getRenderColor();
            if (((AbstractBaseEntity)((Object)pixelmon)).isOverlay()) {
                this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
                if (((AbstractBaseEntity)((Object)pixelmon)).isDisableTexture()) {
                    vertices = buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(EMPTY_TEX));
                }
                if (((AbstractBaseEntity)((Object)pixelmon)).isFullbright()) {
                    packedLight = 0xF000F0;
                }
            }
            if (((AbstractBaseEntity)((Object)pixelmon)).getColor() != null) {
                color = ((AbstractBaseEntity)((Object)pixelmon)).getColor().getRGBComponents(null);
            }
            this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
            this.model.render((Entity)pixelmon, matrix, buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(EMPTY_TEX)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, (float)((AbstractClientEntity)pixelmon).fadeCount / 20.0f);
        } else if (dynamax) {
            this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder dynamaxVertices = buffer.getBuffer(PixelmonRendering.getSMDTransparentRenderType(EMPTY_TEX));
            if (this.model instanceof DualModelDualTextureFactory.TransparentImpl) {
                DualModelDualTextureFactory.TransparentImpl impl = (DualModelDualTextureFactory.TransparentImpl)this.model;
                impl.overloadTexture();
            }
            float[] color2 = ((AbstractBaseEntity)((Object)pixelmon)).getSpecies().is(PixelmonSpecies.CALYREX) ? DYNAMAX_BLUE : DYNAMAX_RED;
            matrix.func_227860_a_();
            matrix.func_227862_a_(1.05f, 1.0f, 1.05f);
            if (this.model instanceof PixelmonModelSmd) {
                ((PixelmonModelSmd)this.model).getTheModel().animate();
            }
            this.model.render((Entity)pixelmon, matrix, dynamaxVertices, packedLight, packedOverlay, color2[0], color2[1], color2[2], color2[3]);
            matrix.func_227865_b_();
        } else {
            color = ((AbstractClientEntity)pixelmon).getRenderColor();
            if (pixelmon instanceof StatueEntity) {
                StatueEntity statue = (StatueEntity)pixelmon;
                if (statue.getBossTier().isBoss()) {
                    color = statue.getBossTier().getColor().getColorComponents(null);
                } else if (statue.getColor() != Color.WHITE && statue.getColor() != null) {
                    color = new float[]{(float)statue.getColor().getRed() / 255.0f, (float)statue.getColor().getGreen() / 255.0f, (float)statue.getColor().getBlue() / 255.0f, 1.0f};
                }
            }
            if (((AbstractBaseEntity)((Object)pixelmon)).isOverlay()) {
                this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
                if (((AbstractBaseEntity)((Object)pixelmon)).isDisableTexture()) {
                    vertices = buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(EMPTY_TEX));
                }
                if (((AbstractBaseEntity)((Object)pixelmon)).isFullbright()) {
                    packedLight = 0xF000F0;
                }
            }
            if (((AbstractBaseEntity)((Object)pixelmon)).getColor() != null) {
                color = ((AbstractBaseEntity)((Object)pixelmon)).getColor().getRGBComponents(null);
            }
            this.model.render((Entity)pixelmon, matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
        }
        ((AbstractClientEntity)pixelmon).field_70170_p.func_217381_Z().func_76319_b();
        float distance = Minecraft.func_71410_x().field_175622_Z != null ? pixelmon.func_70032_d(Minecraft.func_71410_x().field_175622_Z) : 20.0f;
        if (PixelmonConfigProxy.getGraphics().isEmissiveTextures() && ((AbstractBaseEntity)((Object)pixelmon)).getPalette().hasEmissiveTexture() && distance < (float)PixelmonConfigProxy.getGraphics().getEmissiveTexturesDistance()) {
            this.model.render((Entity)pixelmon, matrix, buffer.getBuffer(PixelmonRendering.getSMDTransparentRenderType(((AbstractBaseEntity)((Object)pixelmon)).getPalette().getEmissiveTexture())), 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.func_227865_b_();
        if (dynamax) {
            DynamaxRenderer.dynamaxRender(pixelmon, matrix, buffer, DYNAMAX_CLOUDS_TEX, this.DYNAMAX_CLOUDS, partialTicks, packedLight, packedOverlay);
        }
        this.renderEvolutionLightBeams(pixelmon, matrix, buffer);
    }

    private void renderEvolutionLightBeams(E pixelmon, MatrixStack matrix, IRenderTypeBuffer buffer) {
        if (((AbstractClientEntity)pixelmon).getEvoStage() == EvolutionStage.PreAnimation || ((AbstractClientEntity)pixelmon).getEvoStage() == EvolutionStage.PostAnimation) {
            Matrix4f pose;
            IVertexBuilder builder = buffer.getBuffer(PixelmonRendering.getQuadRenderType(new RenderState.TextureState(EMPTY_TEX, false, false), RenderState.ShadeModelState.field_228520_l_, RenderState.field_228510_b_, RenderType.field_228533_y_, RenderType.field_228517_i_, RenderType.field_228491_A_, RenderType.field_228529_u_, RenderType.field_228530_v_));
            float ticks = ((AbstractClientEntity)pixelmon).evoAnimTicks;
            if (((AbstractClientEntity)pixelmon).getEvoStage() == EvolutionStage.PostAnimation) {
                ticks += (float)EvolutionStage.PreAnimation.ticks;
            }
            Dimensions dimensions = ((AbstractClientEntity)pixelmon).getPokemon().getForm().getDimensions();
            float width = (float)dimensions.getWidth();
            float height = (float)dimensions.getHeight();
            float scale = ticks / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            float hScale = (float)((double)(scale * ((AbstractClientEntity)pixelmon).heightDiff) / dimensions.getHeight());
            matrix.func_227860_a_();
            if (((AbstractClientEntity)pixelmon).getEvoStage() == EvolutionStage.PreAnimation) {
                matrix.func_227861_a_(0.0, (double)(-1.0f * (height * (1.0f + hScale)) / 2.0f), 0.0);
            } else {
                matrix.func_227861_a_(0.0, (double)(-1.0f * (height * (1.0f - hScale)) / 2.0f), 0.0);
            }
            float length = scale * 18.0f + 2.0f;
            if (ticks > 20.0f && ((AbstractClientEntity)pixelmon).fadeCount > 18) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(15.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            if (ticks > 40.0f && ((AbstractClientEntity)pixelmon).fadeCount > 15) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f + 180.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(15.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            if (ticks > 60.0f && ((AbstractClientEntity)pixelmon).fadeCount > 12) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f + 270.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(40.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            if (ticks > 80.0f && ((AbstractClientEntity)pixelmon).fadeCount > 9) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f + 90.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(40.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            if (ticks > 100.0f && ((AbstractClientEntity)pixelmon).fadeCount > 6) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f + 135.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(65.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            if (ticks > 120.0f && ((AbstractClientEntity)pixelmon).fadeCount > 3) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(QuaternionHelper.fromEuler(ticks * 3.0f + 315.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(65.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.func_227866_c_().func_227870_a_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
        }
    }

    private void drawBeam(Matrix4f matrix, float width, float length, IVertexBuilder builder) {
        float alpha = 0.6f;
        builder.func_227888_a_(matrix, -width, 1.0f * length, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, width, 1.0f * length, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, width * 3.0f, -length, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, -width * 3.0f, -length, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 1.0f * length, -width).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 1.0f * length, width).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, -length, width * 3.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, -length, -width * 3.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
    }
}

