/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.client.render.player.LayerWrapper;
import com.pixelmonmod.pixelmon.client.render.player.ModelBikeArmor;
import com.pixelmonmod.pixelmon.client.render.player.ModelPlayerOnBike;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UIKeyPressPacket;
import com.pixelmonmod.pixelmon.entities.bikes.BikeEntity;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.UIElementItem;
import java.awt.Color;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    private PlayerModel<AbstractClientPlayerEntity> oldModel = null;
    private BipedModel<?> oldModelArmor = null;
    private BipedModel<?> oldModelLeggings = null;
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        if (event.getStack().func_77973_b() instanceof UIElementItem && event.getStack().func_200301_q().getString().isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyPress(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen container = (ContainerScreen)event.getGui();
            for (Slot slot : container.func_212873_a_().field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !((stack = slot.func_75211_c()).func_77973_b() instanceof UIElementItem)) continue;
                int keyCode = event.getKeyCode();
                int scanCode = event.getScanCode();
                int modifiers = event.getModifiers();
                NetworkHelper.sendToServer(new UIKeyPressPacket(keyCode, scanCode, modifiers));
                if (Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c() != event.getKeyCode()) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onRenderContainer(GuiContainerEvent.DrawForeground event) {
        for (Slot slot : event.getGuiContainer().func_212873_a_().field_75151_b) {
            ItemStack stack;
            if (!slot.func_75216_d() || !((stack = slot.func_75211_c()).func_77973_b() instanceof UIElementItem)) continue;
            MatrixStack matrix = event.getMatrixStack();
            boolean hover = event.getGuiContainer().getSlotUnderMouse() == slot;
            int x = UIElementItem.getXOverride(stack).orElse(slot.field_75223_e - 1) + UIElementItem.getXOffset(stack).orElse(0);
            int y = UIElementItem.getYOverride(stack).orElse(slot.field_75221_f - 1) + UIElementItem.getYOffset(stack).orElse(0);
            int z = UIElementItem.getZLevel(stack).orElse(0);
            float[] rgba = UIElementItem.getColor(stack, hover).orElse(WHITE);
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)x, (double)y, (double)z);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(UIElementItem.getRotation(stack), 0.0f, 0.0f, 1.0f));
            float[] scale = UIElementItem.getScale(stack);
            matrix.func_227862_a_(scale[0], scale[1], 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            UIElementItem.getImage(stack, hover).ifPresent(rl -> {
                int w = UIElementItem.getImageWidth(stack).orElse(16);
                int h = UIElementItem.getImageHeight(stack).orElse(16);
                float u = UIElementItem.getImageU(stack).orElse(Float.valueOf(0.0f)).floatValue();
                float v = UIElementItem.getImageV(stack).orElse(Float.valueOf(0.0f)).floatValue();
                ScreenHelper.drawImageQuadUV(rl, matrix, 1.0f, 1.0f, w, h, u, v, w, h, rgba[0], rgba[1], rgba[2], rgba[3], z);
            });
            UIElementItem.getText(stack, hover).ifPresent(text -> {
                TextJustification j = UIElementItem.getTextJustification(stack);
                float s = UIElementItem.getTextScale(stack);
                switch (j) {
                    case RIGHT: {
                        ScreenHelper.drawScaledString(matrix, text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case CENTER: {
                        ScreenHelper.drawScaledCenteredString(matrix, text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case LEFT: {
                        ScreenHelper.drawScaledStringRightAligned(matrix, text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), false, s);
                    }
                }
            });
            matrix.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        if (event.getRenderer() instanceof PixelRenderPlayer) {
            LayerRenderer layer;
            ListIterator<LayerWrapper> i;
            PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
            if (LayerEquippables.hasEquippables(player)) {
                i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    layer = (LayerRenderer)i.next();
                    if (!(layer instanceof HeadLayer)) continue;
                    i.remove();
                }
            }
            if (player.func_184187_bx() instanceof BikeEntity) {
                this.oldModel = (PlayerModel)renderPlayer.func_217764_d();
                renderPlayer.setModel(new ModelPlayerOnBike(0.0f, renderPlayer.isAlex));
                i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    layer = (LayerRenderer)i.next();
                    if (layer instanceof BipedArmorLayer) {
                        BipedArmorLayer layerArmor = (BipedArmorLayer)layer;
                        this.oldModelArmor = layerArmor.field_177186_d;
                        this.oldModelLeggings = layerArmor.field_177189_c;
                        layerArmor.field_177186_d = new ModelBikeArmor(1.0f);
                        layerArmor.field_177189_c = new ModelBikeArmor(0.5f);
                        continue;
                    }
                    if (layer instanceof ElytraLayer) {
                        i.set(new LayerWrapper((LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)layer).setTranslates(0.0, 0.03, -0.25));
                        continue;
                    }
                    if (layer instanceof HeadLayer) {
                        i.set(new LayerWrapper((LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)new HeadLayer((IEntityRenderer)renderPlayer)).setTranslates(0.0, 0.05, -0.2f));
                        continue;
                    }
                    if (!(layer instanceof ArrowLayer) && !(layer instanceof HeldItemLayer)) continue;
                    i.set(new LayerWrapper((LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)layer).setEnabled(false));
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        boolean hasCustomHead = false;
        ListIterator i2 = event.getRenderer().field_177097_h.listIterator();
        while (i2.hasNext()) {
            LayerRenderer layer = (LayerRenderer)i2.next();
            if (!(layer instanceof HeadLayer)) continue;
            hasCustomHead = true;
            break;
        }
        if (!hasCustomHead) {
            event.getRenderer().func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)event.getRenderer()));
        }
        if (this.oldModel != null) {
            if (event.getRenderer() instanceof PixelRenderPlayer) {
                PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
                renderPlayer.setModel(this.oldModel);
                ListIterator<Object> i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    LayerRenderer layer = (LayerRenderer)i.next();
                    if (this.oldModelArmor != null && layer instanceof BipedArmorLayer) {
                        BipedArmorLayer layerArmor = (BipedArmorLayer)layer;
                        layerArmor.field_177186_d = this.oldModelArmor;
                        layerArmor.field_177189_c = this.oldModelLeggings;
                        continue;
                    }
                    if (!(layer instanceof LayerWrapper)) continue;
                    if (((LayerWrapper)layer).layer instanceof HeadLayer) {
                        HeadLayer customHead = new HeadLayer((IEntityRenderer)renderPlayer);
                        i.set(customHead);
                        continue;
                    }
                    i.set(layer);
                }
                this.oldModelArmor = null;
                this.oldModelLeggings = null;
            }
            this.oldModel = null;
        }
    }
}

