/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientSetLastOpenBoxPacket
extends AbstractPixelmonPacket {
    private int lastBox = 0;

    public ClientSetLastOpenBoxPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientSetLastOpenBoxPacket(ServerPlayerEntity player, int lastBox) {
        super(PacketDirection.PLAY_CLIENT, true);
        PCStorage pc = StorageProxy.getPCForPlayer(player);
        if (lastBox < 0 || lastBox >= pc.getBoxes().length) {
            this.lastBox = 0;
            Pixelmon.LOGGER.error("ClientSetLastOpenBox out of bounds! Expected value between 0 and " + pc.getBoxes().length + ", got " + lastBox);
        } else {
            this.lastBox = lastBox;
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.lastBox = buf.readShort();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeShort(this.lastBox);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientStorageManager.openPC.setLastBox(this.lastBox);
    }
}

