/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DayCareAllErrorsPacket
extends AbstractPixelmonPacket {
    private int boxId;
    private List<ITextComponent> errors;

    public DayCareAllErrorsPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public DayCareAllErrorsPacket(int boxId, List<ITextComponent> errors) {
        this();
        this.boxId = boxId;
        this.errors = errors;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.boxId);
        buffer.writeInt(this.errors.size());
        for (ITextComponent error : this.errors) {
            buffer.func_179256_a(error);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.boxId = buffer.readInt();
        this.errors = Lists.newArrayList();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.errors.add(buffer.func_179258_d());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party = ClientStorageManager.party;
        if (party == null) {
            return;
        }
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        dayCareBox.setAllErrorMessages(this.errors);
    }
}

