/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUIPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AddTrainerPokemonPacket
extends AbstractPixelmonPacket {
    private int trainerID;

    public AddTrainerPokemonPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public AddTrainerPokemonPacket(int trainerId) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerID = trainerId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.trainerID);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.trainerID = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!NPCEditorItem.checkPermission((PlayerEntity)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.field_70170_p, this.trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer trainer = entityNPCOptional.get();
        TrainerPartyStorage storage = trainer.getPokemonStorage();
        if (storage.hasSpace()) {
            storage.add(PokemonFactory.create(PixelmonSpecies.BULBASAUR.getValueUnsafe()));
        }
        trainer.updateTrainerLevel();
        trainer.getPokemonStorage().sendCacheToPlayer(player);
        this.reply(context, new ChangePokemonOpenGUIPacket(storage.getTeam().size() - 1));
    }
}

