/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class InteractNPCPacket
extends AbstractPixelmonPacket {
    private int npcID;
    private EnumNPCType npcType;

    public InteractNPCPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public InteractNPCPacket(int npcID, EnumNPCType npcType) {
        super(PacketDirection.PLAY_CLIENT);
        this.npcID = npcID;
        this.npcType = npcType;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.npcID = buf.readInt();
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.npcID);
        buf.writeInt(this.npcType.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerStorageDisplay.npcInteractID = this.npcID;
        ClientProxy.battleManager.choosingPokemon = true;
        ClientProxy.battleManager.teamPokemon = null;
        if (this.npcType == EnumNPCType.Relearner) {
            ClientProxy.battleManager.setMode(BattleMode.CHOOSE_RELEARN_MOVE);
        } else if (this.npcType == EnumNPCType.Tutor) {
            ClientProxy.battleManager.setMode(BattleMode.CHOOSE_TUTOR);
        }
    }
}

