/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerPokedexPacket
extends AbstractPixelmonPacket {
    private boolean launch;
    private int entityID;

    public ServerPokedexPacket(boolean launch, int entityID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.launch = launch;
        this.entityID = entityID;
    }

    public ServerPokedexPacket(boolean launch) {
        this(launch, -1);
    }

    public ServerPokedexPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.launch);
        if (this.launch) {
            buf.writeInt(this.entityID);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.launch = buf.readBoolean();
        if (this.launch) {
            this.entityID = buf.readInt();
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        Entity entity;
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getParty(player);
        PlayerPokedex playerPokedex = party.playerPokedex;
        boolean hasChanged = false;
        int id = 1;
        if (this.launch && this.entityID >= 0 && (entity = player.field_70170_p.func_73045_a(this.entityID)) instanceof PixelmonEntity && entity.func_70032_d((Entity)player) < 20.0f) {
            Pokemon pokemon = ((PixelmonEntity)entity).getPokemon();
            PokedexEvent.Pre preEvent = new PokedexEvent.Pre(player.func_110124_au(), pokemon, PokedexRegistrationStatus.SEEN, "pokedexKey");
            if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
                hasChanged = playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                id = pokemon.getSpecies().getDex();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.func_110124_au(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        }
        if (hasChanged) {
            playerPokedex.update();
        }
        if (this.launch) {
            OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.Pokedex, id);
        }
    }
}

