/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetEditedPlayerPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private String playerName;
    private Pokemon[] pokemon;

    public SetEditedPlayerPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetEditedPlayerPacket(UUID playerID, Pokemon[] pokemon) {
        this(playerID, "", pokemon);
    }

    public SetEditedPlayerPacket(UUID playerID, String playerName, Pokemon[] pokemon) {
        super(PacketDirection.PLAY_CLIENT);
        this.playerID = playerID;
        this.playerName = playerName;
        this.pokemon = pokemon;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.playerID);
        buf.func_180714_a(this.playerName);
        for (Pokemon data : this.pokemon) {
            if (data == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            data.writeToByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerID = buf.func_179253_g();
        this.playerName = buf.func_218666_n();
        this.pokemon = new Pokemon[6];
        for (int i = 0; i < this.pokemon.length; ++i) {
            if (!buf.readBoolean()) continue;
            this.pokemon[i] = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PokemonEditorPartyScreen.editedPlayerUUID = this.playerID;
        if (!this.playerName.isEmpty()) {
            PokemonEditorPartyScreen.editedPlayerName = this.playerName;
        }
        ServerStorageDisplay.editedPokemon = Arrays.asList(this.pokemon);
        for (Pokemon pokemon1 : this.pokemon) {
            if (pokemon1 == null) continue;
            Ability ability = pokemon1.getAbility();
            boolean bl = false;
        }
    }
}

