/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetImportPokemonIDPacket;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class UpdateEditedPokemonPacket
extends AbstractPixelmonPacket {
    public Pokemon data;
    public int slot = -1;

    protected UpdateEditedPokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    protected UpdateEditedPokemonPacket(Pokemon data) {
        super(PacketDirection.PLAY_SERVER, true);
        this.data = data;
    }

    protected UpdateEditedPokemonPacket(Pokemon data, int slot) {
        super(PacketDirection.PLAY_SERVER, true);
        this.data = data;
        this.slot = slot;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        this.data.writeToByteBuffer(buffer, EnumUpdateType.ALL);
        buffer.writeInt(this.slot);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.data = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buffer, EnumUpdateType.ALL);
        this.slot = buffer.readInt();
    }

    public static void updatePokemon(UpdateEditedPokemonPacket message, ServerPlayerEntity player, PartyStorage storage) {
        int pos = message.slot;
        if (pos == -1) {
            pos = storage.find(message.data.getUUID()) != null ? storage.getPosition((Pokemon)message.data).order : -1;
        }
        message.data.heal();
        if (pos == -1 && storage.countAll() == 6) {
            return;
        }
        if (pos == -1) {
            storage.add(message.data);
            pos = storage.getPosition((Pokemon)message.data).order;
        } else {
            Pokemon current = storage.get(pos);
            if (current != null && current.getPersistentData() != null) {
                message.data.getPersistentData().func_197643_a(current.getPersistentData());
            }
            storage.set(pos, message.data);
        }
        Pixelmon.network.send(PacketDistributor.PLAYER.with(() -> player), new SetImportPokemonIDPacket(pos, message.data.getUUID()));
    }
}

