/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.BrigadierHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public abstract class PixelCommand {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private final String name;
    private final String usage;
    private final int permissionLevel;

    public PixelCommand(CommandDispatcher<CommandSource> dispatcher, String name, String usage, int permissionLevel) {
        this.name = name;
        this.usage = usage;
        this.permissionLevel = permissionLevel;
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(commandSource -> commandSource.func_197034_c(this.permissionLevel))).then(Commands.func_197056_a((String)"", (ArgumentType)StringArgumentType.greedyString()).suggests(this::buildSuggestions).executes(this::handleExecution))).executes(context -> {
            this.execute((CommandSource)context.getSource(), new String[0]);
            return 1;
        });
        LiteralCommandNode args = dispatcher.register(builder);
        for (String alias : this.getAliases()) {
            dispatcher.getRoot().addChild(BrigadierHelper.buildRedirect(alias, (LiteralCommandNode<CommandSource>)args));
        }
    }

    public PixelCommand(CommandDispatcher<CommandSource> dispatcher) {
        this(dispatcher, "", "", 0);
    }

    private CompletableFuture<Suggestions> buildSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        List<String> tabCompletions;
        String[] initialArgs = context.getInput().split(" ");
        ArrayList args = Lists.newArrayList((Object[])Arrays.copyOfRange(initialArgs, 1, initialArgs.length));
        int spaces = 0;
        Matcher matcher = SPACE_PATTERN.matcher(context.getInput());
        while (matcher.find()) {
            ++spaces;
        }
        while (spaces > args.size()) {
            args.add(" ");
            --spaces;
        }
        try {
            tabCompletions = this.getTabCompletions(ServerLifecycleHooks.getCurrentServer(), (CommandSource)context.getSource(), args.toArray(new String[0]), new BlockPos(((CommandSource)context.getSource()).func_197036_d()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return builder.buildFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            SuggestionsBuilder suggestionsBuilder = null;
            suggestionsBuilder = args.size() > 0 && !((String)args.get(args.size() - 1)).trim().isEmpty() ? builder.createOffset(context.getInput().length() - ((String)args.get(args.size() - 1)).length()) : builder.createOffset(context.getInput().length());
            String currentWord = ((String)args.get(args.size() - 1)).toLowerCase(Locale.ROOT);
            for (String tabCompletion : tabCompletions) {
                if (args.isEmpty()) {
                    suggestionsBuilder.suggest(tabCompletion);
                    continue;
                }
                if (currentWord.isEmpty() || currentWord.equals(" ")) {
                    suggestionsBuilder.suggest(tabCompletion);
                    continue;
                }
                if (!tabCompletion.regionMatches(true, 0, currentWord, 0, currentWord.length())) continue;
                suggestionsBuilder.suggest(tabCompletion);
            }
            return suggestionsBuilder;
        }).thenCompose(SuggestionsBuilder::buildFuture);
    }

    private int handleExecution(CommandContext<CommandSource> context) {
        try {
            this.execute((CommandSource)context.getSource(), ((String)context.getArgument("", String.class)).split(" "));
            return 1;
        }
        catch (IllegalArgumentException e) {
            try {
                this.execute((CommandSource)context.getSource(), new String[0]);
                return 1;
            }
            catch (CommandException e2) {
                ((CommandSource)context.getSource()).func_197030_a(e2.func_197003_a(), false);
                return 0;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return 0;
            }
        }
        catch (CommandException e) {
            ((CommandSource)context.getSource()).func_197030_a(e.func_197003_a(), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUsage(CommandSource sender) {
        if (this.hasPermissionOtherTarget(sender)) {
            return this.usage;
        }
        return this.usage.replace("[player] ", "");
    }

    public int getRequiredPermissionLevel() {
        return this.permissionLevel;
    }

    public List<String> getAliases() {
        return Collections.emptyList();
    }

    public abstract void execute(CommandSource var1, String[] var2) throws CommandException, CommandSyntaxException;

    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return Collections.emptyList();
    }

    public String[] setupTargetOrSourceAsTarget(CommandSource sender, String[] args, int playerIndex) throws CommandException {
        if (args.length > playerIndex) {
            boolean isTargetOther;
            boolean isTargetMissingInArguments;
            String selector = args[playerIndex];
            ServerPlayerEntity target = PixelmonCommandUtils.getEntityPlayer(selector);
            boolean bl = isTargetMissingInArguments = target == null;
            if (isTargetMissingInArguments) {
                boolean isTargetOffline;
                GameProfile profile = PixelmonCommandUtils.findProfile(selector);
                boolean bl2 = isTargetOffline = profile != null && !profile.getName().equalsIgnoreCase(sender.func_197037_c());
                if (isTargetOffline) {
                    throw PixelmonCommandUtils.getException("pixelmon.command.other.offline", profile.getName());
                }
                throw PixelmonCommandUtils.getException("pixelmon.command.battlelog.player.not.found", new Object[0]);
            }
            boolean bl3 = isTargetOther = target != sender.func_197022_f();
            if (isTargetOther && !this.hasPermissionOtherTarget(sender)) {
                throw PixelmonCommandUtils.getException("pixelmon.command.other.nopermission", new Object[0]);
            }
            return args;
        }
        return this.addSourceToArgumentsAndGet(sender, args, playerIndex);
    }

    private String[] addSourceToArgumentsAndGet(CommandSource sender, String[] args, int playerIndex) {
        return ArrayHelper.addStringAtIndex(args, playerIndex, sender.func_197037_c());
    }

    public boolean hasPermissionOtherTarget(CommandSource sender) {
        return PixelmonCommandUtils.hasPermission(sender, "pixelmon.command." + this.name + ".other");
    }
}

