/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class MegaRingCommand
extends PixelCommand {
    public MegaRingCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "megaring", "/megaring [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
        PlayerPartyStorage party = StorageProxy.getParty(player);
        if (!party.getMegaItemsUnlocked().canMega()) {
            party.setMegaItem(EnumMegaItem.BraceletORAS, false);
            party.unlockMega(false);
            if (sender.func_197022_f() != player) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.megaring.success", player.func_200200_C_());
            }
            PixelmonCommandUtils.sendMessage(player, "pixelmon.command.megaring.received", new Object[0]);
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.megaring.notify", sender.func_197037_c(), player.func_200200_C_());
        } else {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.megaring.alreadyhas", player.func_200200_C_());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

