/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategyLoader;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class WikiCommand
extends PixelCommand {
    public WikiCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "wiki", "/wiki <slot | specs...>", 0);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        Pokemon pokemon;
        if (args.length == 0) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.usage.one", new Object[0]).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.usage.two", new Object[0]).func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("pixelmon.command.wiki.banner.hover"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://pixelmonmod.com/wiki/"))).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.usage.three", new Object[0])).func_240702_b_("\n").func_240702_b_(this.getUsage(sender))), true);
            return;
        }
        if (PixelmonCommandUtils.PARTY_SLOTS.contains(args[0])) {
            ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
            PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
            int slot = PixelmonCommandUtils.requireInt(args[0], 1, 6, "pixelmon.command.pokeedit.slot", new Object[0]);
            pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.func_200200_C_());
        } else {
            pokemon = PokemonSpecificationProxy.create(args).create();
            if (pokemon.getSpecies().is(PixelmonSpecies.MISSINGNO)) {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
                PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            }
        }
        sender.func_197030_a(StringTextComponent.field_240750_d_, false);
        String strategyId = args[args.length - 1];
        WikiCommandStrategyLoader.executeStrategy(sender, pokemon, args, strategyId);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length >= 1) {
            List<String> suggestions = PixelmonCommandUtils.SPEC_REQUIREMENTS;
            suggestions.addAll(PixelmonSpecies.getFormattedEnglishNameSet());
            suggestions.addAll(PixelmonCommandUtils.PARTY_SLOTS);
            return suggestions;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

