/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTexturesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class NPCQuestGiver
extends NPCChatting {
    public NPCQuestGiver(EntityType<NPCQuestGiver> type, World world) {
        super((EntityType<? extends NPCChatting>)type, world);
        this.npcType = EnumNPCType.QuestGiver;
    }

    public NPCQuestGiver(World world) {
        this((EntityType<NPCQuestGiver>)((EntityType)EntityRegistration.NPC_QUEST_GIVER.get()), world);
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, this.npcType, (PlayerEntity)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof NPCEditorItem) {
                if (!NPCEditorItem.checkPermission((PlayerEntity)playerMP)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(loc), this.getChat(loc), this.npcType), playerMP);
                NetworkHelper.sendPacket(new SetChattingNPCTexturesPacket(), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCQuestGiverEditor, this.getNPCID());
            } else if (!this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat(), this.npcType), (ServerPlayerEntity)player);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCQuestGiver, this.getNPCID());
            }
        } else {
            this.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)this.field_70714_bg).func_85156_a(arg_0));
        }
        return true;
    }
}

