/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.entity.ticking.EntityTicker;
import com.pixelmonmod.pixelmon.api.entity.ticking.TickingEntityFactory;
import com.pixelmonmod.pixelmon.api.events.PixelmonUpdateEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonRetrievedEvent;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TickingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LensInfoPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonEntity
extends AbstractHoldsItemsEntity {
    public int legendaryTicks = -1;
    public int despawnCounter = -1;
    public static int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 15 * TICKSPERSECOND;
    public static int intMaxTicksToDespawn = 180 * TICKSPERSECOND;
    private LensInfoPacket info = null;
    public boolean grounded = false;
    private float flyPower = 0.0f;
    private int flyingCharges = -100;
    private int hoverTicks = 0;
    private int movementTick = 0;
    private int lastJump = -1;
    private EntityClassification spawnReplaceClassification = null;
    private Stats priorForm;
    public static ArrayList<IInteraction> interactionList = new ArrayList();
    int despawnTick = 0;
    public boolean canMove = true;
    public boolean stopRender = false;
    public PixelmonSpawnerTileEntity spawner = null;
    public ArrayList<UUID> cameraCapturedPlayers = new ArrayList();

    public PixelmonEntity(EntityType<PixelmonEntity> type, World world) {
        super((EntityType<? extends AbstractHoldsItemsEntity>)type, world);
    }

    public PixelmonEntity(World world, Pokemon pokemon) {
        this((EntityType<PixelmonEntity>)((EntityType)EntityRegistration.PIXELMON.get()), world);
        this.setPokemon(pokemon);
        if (world != null && world.field_72995_K) {
            PixelmonEntity.func_184227_b((double)PixelmonConfigProxy.getGraphics().getRenderDistanceWeight());
        }
        this.func_70661_as().func_212239_d(false);
        if (world != null) {
            pokemon.updateDimensionAndEntityID((RegistryKey<World>)world.func_234923_W_(), this.func_145782_y());
        }
    }

    public int getMovementTick() {
        return this.movementTick;
    }

    public EntityClassification getSpawnReplaceClassification() {
        return this.spawnReplaceClassification;
    }

    public void setSpawnReplaceClassification(EntityClassification type) {
        this.spawnReplaceClassification = type;
    }

    public Vector3d func_233626_a_(double p_233626_1_, boolean p_233626_3_, Vector3d p_233626_4_) {
        return Vector3d.field_186680_a;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public PixelmonEntity(World world, CompoundNBT nbt) {
        this(world, PokemonFactory.create(nbt));
        this.getPokemon().updateDimensionAndEntityID((RegistryKey<World>)world.func_234923_W_(), this.func_145782_y());
        this.deserializeNBT(nbt);
    }

    public void func_110206_u(int power) {
        if (this.pokemon.getForm().getMovement().canFly()) {
            ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
            if (mountedFlyingParameters != null) {
                mountedFlyingParameters.handleRiderJump(this, (PlayerEntity)this.func_184179_bs(), power);
            }
        } else {
            super.func_110206_u(power);
        }
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        if (this.spawnReplaceClassification != null) {
            return this.spawnReplaceClassification;
        }
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            return EntityClassification.WATER_CREATURE;
        }
        return EntityClassification.CREATURE;
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        return super.getTexture();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        for (EntityTicker ticker : TickingEntityFactory.getTickers()) {
            if (!ticker.applies(this)) continue;
            ticker.tick(this);
        }
        if (this.func_184179_bs() != null) {
            if (this.isFlying() && !this.func_184179_bs().func_213453_ef()) {
                ++this.movementTick;
                this.func_189654_d(true);
                ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
                if (mountedFlyingParameters != null) {
                    mountedFlyingParameters.handleMovementLogic(this, (PlayerEntity)this.func_184179_bs());
                }
            }
            if (this.func_70090_H()) {
                if (!(this.field_70170_p.field_72995_K || this.canSurf() || this.getForm().hasTag("walksonwater"))) {
                    this.func_184179_bs().func_233575_bb_();
                } else if (!this.func_184179_bs().func_213453_ef()) {
                    Entity controllingPassenger = this.func_184179_bs();
                    Vector3d lookAngle = controllingPassenger.func_70040_Z();
                    controllingPassenger.func_70050_g(300);
                    if (this.func_204231_K() || lookAngle.field_72448_b < -0.3) {
                        this.func_213317_d(this.func_213322_ci().func_178787_e(new Vector3d(0.0, lookAngle.func_82617_b(), 0.0)));
                    }
                }
            }
        }
    }

    @Override
    public void onLanding() {
        super.onLanding();
        this.hoverTicks = 0;
        this.resetAI();
        this.setAnimation(AnimationType.IDLE);
        this.setFlying(false);
        this.func_189654_d(false);
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.canSurf();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            super.func_70645_a(cause);
            if (this.getOwner() != null) {
                this.func_70606_j(0.0f);
                this.retrieve("Fainted");
            } else {
                if (cause.func_76346_g() instanceof ServerPlayerEntity && PixelmonConfigProxy.getGeneral().isCanPokemonBeHit()) {
                    List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
                    for (ItemStack stack : items) {
                        DropItemHelper.dropItemOnGround(this.func_213303_ch(), (ServerPlayerEntity)cause.func_76346_g(), stack, false, false);
                    }
                }
                this.func_241204_bJ_();
            }
        }
    }

    public ActionResultType func_233661_c_(PlayerEntity player, Hand hand) {
        if (player instanceof ServerPlayerEntity && hand == Hand.MAIN_HAND) {
            ItemStack itemstack = player.func_184586_b(hand);
            for (IInteraction i : interactionList) {
                if (!itemstack.func_190926_b() && player.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
                    return ActionResultType.SUCCESS;
                }
                if (!i.processOnEmptyHand(this, player, hand, itemstack) && itemstack.func_190926_b() || !i.processInteract(this, player, hand, itemstack)) continue;
                if (!itemstack.func_190926_b()) {
                    player.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 20);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void retrieve(String pokemonRetrievedEventReason) {
        if (this.battleController == null) {
            if (this.priorForm != null) {
                this.setForm(this.priorForm);
                this.priorForm = null;
            } else if (this.getForm().isTemporary()) {
                if (this.getForm().hasTag("galarian")) {
                    this.setForm(this.getPokemon().getSpecies().getForm("galarian"));
                } else if (this.getPokemon().getPersistentData().func_74764_b("SrcForm")) {
                    this.setForm(this.getPokemon().getPersistentData().func_74779_i("SrcForm"));
                } else {
                    this.setForm(this.getPokemon().getSpecies().getDefaultForm());
                }
            }
        }
        Pixelmon.EVENT_BUS.post((Event)new PokemonRetrievedEvent.Pre(this.getOwner(), this.getPokemon(), pokemonRetrievedEventReason));
        this.unloadEntity();
        Pixelmon.EVENT_BUS.post((Event)new PokemonRetrievedEvent.Post(this.getOwner(), this.getPokemon(), pokemonRetrievedEventReason));
    }

    public void releaseFromPokeball() {
        if (this.hasOwner()) {
            this.aggression = Aggression.PASSIVE;
        }
        this.func_241204_bJ_();
        try {
            this.field_70170_p.func_217376_c((Entity)this);
            if (this.pokemon != null) {
                this.pokemon.updateDimensionAndEntityID((RegistryKey<World>)this.func_130014_f_().func_234923_W_(), this.func_145782_y());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void clearAttackTarget() {
        this.func_70604_c(null);
        this.func_70624_b(null);
    }

    public void setPriorForm(Stats form) {
        this.priorForm = form;
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        AxisAlignedBB aabb = this.func_174813_aQ();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int x = (int)Math.floor(aabb.field_72340_a);
        while ((double)x < Math.ceil(aabb.field_72336_d)) {
            int y = (int)Math.floor(aabb.field_72338_b);
            while ((double)y < Math.ceil(aabb.field_72337_e)) {
                int z = (int)Math.floor(aabb.field_72339_c);
                while ((double)z < Math.ceil(aabb.field_72334_f)) {
                    if (this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            int wDepth = WorldHelper.getWaterDepth(this.func_233580_cy_(), this.field_70170_p);
            if (wDepth > this.getSwimmingParameters().getDepthRangeStart() && wDepth < this.getSwimmingParameters().getDepthRangeEnd()) {
                return true;
            }
            double prevPosY = this.func_226278_cu_();
            EntityHelper.setPosition((Entity)this, EnumRotation.y, this.func_226278_cu_() - (double)(this.getSwimmingParameters().getDepthRangeStart() + this.field_70146_Z.nextInt(this.getSwimmingParameters().getDepthRangeEnd() - this.getSwimmingParameters().getDepthRangeStart())));
            wDepth = WorldHelper.getWaterDepth(this.func_233580_cy_(), this.field_70170_p);
            if (wDepth > this.getSwimmingParameters().getDepthRangeStart() && wDepth < this.getSwimmingParameters().getDepthRangeEnd()) {
                EntityHelper.setPosition((Entity)this, EnumRotation.y, prevPosY);
                return false;
            }
            return true;
        }
        return true;
    }

    public void func_110159_bB() {
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return this.legendaryTicks <= 0 && super.func_213397_c(p_213397_1_);
    }

    @Override
    public LivingEntity getOwner() {
        if (!this.hasOwner()) {
            return null;
        }
        UUID trainerUUID = this.pokemon.getOwnerTrainerUUID();
        if (trainerUUID != null) {
            if (this.field_70170_p instanceof ServerWorld) {
                return (LivingEntity)CollectionHelper.find(((ServerWorld)this.field_70170_p).getEntities().collect(Collectors.toList()), e -> e.func_110124_au().equals(trainerUUID));
            }
            if (this.field_70170_p instanceof ClientWorld) {
                return (LivingEntity)CollectionHelper.find(Lists.newArrayList((Iterable)((ClientWorld)this.field_70170_p).func_217416_b()), e -> e.func_110124_au().equals(trainerUUID));
            }
        }
        return super.getOwner();
    }

    @Override
    public void func_70071_h_() {
        if (this.pokemon == null) {
            return;
        }
        this.field_70170_p.func_217381_Z().func_76320_a("pixelmon");
        if (!this.field_70170_p.field_72995_K && this.pokemon == null) {
            this.func_241204_bJ_();
            return;
        }
        if (Pixelmon.freeze) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.START))) {
            return;
        }
        if (this.func_226278_cu_() < 0.0 && !this.field_70170_p.field_72995_K) {
            if (this.battleController == null) {
                this.func_241204_bJ_();
            } else {
                EntityHelper.setPosition((Entity)this, EnumRotation.y, 0.0);
                this.func_213317_d(Vector3d.field_186680_a);
            }
        }
        if (this.pokemon.getStorage() instanceof TrainerPartyStorage && this.pokemon.getOwnerTrainer() != null && this.pokemon.getOwnerTrainer().battleController == null && (this.battleController == null || this.battleController.battleEnded)) {
            this.func_241204_bJ_();
        }
        if ((this.pokemon.getStorage() != null || this.pokemon.getOriginalTrainerUUID() != null) && this.pokemon.getEntityID() == -1) {
            this.func_241204_bJ_();
        }
        if (this.canDespawn && !this.field_70170_p.field_72995_K) {
            this.updateDespawn();
        }
        if (this.pokemon.getOwnerPlayerUUID() != null && (this.pokemon.getOwnerPlayer() == null || this.pokemon.getOwnerPlayer().func_71121_q().func_234923_W_() != this.func_130014_f_().func_234923_W_()) || this.pokemon.getOwnerTrainerUUID() != null && this.pokemon.getOwnerTrainer() == null) {
            this.retrieve("Forced");
        }
        super.func_70071_h_();
        this.floatEntity();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 100 == 1 && !this.isEvolving() && this.getOwner() instanceof PlayerEntity) {
            this.testTickingEvolution();
        }
        Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.END));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70763_ax = this.field_70764_aw;
        this.field_70760_ar = this.field_70761_aq;
        this.field_70758_at = this.field_70759_as;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void updateDespawn() {
        this.despawnTick = (this.despawnTick + 1) % 60;
        if (this.despawnTick == 0) {
            if (this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.getOwner() != null) {
                return;
            }
            if (!this.playersNearby() || this.despawnCounter == 0) {
                if (this.battleController != null) {
                    if (this.battleController.playerNumber != 0) {
                        return;
                    }
                    this.battleController.endBattle(BattleEndCause.FORCE);
                }
                this.func_241204_bJ_();
            } else {
                this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
            }
        }
        this.checkForRarityDespawn();
        if (this.legendaryTicks >= 0 && this.battleController == null) {
            --this.legendaryTicks;
            if (this.legendaryTicks == 0 && this.canDespawn) {
                this.func_241204_bJ_();
            }
        }
    }

    @Override
    public void func_241204_bJ_() {
        if (this.battleController == null) {
            if (this.priorForm != null) {
                this.setForm(this.priorForm);
                this.priorForm = null;
            } else if (this.getForm() != null && this.getForm().isTemporary()) {
                this.setForm(this.getSpecies().getDefaultForm());
            }
        }
        super.func_241204_bJ_();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!(source instanceof BattleDamageSource) && !source.field_76373_n.equals(DamageSource.field_76380_i.func_76355_l())) {
            if (source.func_76364_f() == null || source.func_76364_f() == source.func_76346_g()) {
                if (source.func_76346_g() instanceof ServerPlayerEntity) {
                    this.onAttackedByPlayer((ServerPlayerEntity)source.func_76346_g());
                }
            } else if (source.field_76373_n.equalsIgnoreCase("thrown") && ((IndirectEntityDamageSource)source).func_76346_g() instanceof ServerPlayerEntity) {
                this.func_70624_b((LivingEntity)((ServerPlayerEntity)((IndirectEntityDamageSource)source).func_76346_g()));
            }
            Stats baseStats = this.getForm();
            boolean waterSpawn = false;
            for (SpawnLocationType slt : baseStats.getSpawn().getSpawnLocations()) {
                if (slt != SpawnLocationType.WATER) continue;
                waterSpawn = true;
                break;
            }
            if (this.getPokemon().isPokemonOptional(PixelmonSpecies.UXIE, PixelmonSpecies.MESPRIT, PixelmonSpecies.AZELF)) {
                waterSpawn = true;
            }
            if (this.getPokemon().isPalette("drowned")) {
                waterSpawn = true;
            }
            List<Element> typeList = baseStats.getTypes();
            if (this.func_230279_az_() && source.func_76347_k()) {
                return false;
            }
            if (typeList.contains(Element.FIRE) && source.func_76347_k()) {
                return false;
            }
            if (typeList.contains(Element.GHOST) && !source.func_82725_o()) {
                return false;
            }
            if (typeList.contains(Element.ELECTRIC) && source.field_76373_n.equals(DamageSource.field_180137_b.func_76355_l())) {
                this.func_70691_i(amount);
                return false;
            }
            if ((typeList.contains(Element.WATER) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_ONE) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_TWO) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_THREE) || waterSpawn || baseStats.getMovement().getSwimmingParameters() != null && baseStats.getMovement().getSwimmingParameters().getDepthRangeEnd() > 2) && source == DamageSource.field_76369_e) {
                return false;
            }
            if ((typeList.contains(Element.STEEL) || baseStats.getEggGroups().contains(PixelmonEggGroups.MINERAL)) && source.func_82725_o()) {
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    private void onAttackedByPlayer(ServerPlayerEntity player) {
        int knockback;
        if (this.battleController == null && !this.hasOwner() && player.func_184614_ca().func_77973_b() == Items.field_151055_y && (knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)player.func_184614_ca())) > 0) {
            if (!player.func_184812_l_() && RandomHelper.getRandomChance(40)) {
                player.func_71121_q().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                player.func_184614_ca().func_190918_g(1);
            } else {
                this.func_213293_j(player.func_70040_Z().field_72450_a * (double)knockback, 0.3 * (double)knockback, player.func_70040_Z().field_72449_c * (double)knockback);
                player.func_71121_q().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.func_70604_c((LivingEntity)player);
            }
        }
    }

    private void checkForRarityDespawn() {
        if (this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.getOwner() != null) {
            return;
        }
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                if (this.battleController != null) {
                    this.battleController.endBattle(BattleEndCause.FORCE);
                }
                this.func_241204_bJ_();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    private boolean playersNearby() {
        for (int i = 0; i < this.field_70170_p.func_217369_A().size(); ++i) {
            double distancez;
            double distancey;
            PlayerEntity player = (PlayerEntity)this.field_70170_p.func_217369_A().get(i);
            double distancex = player.func_226277_ct_() - this.func_226277_ct_();
            double distancesquared = distancex * distancex + (distancey = player.func_226278_cu_() - this.func_226278_cu_()) * distancey + (distancez = player.func_226281_cx_() - this.func_226281_cx_()) * distancez;
            if (!(distancesquared < (double)(PixelmonConfigProxy.getSpawning().getDespawnRadius() * PixelmonConfigProxy.getSpawning().getDespawnRadius()))) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSave() {
        return this.func_70089_S() && this.pokemon != null && !this.isRaidPokemon() && this.pokemon.getStorage() == null && (super.func_104002_bU() || PixelmonConfigProxy.getStorage().isWriteEntitiesToWorld());
    }

    public boolean func_70039_c(CompoundNBT p_70039_1_) {
        return this.shouldSave() && super.func_70039_c(p_70039_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.getSpawnLocation() == null) {
            this.setSpawnLocation(SpawnLocationType.LAND);
        }
        nbt.func_74774_a("pixelmonType", (byte)this.getSpawnLocation().ordinal());
        if (this.legendaryTicks > 0) {
            nbt.func_74768_a("legendaryTicks", this.legendaryTicks);
            nbt.func_74772_a("legendaryTime", this.field_70170_p.func_82737_E());
        }
        nbt.func_74778_a("BossTier", this.getBossTier().getID());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        float h = this.func_110143_aJ();
        this.func_70606_j(h);
        if (nbt.func_74764_b("pixelmonType")) {
            this.setSpawnLocation(SpawnLocationType.getFromIndex(nbt.func_74771_c("pixelmonType")));
        } else if (this.getForm().getSpawn().getSpawnLocations()[0] == SpawnLocationType.LAND) {
            this.setSpawnLocation(SpawnLocationType.LAND);
        } else {
            this.setSpawnLocation(SpawnLocationType.WATER);
        }
        this.resetAI();
        if (nbt.func_74764_b("legendaryTicks")) {
            this.legendaryTicks = nbt.func_74762_e("legendaryTicks");
            long lastTime = nbt.func_74763_f("legendaryTime");
            this.legendaryTicks -= (int)(this.field_70170_p.func_82737_E() - lastTime);
            if (this.legendaryTicks <= 0) {
                this.func_241204_bJ_();
            }
        }
        if (nbt.func_74764_b("BossTier")) {
            this.setBossTier(BossTierRegistry.getBossTierOrNotBoss(nbt.func_74779_i("BossTier")));
        }
    }

    @Override
    public void unloadEntity() {
        super.unloadEntity();
        this.func_70106_y();
        this.clearAttackTarget();
        if (this.pokemon != null) {
            this.pokemon.updateDimensionAndEntityID((RegistryKey<World>)World.field_234918_g_, -1);
        }
    }

    public void startEvolution(Evolution evolution, String cause) {
        if (this.func_110143_aJ() < 1.0f) {
            return;
        }
        StorageProxy.getParty((ServerPlayerEntity)((ServerPlayerEntity)this.getOwner())).guiOpened = true;
        new EvolutionQuery(this, evolution, cause);
    }

    public boolean isLoaded() {
        return this.isLoaded(false);
    }

    public boolean isLoaded(boolean checkChunk) {
        boolean isLoaded = true;
        if (checkChunk) {
            isLoaded = this.field_70170_p.isAreaLoaded(this.func_233580_cy_(), 1);
        }
        if (isLoaded) {
            isLoaded = this.field_70170_p.func_73045_a(this.func_145782_y()) != null;
        }
        return isLoaded;
    }

    public boolean isRaidPokemon() {
        return this.getPixelmonWrapper() != null && this.getPixelmonWrapper().isRaidPokemon();
    }

    public boolean testTradeEvolution(Species with) {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<TradeEvolution> tradeEvolutions = this.getPokemon().getEvolutions(TradeEvolution.class);
        for (TradeEvolution evo : tradeEvolutions) {
            if (!evo.canEvolve(this, with)) continue;
            return evo.doEvolution(this, "TradeMachine");
        }
        return false;
    }

    public boolean testLevelEvolution(int level) {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<LevelingEvolution> levelingEvolutions = this.getPokemon().getEvolutions(LevelingEvolution.class);
        for (LevelingEvolution evo : levelingEvolutions) {
            if (!evo.canEvolve(this, level)) continue;
            return evo.doEvolution(this, "Levelling");
        }
        return false;
    }

    public boolean testInteractEvolution(ItemStack stack) {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<InteractEvolution> interactingEvolutions = this.getPokemon().getEvolutions(InteractEvolution.class);
        for (InteractEvolution evo : interactingEvolutions) {
            if (!evo.canEvolve(this, stack)) continue;
            return evo.doEvolution(this, "Interaction") && evo.emptyHand == false;
        }
        return false;
    }

    public boolean testTickingEvolution() {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<TickingEvolution> tickingEvolutions = this.getPokemon().getEvolutions(TickingEvolution.class);
        for (TickingEvolution evo : tickingEvolutions) {
            if (!evo.canEvolve(this)) continue;
            return evo.doEvolution(this, "TICKING");
        }
        return false;
    }

    public void setSpawnerParent(PixelmonSpawnerTileEntity spawner) {
        this.spawner = spawner;
    }

    @Override
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (!this.field_70122_E && this.func_226278_cu_() > 64.0) {
            double d3 = this.func_226277_ct_() - p_145770_1_;
            double d5 = this.func_226281_cx_() - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.func_70112_a(d6);
        }
        double d3 = this.func_226277_ct_() - p_145770_1_;
        double d4 = this.func_226278_cu_() - p_145770_3_;
        double d5 = this.func_226281_cx_() - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.func_70112_a(d6);
    }

    public double getYCentre() {
        return this.func_226278_cu_() + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) / 2.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientOnlyInfo(LensInfoPacket info) {
        this.info = info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LensInfoPacket getClientOnlyInfo() {
        return this.info;
    }

    public boolean isUncatchable() {
        return this.pokemon.isUncatchable();
    }

    public boolean isUnbattleable() {
        return this.pokemon.isUnbattleable();
    }

    public void exposeInfo(ServerPlayerEntity player) {
        NetworkHelper.sendPacket(new LensInfoPacket(this), player);
    }

    public void hideInfo(ServerPlayerEntity player) {
        NetworkHelper.sendPacket(new LensInfoPacket(this, true), player);
    }

    public static boolean displacePokemonIfShouldered(ServerPlayerEntity player, UUID uuid) {
        CompoundNBT nbt;
        if (player.func_192023_dk() != null && !(nbt = player.func_192023_dk()).isEmpty() && nbt.func_186857_a("UUID").equals(uuid)) {
            player.func_192029_h(new CompoundNBT());
            return true;
        }
        if (player.func_192025_dl() != null && !(nbt = player.func_192025_dl()).isEmpty() && nbt.func_186857_a("UUID").equals(uuid)) {
            player.func_192031_i(new CompoundNBT());
            return true;
        }
        return false;
    }

    public boolean func_230285_a_(Fluid fluid) {
        return this.getForm().hasTag("walksonwater") && fluid.func_207185_a((ITag)FluidTags.field_206959_a) || this.getForm().hasTag("walksonlava") && fluid.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    private void floatEntity() {
        ISelectionContext iselectioncontext;
        if (this.func_70090_H() && this.getForm().hasTag("walksonwater")) {
            iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            }
        }
        if (this.func_180799_ab() && this.getForm().hasTag("walksonlava")) {
            iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            }
        }
    }

    public int getFlyingCharges() {
        return this.flyingCharges;
    }

    public void setFlyingCharges(Integer flyingCharges) {
        this.flyingCharges = flyingCharges;
    }

    public float getFlyPower() {
        return this.flyPower;
    }

    public void setFlyPower(float flyPower) {
        this.flyPower = flyPower;
    }

    public void setLastJump(int lastJump) {
        this.lastJump = lastJump;
    }

    public int getLastJump() {
        return this.lastJump;
    }

    public int getHoverTicks() {
        return this.hoverTicks;
    }

    public void setHoverTicks(int hoverTicks) {
        this.hoverTicks = hoverTicks;
    }

    public void func_70636_d() {
        if (this.field_70773_bE > 0) {
            --this.field_70773_bE;
        }
        if (this.func_184186_bw()) {
            this.field_70716_bi = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_70716_bi > 0) {
            double d0 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
            double d2 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
            double d4 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
            double d6 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d6 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d2, d4);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
        if (this.field_208002_br > 0) {
            this.field_70759_as = (float)((double)this.field_70759_as + MathHelper.func_76138_g((double)(this.field_208001_bq - (double)this.field_70759_as)) / (double)this.field_208002_br);
            --this.field_208002_br;
        }
        Vector3d vector3d = this.func_213322_ci();
        double d1 = vector3d.field_72450_a;
        double d3 = vector3d.field_72448_b;
        double d5 = vector3d.field_72449_c;
        if (Math.abs(vector3d.field_72450_a) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vector3d.field_72448_b) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vector3d.field_72449_c) < 0.003) {
            d5 = 0.0;
        }
        this.func_213293_j(d1, d3, d5);
        this.field_70170_p.func_217381_Z().func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.func_217381_Z().func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("jump");
        if (this.field_70703_bu && this.func_241208_cS_()) {
            double d7 = this.func_180799_ab() ? this.func_233571_b_((ITag)FluidTags.field_206960_b) : this.func_233571_b_((ITag)FluidTags.field_206959_a);
            boolean flag = this.func_70090_H() && d7 > 0.0;
            double d8 = this.func_233579_cu_();
            if (!flag || this.field_70122_E && !(d7 > d8)) {
                if (!this.func_180799_ab() || this.field_70122_E && !(d7 > d8)) {
                    if ((this.field_70122_E || flag && d7 <= d8) && this.field_70773_bE == 0) {
                        this.func_70664_aZ();
                        this.field_70773_bE = 10;
                    }
                } else {
                    this.func_180466_bG((ITag<Fluid>)FluidTags.field_206960_b);
                }
            } else {
                this.func_180466_bG((ITag<Fluid>)FluidTags.field_206959_a);
            }
        } else {
            this.field_70773_bE = 0;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.func_184616_r();
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_213352_e(new Vector3d((double)this.field_70702_br, (double)this.field_70701_bs, (double)this.field_191988_bg));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        if (this.field_204807_bs > 0) {
            --this.field_204807_bs;
            this.func_204801_a(axisalignedbb, this.func_174813_aQ());
        }
        this.func_85033_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.field_70170_p.field_72995_K && this.func_230270_dK_() && this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    protected void func_213385_F() {
    }
}

