/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.projectiles.HookEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FishingRodItem
extends PixelmonItem {
    private EnumRodType rodType;

    public FishingRodItem(EnumRodType rodType) {
        super(new Item.Properties().func_200918_c(rodType.maxDamage).func_200916_a(ItemGroup.field_78040_i));
        this.rodType = rodType;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        if (playerIn.field_71104_cf != null) {
            boolean canPull = true;
            if (playerIn.field_71104_cf.field_146043_c != null) {
                canPull = playerIn.field_71104_cf.field_146043_c.func_70104_M();
            }
            if (canPull) {
                int i = playerIn.field_71104_cf.func_146034_e(playerIn.func_184586_b(hand));
                playerIn.func_184586_b(hand).func_222118_a(i, (LivingEntity)playerIn, t -> {});
            }
        } else if (StorageProxy.getParty(playerIn.func_110124_au()).getTeam().stream().anyMatch(Pokemon::canBattle)) {
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 0.5, playerIn.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
            int rodLevel = -1;
            if (playerIn.func_184586_b(hand).func_77942_o() && playerIn.func_184586_b(hand).func_77978_p().func_74764_b("rodQuality")) {
                rodLevel = playerIn.func_184586_b(hand).func_77978_p().func_74762_e("rodQuality");
            }
            worldIn.func_217376_c((Entity)new HookEntity(worldIn, playerIn, this.rodType, rodLevel));
        } else {
            ChatHandler.sendChat((Entity)playerIn, "pixelmon.projectiles.teamfainted", new Object[0]);
        }
        playerIn.func_184609_a(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public EnumRodType getRodType() {
        return this.rodType;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        int rodLevel = -1;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("rodQuality")) {
            rodLevel = stack.func_77978_p().func_74762_e("rodQuality");
        }
        if (rodLevel > -1 && this.rodType != EnumRodType.OasRod) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.pixelmon." + this.rodType.name().toLowerCase(Locale.ROOT) + ".quality_" + rodLevel));
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }
}

