/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.TumblestoneBlock;
import com.pixelmonmod.pixelmon.init.registry.PixelmonTags;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class HammerItem
extends ToolItem {
    private boolean inSmash = false;
    private static final Set<Block> EFFECTIVE_BLOCKS = Sets.newHashSet((Object[])new Block[]{PixelmonBlocks.red_tumblestone, PixelmonBlocks.black_tumblestone, PixelmonBlocks.blue_tumblestone});

    public HammerItem(IItemTier tier) {
        super(2.0f, -2.0f, tier, EFFECTIVE_BLOCKS, tier == ItemTier.NETHERITE ? new Item.Properties().func_200916_a(ItemGroup.field_78040_i).addToolType(PixelmonTags.HAMMER, tier.func_200925_d()).func_234689_a_() : new Item.Properties().func_200916_a(ItemGroup.field_78040_i).addToolType(PixelmonTags.HAMMER, tier.func_200925_d()));
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return this.func_200891_e().func_200925_d() >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g || EFFECTIVE_BLOCKS.contains(state.func_177230_c());
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (EFFECTIVE_BLOCKS.contains(state.func_177230_c())) {
            return 1.0f;
        }
        if (this.func_150897_b(state)) {
            return this.func_200891_e().func_200928_b() / 4.0f;
        }
        return 0.25f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_179218_a(ItemStack stack, World world, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        if (entity instanceof ServerPlayerEntity && !this.inSmash) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            BlockState mainBlock = world.func_180495_p(blockPos);
            if (mainBlock.func_177230_c() instanceof TumblestoneBlock) {
                return false;
            }
            int outerBlocksBroken = 0;
            try {
                int extraDamage;
                this.inSmash = true;
                if (Math.abs(player.field_70125_A) > 45.0f) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos pos;
                            BlockState state;
                            if (x == 0 && z == 0 || !this.func_150897_b(state = world.func_180495_p(pos = blockPos.func_177982_a(x, 0, z))) || !(state.func_185887_b((IBlockReader)world, pos) <= mainBlock.func_185887_b((IBlockReader)world, pos)) || !player.field_71134_c.func_180237_b(pos)) continue;
                            ++outerBlocksBroken;
                        }
                    }
                } else {
                    Direction.Axis axis = player.func_174811_aO().func_176740_k();
                    for (int y = -1; y <= 1; ++y) {
                        for (int xz = -1; xz <= 1; ++xz) {
                            if (y == 0 && xz == 0) continue;
                            BlockPos pos = blockPos.func_177982_a(axis == Direction.Axis.X ? 0 : xz, y, axis == Direction.Axis.X ? xz : 0);
                            BlockState state = world.func_180495_p(pos);
                            if (!this.func_150897_b(world.func_180495_p(pos)) || !(state.func_185887_b((IBlockReader)world, pos) <= mainBlock.func_185887_b((IBlockReader)world, pos)) || !player.field_71134_c.func_180237_b(pos)) continue;
                            ++outerBlocksBroken;
                        }
                    }
                }
                if ((extraDamage = outerBlocksBroken * PixelmonConfigProxy.getGeneral().getHammerDurabilityLossMultiplier() - outerBlocksBroken) > 0) {
                    stack.func_222118_a(extraDamage, (LivingEntity)player, pl -> pl.func_213361_c(EquipmentSlotType.MAINHAND));
                }
            }
            finally {
                this.inSmash = false;
            }
        }
        return super.func_179218_a(stack, world, blockState, blockPos, entity);
    }
}

