/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.AsOne;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Klutz;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Unnerve;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import com.pixelmonmod.pixelmon.items.heldItems.BlackSludgeItem;
import com.pixelmonmod.pixelmon.items.heldItems.ChoiceItem;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import com.pixelmonmod.pixelmon.items.heldItems.FlameOrbItem;
import com.pixelmonmod.pixelmon.items.heldItems.IronBallItem;
import com.pixelmonmod.pixelmon.items.heldItems.LaggingTailItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.items.heldItems.RingTargetItem;
import com.pixelmonmod.pixelmon.items.heldItems.StickyBarbItem;
import com.pixelmonmod.pixelmon.items.heldItems.ToxicOrbItem;
import com.pixelmonmod.pixelmon.tools.MutableBoolean;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HeldItem
extends PixelmonItem {
    private final EnumHeldItems heldItemType;

    public HeldItem(EnumHeldItems heldItemType, Item.Properties properties) {
        super(properties.func_200916_a(PixelmonItemGroups.TAB_HELD_ITEMS));
        this.heldItemType = heldItemType;
    }

    public EnumHeldItems getHeldItemType() {
        return this.heldItemType;
    }

    public static boolean isItemOfType(ItemStack itemStack, EnumHeldItems type) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            return item instanceof HeldItem && ((HeldItem)item).heldItemType == type;
        }
        return false;
    }

    public boolean interact(PixelmonEntity pokemon, ItemStack itemstack, PlayerEntity player) {
        return false;
    }

    public void onStartOfBattle(PixelmonWrapper pw) {
    }

    public void onEndOfBattle(PixelmonWrapper pw) {
    }

    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
    }

    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper defender, float damage, DamageTypeEnum damageType) {
    }

    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
    }

    public double preProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        return damage;
    }

    public double preProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        return damage;
    }

    public void postProcessAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack) {
    }

    public void postProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage) {
    }

    public void postProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage) {
    }

    public double modifyDamageIncludeFixed(double damage, PixelmonWrapper attacker, PixelmonWrapper target, Attack attack) {
        return damage;
    }

    public void onMiss(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack) {
    }

    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        return true;
    }

    public void allowsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
    }

    public void applyEffectAfterAllTargets(PixelmonWrapper user) {
    }

    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
    }

    public void applyPostSwitchEffect(PixelmonWrapper newPokemon) {
    }

    public void applySwitchOutEffect(PixelmonWrapper pw) {
    }

    public void onStatusAdded(PixelmonWrapper user, PixelmonWrapper opponent, StatusBase status) {
    }

    public void onGlobalStatusAdded(PixelmonWrapper itemHolder, GlobalStatusBase globalStatus) {
    }

    public void onStatIncrease(PixelmonWrapper pokemon, PixelmonWrapper affected, int amount, BattleStatsType stat) {
    }

    public void onStatDecrease(PixelmonWrapper pokemon, PixelmonWrapper affected, int amount, BattleStatsType stat) {
    }

    public void onStatModified(PixelmonWrapper itemHolder, PixelmonWrapper affected) {
    }

    public void onTerrainSwitch(BattleController bc, PixelmonWrapper user, Terrain terrain) {
    }

    public void onWeatherSwitch(BattleController bc, PixelmonWrapper user, Weather weather) {
    }

    public int adjustCritStage(PixelmonWrapper user) {
        return 0;
    }

    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
    }

    public void applyRepeatedEffectAfterStatus(PixelmonWrapper pokemon) {
    }

    public void applyEffectOnContact(PixelmonWrapper pokemon, PixelmonWrapper opponent) {
    }

    public void applyEffectInDaycare(Pokemon pokemon, Pokemon partner) {
    }

    public List<Element> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        return target.type;
    }

    public void eatBerry(PixelmonWrapper user) {
        user.bc.getActiveUnfaintedPokemon().forEach(pw -> pw.getBattleAbility().onBerryEaten((PixelmonWrapper)pw, user, this));
        user.eatenBerry = true;
    }

    public static boolean canEatBerry(PixelmonWrapper user) {
        if (user.bc == null) {
            return true;
        }
        if (!HeldItem.canUseItem(user)) {
            return false;
        }
        ArrayList<PixelmonWrapper> opponents = user.bc.getOpponentPokemon(user.getParticipant());
        for (PixelmonWrapper opponent : opponents) {
            if (!(opponent.getBattleAbility() instanceof Unnerve) && !(opponent.getBattleAbility() instanceof AsOne)) continue;
            return false;
        }
        return true;
    }

    public int[] modifyPowerAndAccuracyUser(int[] modifiedMoveStats, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return modifiedMoveStats;
    }

    public int[] modifyPowerAndAccuracyTarget(int[] modifiedMoveStats, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return modifiedMoveStats;
    }

    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        return stats;
    }

    public float modifyPriority(PixelmonWrapper pokemon, float priority, MutableBoolean triggered) {
        return priority;
    }

    public boolean affectMultiturnMove(PixelmonWrapper user) {
        return false;
    }

    public float modifyWeight(float initWeight) {
        return initWeight;
    }

    public boolean hasNegativeEffect() {
        return this instanceof ChoiceItem || this instanceof EVAdjusting || this instanceof BlackSludgeItem || this instanceof FlameOrbItem || this instanceof IronBallItem || this instanceof LaggingTailItem || this instanceof RingTargetItem || this instanceof StickyBarbItem || this instanceof ToxicOrbItem;
    }

    public boolean isBerry() {
        return this instanceof BerryItem;
    }

    public static boolean canUseItem(PixelmonWrapper user) {
        return user.getHeldItem() != null && !(user.getBattleAbility() instanceof Klutz) && !user.hasStatus(StatusType.Embargo, StatusType.CorrosiveGas) && (user.bc == null || user.bc.globalStatusController == null || !user.bc.globalStatusController.hasStatus(StatusType.MagicRoom));
    }

    public static HeldItem getItemHeld(ItemStack itemStack) {
        if (itemStack == null || itemStack == ItemStack.field_190927_a) {
            return NoItem.noItem;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof HeldItem) {
            return (HeldItem)item;
        }
        return NoItem.noItem;
    }
}

