/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm;

import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class QuestMarker {
    public float x;
    public float y;
    public float z;
    public UUID uuid;
    public RegistryKey<World> dim;
    public boolean specialColor;
    public QuestColor color;
    public Type type;

    public QuestMarker(float x, float y, float z, UUID uuid, RegistryKey<World> dim, QuestColor color, Type type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.uuid = uuid;
        this.dim = dim;
        this.color = color;
        this.type = type;
    }

    public QuestMarker(BlockPos pos, UUID uuid, RegistryKey<World> dim, QuestColor color, Type type) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), uuid, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, UUID uuid, RegistryKey<World> dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, uuid, dim, color, type);
    }

    public QuestMarker(float x, float y, float z, RegistryKey<World> dim, QuestColor color, Type type) {
        this(x, y, z, (UUID)null, dim, color, type);
    }

    public QuestMarker(UUID uuid, RegistryKey<World> dim, QuestColor color, Type type) {
        this(0.0f, 0.0f, 0.0f, uuid, dim, color, type);
    }

    public QuestMarker(BlockPos pos, RegistryKey<World> dim, QuestColor color, Type type) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (UUID)null, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, RegistryKey<World> dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, (UUID)null, dim, color, type);
    }

    public QuestMarker(PacketBuffer buf) {
        this.read(buf);
    }

    public void read(PacketBuffer buf) {
        if (buf.readBoolean()) {
            this.uuid = buf.func_179253_g();
        } else {
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
        }
        this.dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        this.specialColor = buf.readBoolean();
        this.color = this.specialColor ? new QuestColor(buf.readInt(), 0, 0) : new QuestColor(buf.readInt());
        this.type = Type.values()[buf.readByte()];
    }

    public void write(PacketBuffer buf) {
        if (this.uuid != null) {
            buf.writeBoolean(true);
            buf.func_179252_a(this.uuid);
        } else {
            buf.writeBoolean(false);
            buf.writeFloat(this.x);
            buf.writeFloat(this.y);
            buf.writeFloat(this.z);
        }
        buf.func_192572_a(this.dim.func_240901_a_());
        buf.writeBoolean(this.color.getR() < 0);
        buf.writeInt(this.color.getR() < 0 ? this.color.getR() : this.color.getRGB());
        buf.writeByte(this.type.ordinal());
    }

    public QuestColor getColor(long worldTime) {
        if (this.specialColor && this.color.getR() == -1) {
            long mod = worldTime % 120L;
            if (mod > 60L) {
                mod -= (mod - 60L) * 2L;
            }
            mod = (int)((double)mod * 1.5);
            return new QuestColor(28, 65 + (int)mod, 138);
        }
        return this.color;
    }

    public static enum Type {
        EXCLAMATION,
        QUESTION;

    }
}

