/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayClientPacket;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon")
public class PixelExtrasStorage {
    public static final Map<UUID, PixelExtrasData> PLAYER_EXTRAS = new HashMap<UUID, PixelExtrasData>();

    public static PixelExtrasData getData(UUID uuid) {
        if (!PLAYER_EXTRAS.containsKey(uuid)) {
            PLAYER_EXTRAS.put(uuid, new PixelExtrasData(uuid));
            ExtrasContact.fromCache(PLAYER_EXTRAS.get(uuid));
        }
        return PLAYER_EXTRAS.get(uuid);
    }

    public static void addAndDistribute(PixelExtrasData data) {
        PLAYER_EXTRAS.put(data.id, data);
        if (data.isReady() && data.hasData()) {
            NetworkHelper.sendToAll(new PixelExtrasDisplayClientPacket(data));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PLAYER_EXTRAS.remove(event.getPlayer().func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        PixelExtrasData data = PixelExtrasStorage.getData(player.func_110124_au());
        ExtrasContact.updateData(data, data.dataHash()).whenComplete((pixelExtrasData, throwable) -> {
            if (PixelExtrasStorage.getData(player.func_110124_au()).has(ExtrasContact.Groups.Developer)) {
                ChatHandler.sendMessageToAllPlayers(player.func_184102_h(), "pixelmon.dev.join", player.func_200200_C_());
            }
        });
    }
}

