/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.world.structure.PixelmonStructures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AdvancedMovingJigsawPiece
extends JigsawPiece {
    private static final Codec<Either<ResourceLocation, Template>> TEMPLATE_CODEC = Codec.of(AdvancedMovingJigsawPiece::encodeTemplate, (Decoder)ResourceLocation.field_240908_a_.map(Either::left));
    public static final Codec<AdvancedMovingJigsawPiece> CODEC = RecordCodecBuilder.create(p_236841_0_ -> p_236841_0_.group(AdvancedMovingJigsawPiece.templateCodec(), AdvancedMovingJigsawPiece.processorsCodec(), (App)AdvancedMovingJigsawPiece.func_236848_d_(), AdvancedMovingJigsawPiece.groundLevelDeltaCodec(), AdvancedMovingJigsawPiece.yHackCodec(), AdvancedMovingJigsawPiece.xHackCodec(), AdvancedMovingJigsawPiece.keepLiquids()).apply((Applicative)p_236841_0_, AdvancedMovingJigsawPiece::new));
    protected final Integer groundLevelDelta;
    protected final Integer yHack;
    protected final Integer xHack;
    protected final Boolean keepLiquids;
    protected final Either<ResourceLocation, Template> template;
    protected final Supplier<StructureProcessorList> processors;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, Template> p_236840_0_, DynamicOps<T> p_236840_1_, T p_236840_2_) {
        Optional optional = p_236840_0_.left();
        return !optional.isPresent() ? DataResult.error((String)"Can not serialize a runtime pool element") : ResourceLocation.field_240908_a_.encode(optional.get(), p_236840_1_, p_236840_2_);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Supplier<StructureProcessorList>> processorsCodec() {
        return IStructureProcessorType.field_242922_m.fieldOf("processors").forGetter(p_236845_0_ -> p_236845_0_.processors);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Integer> groundLevelDeltaCodec() {
        return Codec.INT.fieldOf("ground_level_delta").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Integer> yHackCodec() {
        return Codec.INT.fieldOf("y_hack").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Integer> xHackCodec() {
        return Codec.INT.fieldOf("x_hack").forGetter(o -> 1);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Boolean> keepLiquids() {
        return Codec.BOOL.fieldOf("keep_liquids").forGetter(o -> true);
    }

    protected static <E extends AdvancedMovingJigsawPiece> RecordCodecBuilder<E, Either<ResourceLocation, Template>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(p_236842_0_ -> p_236842_0_.template);
    }

    protected AdvancedMovingJigsawPiece(Either<ResourceLocation, Template> p_i242008_1_, Supplier<StructureProcessorList> p_i242008_2_, JigsawPattern.PlacementBehaviour p_i242008_3_, Integer groundLevelDelta, Integer yHack, Integer xHack, Boolean keepLiquids) {
        super(p_i242008_3_);
        this.template = p_i242008_1_;
        this.processors = p_i242008_2_;
        this.groundLevelDelta = groundLevelDelta;
        this.yHack = yHack;
        this.xHack = xHack;
        this.keepLiquids = keepLiquids;
    }

    public AdvancedMovingJigsawPiece(Template p_i242009_1_) {
        this((Either<ResourceLocation, Template>)Either.right((Object)p_i242009_1_), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID, 1, 0, 0, true);
    }

    public int func_214850_d() {
        return this.groundLevelDelta;
    }

    private Template getTemplate(TemplateManager p_236843_1_) {
        return (Template)this.template.map(arg_0 -> ((TemplateManager)p_236843_1_).func_200220_a(arg_0), Function.identity());
    }

    public List<Template.BlockInfo> getDataMarkers(TemplateManager p_214857_1_, BlockPos p_214857_2_, Rotation p_214857_3_, boolean p_214857_4_) {
        Template template = this.getTemplate(p_214857_1_);
        List list = template.func_215386_a(p_214857_2_, new PlacementSettings().func_186220_a(p_214857_3_), Blocks.field_185779_df, p_214857_4_);
        ArrayList list1 = Lists.newArrayList();
        for (Template.BlockInfo template$blockinfo : list) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            list1.add(template$blockinfo);
        }
        return list1;
    }

    public List<Template.BlockInfo> func_214849_a(TemplateManager p_214849_1_, BlockPos p_214849_2_, Rotation p_214849_3_, Random p_214849_4_) {
        Template template = this.getTemplate(p_214849_1_);
        List list = template.func_215386_a(p_214849_2_, new PlacementSettings().func_186220_a(p_214849_3_), Blocks.field_226904_lY_, true);
        Collections.shuffle(list, p_214849_4_);
        return list;
    }

    public MutableBoundingBox func_214852_a(TemplateManager p_214852_1_, BlockPos p_214852_2_, Rotation p_214852_3_) {
        Template template = this.getTemplate(p_214852_1_);
        MutableBoundingBox boundingBox = template.func_215388_b(new PlacementSettings().func_186220_a(p_214852_3_), p_214852_2_);
        boundingBox.field_78894_e += this.yHack.intValue();
        boundingBox.field_78893_d += this.xHack.intValue();
        boundingBox.field_78897_a -= this.xHack.intValue();
        return boundingBox;
    }

    public boolean func_230378_a_(TemplateManager p_230378_1_, ISeedReader p_230378_2_, StructureManager p_230378_3_, ChunkGenerator p_230378_4_, BlockPos p_230378_5_, BlockPos p_230378_6_, Rotation p_230378_7_, MutableBoundingBox p_230378_8_, Random p_230378_9_, boolean p_230378_10_) {
        PlacementSettings placementsettings;
        Template template = this.getTemplate(p_230378_1_);
        if (!template.func_237146_a_((IServerWorld)p_230378_2_, p_230378_5_, p_230378_6_, placementsettings = this.getSettings(p_230378_7_, p_230378_8_, p_230378_10_), p_230378_9_, 18)) {
            return false;
        }
        for (Template.BlockInfo template$blockinfo : Template.processBlockInfos((IWorld)p_230378_2_, (BlockPos)p_230378_5_, (BlockPos)p_230378_6_, (PlacementSettings)placementsettings, this.getDataMarkers(p_230378_1_, p_230378_5_, p_230378_7_, false), (Template)template)) {
            this.func_214846_a((IWorld)p_230378_2_, template$blockinfo, p_230378_5_, p_230378_7_, p_230378_9_, p_230378_8_);
        }
        return true;
    }

    protected PlacementSettings getSettings(Rotation p_230379_1_, MutableBoundingBox p_230379_2_, boolean p_230379_3_) {
        PlacementSettings placementsettings = new PlacementSettings();
        placementsettings.func_186223_a(p_230379_2_);
        placementsettings.func_186220_a(p_230379_1_);
        placementsettings.func_215223_c(true);
        placementsettings.func_186222_a(false);
        placementsettings.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        placementsettings.func_237133_d_(true);
        placementsettings.field_204765_h = this.keepLiquids;
        if (!p_230379_3_) {
            placementsettings.func_215222_a((StructureProcessor)JigsawReplacementStructureProcessor.field_215196_a);
        }
        this.processors.get().func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        this.func_214854_c().func_214937_b().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        return placementsettings;
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return PixelmonStructures.ADVANCED_MOVING;
    }

    public String toString() {
        return "AdvancedMoving[" + this.template + "]";
    }
}

