/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.container;

import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.item.CardItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class DeckInventory
extends Inventory {
    private String name = "Deck";
    public static String INVENTORY_TAG_NAME = "DeckInventory";
    private final PlayerEntity player;
    private final ItemStack item;
    public static final int size = 62;
    private NonNullList<ItemStack> inventory;
    public boolean isLocked = false;

    public DeckInventory(ItemStack item, PlayerEntity player) {
        super(62);
        String deckName;
        ThemeDeck deck;
        this.item = item;
        this.player = player;
        this.inventory = NonNullList.func_191197_a((int)62, (Object)ItemStack.field_190927_a);
        CompoundNBT nbt = item.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            item.func_77982_d(nbt);
        }
        if ((deck = ThemeDecks.get(deckName = nbt.func_74779_i("deck"))) != null) {
            TranslationTextComponent name = new TranslationTextComponent("deck." + deck.getName().toLowerCase() + ".name");
            if (item.func_77978_p().func_74767_n("locked")) {
                name.func_240702_b_(" (").func_230529_a_((ITextComponent)new TranslationTextComponent("item.deck.locked")).func_240702_b_(")");
            }
            item.func_200302_a((ITextComponent)name);
            int i = 0;
            for (ImmutableCard card : deck.getCards()) {
                this.func_70299_a(i, card.getItemStack(1));
                if (++i <= 60) continue;
                break;
            }
            if (!player.field_70170_p.field_72995_K) {
                for (ImmutableCard card : deck.getExtraCards()) {
                    player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "You got an extra " + new TranslationTextComponent(card.getName().toLowerCase()) + " card!"), Util.field_240973_b_);
                    ItemStack stack = card.getItemStack(1);
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    player.func_146097_a(stack, false, true);
                }
            }
            nbt.func_82580_o("deck");
            item.func_77982_d(nbt);
            this.writeInventoryToNBT(item.func_77978_p());
        }
        this.isLocked = nbt.func_74767_n("locked");
        this.readInventoryFromNBT(item.func_77978_p());
    }

    public void writeInventoryToNBT(CompoundNBT nbtDeck) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == ItemStack.field_190927_a) continue;
            CompoundNBT nbtSlot = new CompoundNBT();
            nbtSlot.func_74774_a("Slot", (byte)i);
            nbtSlot.func_218657_a("stack", (INBT)this.func_70301_a(i).serializeNBT());
            nbttaglist.add((Object)nbtSlot);
        }
        nbtDeck.func_218657_a(INVENTORY_TAG_NAME, (INBT)nbttaglist);
    }

    public void writeToBuffer(PacketBuffer buffer) {
    }

    public void readInventoryFromNBT(CompoundNBT nbtDeck) {
        ListNBT items = nbtDeck.func_150295_c(INVENTORY_TAG_NAME, 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundNBT item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70297_j_()) continue;
            this.func_70299_a(slot, ItemStack.func_199557_a((CompoundNBT)item.func_74775_l("stack")));
        }
    }

    public int func_70302_i_() {
        return 62;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return (ItemStack)this.inventory.get(p_70301_1_);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory.get(index) != ItemStack.field_190927_a) {
            if (((ItemStack)this.inventory.get(index)).func_190916_E() <= count) {
                ItemStack itemstack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(index)).func_190916_E() == 0) {
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        ((ItemStack)this.inventory.get(slot)).func_190920_e(((ItemStack)this.inventory.get(slot)).func_190916_E() - 1);
        return (ItemStack)this.inventory.get(slot);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
        this.writeInventoryToNBT(this.item.func_77978_p());
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof CardItem;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }
}

