/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffectWithOptionalFlip;
import com.pixelmonmod.tcg.duel.attack.enums.EffectLocation;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class DamageEffect
extends BaseAttackEffectWithOptionalFlip {
    private static final String[] CODES = new String[]{"SELF_DAMAGE", "OPP_DAMAGE"};
    public static final int ALL_COUNT = -1;
    private boolean onMe;
    private EffectLocation location;
    private int count;
    private int amount;

    public DamageEffect() {
        super(CODES);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (this.count != -1) {
            PlayerServerState player = server.getPlayer(this.onMe ? server.getCurrentTurn() : server.getNextTurn());
            switch (this.location) {
                case All: {
                    return SelectorHelper.generateSelectorForActiveAndBench(player, null);
                }
                case Bench: {
                    CardSelectorState state = SelectorHelper.generateSelectorForBench(player, null);
                    return state.getCardList().isEmpty() ? null : state;
                }
            }
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        return this.getSelectorState(parameters, server) == null || !parameters.isEmpty();
    }

    @Override
    public void applyOnCorrectCoinSideBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        block4: {
            block3: {
                if (this.count != -1) break block3;
                PlayerServerState player = this.onMe ? server.getPlayer(server.getCurrentTurn()) : server.getPlayer(server.getNextTurn());
                if (this.location == EffectLocation.All || this.location == EffectLocation.Active) {
                    player.getActiveCard().addDamage(card, this.amount, server);
                }
                if (this.location != EffectLocation.All && this.location != EffectLocation.Bench) break block4;
                for (PokemonCardState bench : player.getBenchCards()) {
                    if (bench == null) continue;
                    bench.addDamage(card, this.amount, server);
                }
                break block4;
            }
            for (Object parameter : parameters) {
                PokemonCardState pokemon = (PokemonCardState)parameter;
                pokemon.addDamage(pokemon, this.amount, server);
            }
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        String[] types = args[0].split("_");
        this.location = EffectLocation.Active;
        this.count = -1;
        this.onMe = types[0].equalsIgnoreCase("SELF");
        if (args.length > 2) {
            this.location = EffectLocation.getFromDbString(args[1]);
            if (!args[2].equals("*") && !args[2].equals("ALL")) {
                this.count = Integer.parseInt(args[2]);
            }
            this.amount = Integer.parseInt(args[3]);
        } else {
            this.amount = Integer.parseInt(args[1]);
        }
        return super.parse(args);
    }
}

