/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.OverworldSubBiomeData;
import corgiaoc.byg.mixin.access.BiomeAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;

public class BYGSubBiome {
    public static final List<BYGSubBiome> BYG_SUB_BIOMES = new ArrayList<BYGSubBiome>();
    private final Biome biome;

    public BYGSubBiome(Biome.Climate climate, Biome.Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_SUB_BIOMES.add(this);
    }

    public BYGSubBiome(Biome.Builder builder) {
        this.biome = builder.func_242455_a();
        BYG_SUB_BIOMES.add(this);
    }

    public BYGSubBiome(Biome biome) {
        this.biome = biome;
        BYG_SUB_BIOMES.add(this);
    }

    @Nullable
    public Biome getBeach() {
        return (Biome)WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76787_r);
    }

    @Nullable
    public Biome getEdge() {
        return null;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public Biome getRiver() {
        return (Biome)WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76781_i);
    }

    public String[] getBiomeDictionary() {
        return new String[]{"OVERWORLD"};
    }

    public RegistryKey<Biome> getKey() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_177774_c((Object)this.biome)));
    }

    public static BiomeDataHolders.OverworldSubBiomeDataHolder extractDefaultHolder() {
        HashMap<ResourceLocation, OverworldSubBiomeData> biomeData = new HashMap<ResourceLocation, OverworldSubBiomeData>();
        for (BYGSubBiome bygBiome : BYG_SUB_BIOMES) {
            biomeData.put(WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getBiome()), new OverworldSubBiomeData(Arrays.asList(bygBiome.getBiomeDictionary()), bygBiome.getEdge() != null ? WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getEdge()) : new ResourceLocation(""), bygBiome.getBeach() != null ? WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getBeach()) : new ResourceLocation(""), WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getRiver())));
        }
        return new BiomeDataHolders.OverworldSubBiomeDataHolder((Map<ResourceLocation, OverworldSubBiomeData>)biomeData);
    }
}

